# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.storage.aio import StorageManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestStorageManagementLocalUsersOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(StorageManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_local_users_list(self, resource_group):
        response = self.client.local_users.list(
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2025-06-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_local_users_get(self, resource_group):
        response = await self.client.local_users.get(
            resource_group_name=resource_group.name,
            account_name="str",
            username="str",
            api_version="2025-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_local_users_create_or_update(self, resource_group):
        response = await self.client.local_users.create_or_update(
            resource_group_name=resource_group.name,
            account_name="str",
            username="str",
            properties={
                "allowAclAuthorization": bool,
                "extendedGroups": [0],
                "groupId": 0,
                "hasSharedKey": bool,
                "hasSshKey": bool,
                "hasSshPassword": bool,
                "homeDirectory": "str",
                "id": "str",
                "isNFSv3Enabled": bool,
                "name": "str",
                "permissionScopes": [{"permissions": "str", "resourceName": "str", "service": "str"}],
                "sid": "str",
                "sshAuthorizedKeys": [{"description": "str", "key": "str"}],
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
                "userId": 0,
            },
            api_version="2025-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_local_users_delete(self, resource_group):
        response = await self.client.local_users.delete(
            resource_group_name=resource_group.name,
            account_name="str",
            username="str",
            api_version="2025-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_local_users_list_keys(self, resource_group):
        response = await self.client.local_users.list_keys(
            resource_group_name=resource_group.name,
            account_name="str",
            username="str",
            api_version="2025-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_local_users_regenerate_password(self, resource_group):
        response = await self.client.local_users.regenerate_password(
            resource_group_name=resource_group.name,
            account_name="str",
            username="str",
            api_version="2025-06-01",
        )

        # please add some check logic here by yourself
        # ...
