package schema

// SamSchema defined a JSON Schema that can be used to validate CloudFormation/SAM templates
var SamSchema = `{
    "$id": "http://json-schema.org/draft-04/schema#",
    "additionalProperties": false,
    "definitions": {
        "AWS::AutoScaling::AutoScalingGroup": {
            "additionalProperties": false,
            "properties": {
                "CreationPolicy": {
                    "type": "object"
                },
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AutoScalingGroupName": {
                            "type": "string"
                        },
                        "AvailabilityZoneDistribution": {
                            "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.AvailabilityZoneDistribution"
                        },
                        "AvailabilityZoneImpairmentPolicy": {
                            "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.AvailabilityZoneImpairmentPolicy"
                        },
                        "AvailabilityZones": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "CapacityRebalance": {
                            "type": "boolean"
                        },
                        "CapacityReservationSpecification": {
                            "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.CapacityReservationSpecification"
                        },
                        "Context": {
                            "type": "string"
                        },
                        "Cooldown": {
                            "type": "string"
                        },
                        "DefaultInstanceWarmup": {
                            "type": "number"
                        },
                        "DesiredCapacity": {
                            "type": "string"
                        },
                        "DesiredCapacityType": {
                            "type": "string"
                        },
                        "HealthCheckGracePeriod": {
                            "type": "number"
                        },
                        "HealthCheckType": {
                            "type": "string"
                        },
                        "InstanceId": {
                            "type": "string"
                        },
                        "InstanceMaintenancePolicy": {
                            "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.InstanceMaintenancePolicy"
                        },
                        "LaunchConfigurationName": {
                            "type": "string"
                        },
                        "LaunchTemplate": {
                            "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.LaunchTemplateSpecification"
                        },
                        "LifecycleHookSpecificationList": {
                            "items": {
                                "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.LifecycleHookSpecification"
                            },
                            "type": "array"
                        },
                        "LoadBalancerNames": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "MaxInstanceLifetime": {
                            "type": "number"
                        },
                        "MaxSize": {
                            "type": "string"
                        },
                        "MetricsCollection": {
                            "items": {
                                "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.MetricsCollection"
                            },
                            "type": "array"
                        },
                        "MinSize": {
                            "type": "string"
                        },
                        "MixedInstancesPolicy": {
                            "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.MixedInstancesPolicy"
                        },
                        "NewInstancesProtectedFromScaleIn": {
                            "type": "boolean"
                        },
                        "NotificationConfigurations": {
                            "items": {
                                "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.NotificationConfiguration"
                            },
                            "type": "array"
                        },
                        "PlacementGroup": {
                            "type": "string"
                        },
                        "ServiceLinkedRoleARN": {
                            "type": "string"
                        },
                        "SkipZonalShiftValidation": {
                            "type": "boolean"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.TagProperty"
                            },
                            "type": "array"
                        },
                        "TargetGroupARNs": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "TerminationPolicies": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "TrafficSources": {
                            "items": {
                                "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.TrafficSourceIdentifier"
                            },
                            "type": "array"
                        },
                        "VPCZoneIdentifier": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "MaxSize",
                        "MinSize"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AutoScaling::AutoScalingGroup"
                    ],
                    "type": "string"
                },
                "UpdatePolicy": {
                    "type": "object"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.AcceleratorCountRequest": {
            "additionalProperties": false,
            "properties": {
                "Max": {
                    "type": "number"
                },
                "Min": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.AcceleratorTotalMemoryMiBRequest": {
            "additionalProperties": false,
            "properties": {
                "Max": {
                    "type": "number"
                },
                "Min": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.AvailabilityZoneDistribution": {
            "additionalProperties": false,
            "properties": {
                "CapacityDistributionStrategy": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.AvailabilityZoneImpairmentPolicy": {
            "additionalProperties": false,
            "properties": {
                "ImpairedZoneHealthCheckBehavior": {
                    "type": "string"
                },
                "ZonalShiftEnabled": {
                    "type": "boolean"
                }
            },
            "required": [
                "ImpairedZoneHealthCheckBehavior",
                "ZonalShiftEnabled"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.BaselineEbsBandwidthMbpsRequest": {
            "additionalProperties": false,
            "properties": {
                "Max": {
                    "type": "number"
                },
                "Min": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.BaselinePerformanceFactorsRequest": {
            "additionalProperties": false,
            "properties": {
                "Cpu": {
                    "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.CpuPerformanceFactorRequest"
                }
            },
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.CapacityReservationSpecification": {
            "additionalProperties": false,
            "properties": {
                "CapacityReservationPreference": {
                    "type": "string"
                },
                "CapacityReservationTarget": {
                    "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.CapacityReservationTarget"
                }
            },
            "required": [
                "CapacityReservationPreference"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.CapacityReservationTarget": {
            "additionalProperties": false,
            "properties": {
                "CapacityReservationIds": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "CapacityReservationResourceGroupArns": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.CpuPerformanceFactorRequest": {
            "additionalProperties": false,
            "properties": {
                "References": {
                    "items": {
                        "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.PerformanceFactorReferenceRequest"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.InstanceMaintenancePolicy": {
            "additionalProperties": false,
            "properties": {
                "MaxHealthyPercentage": {
                    "type": "number"
                },
                "MinHealthyPercentage": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.InstanceRequirements": {
            "additionalProperties": false,
            "properties": {
                "AcceleratorCount": {
                    "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.AcceleratorCountRequest"
                },
                "AcceleratorManufacturers": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "AcceleratorNames": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "AcceleratorTotalMemoryMiB": {
                    "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.AcceleratorTotalMemoryMiBRequest"
                },
                "AcceleratorTypes": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "AllowedInstanceTypes": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "BareMetal": {
                    "type": "string"
                },
                "BaselineEbsBandwidthMbps": {
                    "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.BaselineEbsBandwidthMbpsRequest"
                },
                "BaselinePerformanceFactors": {
                    "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.BaselinePerformanceFactorsRequest"
                },
                "BurstablePerformance": {
                    "type": "string"
                },
                "CpuManufacturers": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "ExcludedInstanceTypes": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "InstanceGenerations": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "LocalStorage": {
                    "type": "string"
                },
                "LocalStorageTypes": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "MaxSpotPriceAsPercentageOfOptimalOnDemandPrice": {
                    "type": "number"
                },
                "MemoryGiBPerVCpu": {
                    "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.MemoryGiBPerVCpuRequest"
                },
                "MemoryMiB": {
                    "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.MemoryMiBRequest"
                },
                "NetworkBandwidthGbps": {
                    "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.NetworkBandwidthGbpsRequest"
                },
                "NetworkInterfaceCount": {
                    "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.NetworkInterfaceCountRequest"
                },
                "OnDemandMaxPricePercentageOverLowestPrice": {
                    "type": "number"
                },
                "RequireHibernateSupport": {
                    "type": "boolean"
                },
                "SpotMaxPricePercentageOverLowestPrice": {
                    "type": "number"
                },
                "TotalLocalStorageGB": {
                    "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.TotalLocalStorageGBRequest"
                },
                "VCpuCount": {
                    "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.VCpuCountRequest"
                }
            },
            "required": [
                "MemoryMiB",
                "VCpuCount"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.InstancesDistribution": {
            "additionalProperties": false,
            "properties": {
                "OnDemandAllocationStrategy": {
                    "type": "string"
                },
                "OnDemandBaseCapacity": {
                    "type": "number"
                },
                "OnDemandPercentageAboveBaseCapacity": {
                    "type": "number"
                },
                "SpotAllocationStrategy": {
                    "type": "string"
                },
                "SpotInstancePools": {
                    "type": "number"
                },
                "SpotMaxPrice": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.LaunchTemplate": {
            "additionalProperties": false,
            "properties": {
                "LaunchTemplateSpecification": {
                    "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.LaunchTemplateSpecification"
                },
                "Overrides": {
                    "items": {
                        "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.LaunchTemplateOverrides"
                    },
                    "type": "array"
                }
            },
            "required": [
                "LaunchTemplateSpecification"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.LaunchTemplateOverrides": {
            "additionalProperties": false,
            "properties": {
                "InstanceRequirements": {
                    "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.InstanceRequirements"
                },
                "InstanceType": {
                    "type": "string"
                },
                "LaunchTemplateSpecification": {
                    "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.LaunchTemplateSpecification"
                },
                "WeightedCapacity": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.LaunchTemplateSpecification": {
            "additionalProperties": false,
            "properties": {
                "LaunchTemplateId": {
                    "type": "string"
                },
                "LaunchTemplateName": {
                    "type": "string"
                },
                "Version": {
                    "type": "string"
                }
            },
            "required": [
                "Version"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.LifecycleHookSpecification": {
            "additionalProperties": false,
            "properties": {
                "DefaultResult": {
                    "type": "string"
                },
                "HeartbeatTimeout": {
                    "type": "number"
                },
                "LifecycleHookName": {
                    "type": "string"
                },
                "LifecycleTransition": {
                    "type": "string"
                },
                "NotificationMetadata": {
                    "type": "string"
                },
                "NotificationTargetARN": {
                    "type": "string"
                },
                "RoleARN": {
                    "type": "string"
                }
            },
            "required": [
                "LifecycleHookName",
                "LifecycleTransition"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.MemoryGiBPerVCpuRequest": {
            "additionalProperties": false,
            "properties": {
                "Max": {
                    "type": "number"
                },
                "Min": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.MemoryMiBRequest": {
            "additionalProperties": false,
            "properties": {
                "Max": {
                    "type": "number"
                },
                "Min": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.MetricsCollection": {
            "additionalProperties": false,
            "properties": {
                "Granularity": {
                    "type": "string"
                },
                "Metrics": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Granularity"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.MixedInstancesPolicy": {
            "additionalProperties": false,
            "properties": {
                "InstancesDistribution": {
                    "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.InstancesDistribution"
                },
                "LaunchTemplate": {
                    "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.LaunchTemplate"
                }
            },
            "required": [
                "LaunchTemplate"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.NetworkBandwidthGbpsRequest": {
            "additionalProperties": false,
            "properties": {
                "Max": {
                    "type": "number"
                },
                "Min": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.NetworkInterfaceCountRequest": {
            "additionalProperties": false,
            "properties": {
                "Max": {
                    "type": "number"
                },
                "Min": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.NotificationConfiguration": {
            "additionalProperties": false,
            "properties": {
                "NotificationTypes": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "TopicARN": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "TopicARN"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.PerformanceFactorReferenceRequest": {
            "additionalProperties": false,
            "properties": {
                "InstanceFamily": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.TagProperty": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "PropagateAtLaunch": {
                    "type": "boolean"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Key",
                "PropagateAtLaunch",
                "Value"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.TotalLocalStorageGBRequest": {
            "additionalProperties": false,
            "properties": {
                "Max": {
                    "type": "number"
                },
                "Min": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.TrafficSourceIdentifier": {
            "additionalProperties": false,
            "properties": {
                "Identifier": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Identifier",
                "Type"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.VCpuCountRequest": {
            "additionalProperties": false,
            "properties": {
                "Max": {
                    "type": "number"
                },
                "Min": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::AutoScaling::LaunchConfiguration": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AssociatePublicIpAddress": {
                            "type": "boolean"
                        },
                        "BlockDeviceMappings": {
                            "items": {
                                "$ref": "#/definitions/AWS::AutoScaling::LaunchConfiguration.BlockDeviceMapping"
                            },
                            "type": "array"
                        },
                        "ClassicLinkVPCId": {
                            "type": "string"
                        },
                        "ClassicLinkVPCSecurityGroups": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "EbsOptimized": {
                            "type": "boolean"
                        },
                        "IamInstanceProfile": {
                            "type": "string"
                        },
                        "ImageId": {
                            "type": "string"
                        },
                        "InstanceId": {
                            "type": "string"
                        },
                        "InstanceMonitoring": {
                            "type": "boolean"
                        },
                        "InstanceType": {
                            "type": "string"
                        },
                        "KernelId": {
                            "type": "string"
                        },
                        "KeyName": {
                            "type": "string"
                        },
                        "LaunchConfigurationName": {
                            "type": "string"
                        },
                        "MetadataOptions": {
                            "$ref": "#/definitions/AWS::AutoScaling::LaunchConfiguration.MetadataOptions"
                        },
                        "PlacementTenancy": {
                            "type": "string"
                        },
                        "RamDiskId": {
                            "type": "string"
                        },
                        "SecurityGroups": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "SpotPrice": {
                            "type": "string"
                        },
                        "UserData": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ImageId",
                        "InstanceType"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AutoScaling::LaunchConfiguration"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::LaunchConfiguration.BlockDevice": {
            "additionalProperties": false,
            "properties": {
                "DeleteOnTermination": {
                    "type": "boolean"
                },
                "Encrypted": {
                    "type": "boolean"
                },
                "Iops": {
                    "type": "number"
                },
                "SnapshotId": {
                    "type": "string"
                },
                "Throughput": {
                    "type": "number"
                },
                "VolumeSize": {
                    "type": "number"
                },
                "VolumeType": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AutoScaling::LaunchConfiguration.BlockDeviceMapping": {
            "additionalProperties": false,
            "properties": {
                "DeviceName": {
                    "type": "string"
                },
                "Ebs": {
                    "$ref": "#/definitions/AWS::AutoScaling::LaunchConfiguration.BlockDevice"
                },
                "NoDevice": {
                    "type": "boolean"
                },
                "VirtualName": {
                    "type": "string"
                }
            },
            "required": [
                "DeviceName"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::LaunchConfiguration.MetadataOptions": {
            "additionalProperties": false,
            "properties": {
                "HttpEndpoint": {
                    "type": "string"
                },
                "HttpPutResponseHopLimit": {
                    "type": "number"
                },
                "HttpTokens": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AutoScaling::LifecycleHook": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AutoScalingGroupName": {
                            "type": "string"
                        },
                        "DefaultResult": {
                            "type": "string"
                        },
                        "HeartbeatTimeout": {
                            "type": "number"
                        },
                        "LifecycleHookName": {
                            "type": "string"
                        },
                        "LifecycleTransition": {
                            "type": "string"
                        },
                        "NotificationMetadata": {
                            "type": "string"
                        },
                        "NotificationTargetARN": {
                            "type": "string"
                        },
                        "RoleARN": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "AutoScalingGroupName",
                        "LifecycleTransition"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AutoScaling::LifecycleHook"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::ScalingPolicy": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AdjustmentType": {
                            "type": "string"
                        },
                        "AutoScalingGroupName": {
                            "type": "string"
                        },
                        "Cooldown": {
                            "type": "string"
                        },
                        "EstimatedInstanceWarmup": {
                            "type": "number"
                        },
                        "MetricAggregationType": {
                            "type": "string"
                        },
                        "MinAdjustmentMagnitude": {
                            "type": "number"
                        },
                        "PolicyType": {
                            "type": "string"
                        },
                        "PredictiveScalingConfiguration": {
                            "$ref": "#/definitions/AWS::AutoScaling::ScalingPolicy.PredictiveScalingConfiguration"
                        },
                        "ScalingAdjustment": {
                            "type": "number"
                        },
                        "StepAdjustments": {
                            "items": {
                                "$ref": "#/definitions/AWS::AutoScaling::ScalingPolicy.StepAdjustment"
                            },
                            "type": "array"
                        },
                        "TargetTrackingConfiguration": {
                            "$ref": "#/definitions/AWS::AutoScaling::ScalingPolicy.TargetTrackingConfiguration"
                        }
                    },
                    "required": [
                        "AutoScalingGroupName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AutoScaling::ScalingPolicy"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::ScalingPolicy.CustomizedMetricSpecification": {
            "additionalProperties": false,
            "properties": {
                "Dimensions": {
                    "items": {
                        "$ref": "#/definitions/AWS::AutoScaling::ScalingPolicy.MetricDimension"
                    },
                    "type": "array"
                },
                "MetricName": {
                    "type": "string"
                },
                "Metrics": {
                    "items": {
                        "$ref": "#/definitions/AWS::AutoScaling::ScalingPolicy.TargetTrackingMetricDataQuery"
                    },
                    "type": "array"
                },
                "Namespace": {
                    "type": "string"
                },
                "Period": {
                    "type": "number"
                },
                "Statistic": {
                    "type": "string"
                },
                "Unit": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AutoScaling::ScalingPolicy.Metric": {
            "additionalProperties": false,
            "properties": {
                "Dimensions": {
                    "items": {
                        "$ref": "#/definitions/AWS::AutoScaling::ScalingPolicy.MetricDimension"
                    },
                    "type": "array"
                },
                "MetricName": {
                    "type": "string"
                },
                "Namespace": {
                    "type": "string"
                }
            },
            "required": [
                "MetricName",
                "Namespace"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::ScalingPolicy.MetricDataQuery": {
            "additionalProperties": false,
            "properties": {
                "Expression": {
                    "type": "string"
                },
                "Id": {
                    "type": "string"
                },
                "Label": {
                    "type": "string"
                },
                "MetricStat": {
                    "$ref": "#/definitions/AWS::AutoScaling::ScalingPolicy.MetricStat"
                },
                "ReturnData": {
                    "type": "boolean"
                }
            },
            "required": [
                "Id"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::ScalingPolicy.MetricDimension": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Name",
                "Value"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::ScalingPolicy.MetricStat": {
            "additionalProperties": false,
            "properties": {
                "Metric": {
                    "$ref": "#/definitions/AWS::AutoScaling::ScalingPolicy.Metric"
                },
                "Stat": {
                    "type": "string"
                },
                "Unit": {
                    "type": "string"
                }
            },
            "required": [
                "Metric",
                "Stat"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::ScalingPolicy.PredefinedMetricSpecification": {
            "additionalProperties": false,
            "properties": {
                "PredefinedMetricType": {
                    "type": "string"
                },
                "ResourceLabel": {
                    "type": "string"
                }
            },
            "required": [
                "PredefinedMetricType"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::ScalingPolicy.PredictiveScalingConfiguration": {
            "additionalProperties": false,
            "properties": {
                "MaxCapacityBreachBehavior": {
                    "type": "string"
                },
                "MaxCapacityBuffer": {
                    "type": "number"
                },
                "MetricSpecifications": {
                    "items": {
                        "$ref": "#/definitions/AWS::AutoScaling::ScalingPolicy.PredictiveScalingMetricSpecification"
                    },
                    "type": "array"
                },
                "Mode": {
                    "type": "string"
                },
                "SchedulingBufferTime": {
                    "type": "number"
                }
            },
            "required": [
                "MetricSpecifications"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::ScalingPolicy.PredictiveScalingCustomizedCapacityMetric": {
            "additionalProperties": false,
            "properties": {
                "MetricDataQueries": {
                    "items": {
                        "$ref": "#/definitions/AWS::AutoScaling::ScalingPolicy.MetricDataQuery"
                    },
                    "type": "array"
                }
            },
            "required": [
                "MetricDataQueries"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::ScalingPolicy.PredictiveScalingCustomizedLoadMetric": {
            "additionalProperties": false,
            "properties": {
                "MetricDataQueries": {
                    "items": {
                        "$ref": "#/definitions/AWS::AutoScaling::ScalingPolicy.MetricDataQuery"
                    },
                    "type": "array"
                }
            },
            "required": [
                "MetricDataQueries"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::ScalingPolicy.PredictiveScalingCustomizedScalingMetric": {
            "additionalProperties": false,
            "properties": {
                "MetricDataQueries": {
                    "items": {
                        "$ref": "#/definitions/AWS::AutoScaling::ScalingPolicy.MetricDataQuery"
                    },
                    "type": "array"
                }
            },
            "required": [
                "MetricDataQueries"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::ScalingPolicy.PredictiveScalingMetricSpecification": {
            "additionalProperties": false,
            "properties": {
                "CustomizedCapacityMetricSpecification": {
                    "$ref": "#/definitions/AWS::AutoScaling::ScalingPolicy.PredictiveScalingCustomizedCapacityMetric"
                },
                "CustomizedLoadMetricSpecification": {
                    "$ref": "#/definitions/AWS::AutoScaling::ScalingPolicy.PredictiveScalingCustomizedLoadMetric"
                },
                "CustomizedScalingMetricSpecification": {
                    "$ref": "#/definitions/AWS::AutoScaling::ScalingPolicy.PredictiveScalingCustomizedScalingMetric"
                },
                "PredefinedLoadMetricSpecification": {
                    "$ref": "#/definitions/AWS::AutoScaling::ScalingPolicy.PredictiveScalingPredefinedLoadMetric"
                },
                "PredefinedMetricPairSpecification": {
                    "$ref": "#/definitions/AWS::AutoScaling::ScalingPolicy.PredictiveScalingPredefinedMetricPair"
                },
                "PredefinedScalingMetricSpecification": {
                    "$ref": "#/definitions/AWS::AutoScaling::ScalingPolicy.PredictiveScalingPredefinedScalingMetric"
                },
                "TargetValue": {
                    "type": "number"
                }
            },
            "required": [
                "TargetValue"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::ScalingPolicy.PredictiveScalingPredefinedLoadMetric": {
            "additionalProperties": false,
            "properties": {
                "PredefinedMetricType": {
                    "type": "string"
                },
                "ResourceLabel": {
                    "type": "string"
                }
            },
            "required": [
                "PredefinedMetricType"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::ScalingPolicy.PredictiveScalingPredefinedMetricPair": {
            "additionalProperties": false,
            "properties": {
                "PredefinedMetricType": {
                    "type": "string"
                },
                "ResourceLabel": {
                    "type": "string"
                }
            },
            "required": [
                "PredefinedMetricType"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::ScalingPolicy.PredictiveScalingPredefinedScalingMetric": {
            "additionalProperties": false,
            "properties": {
                "PredefinedMetricType": {
                    "type": "string"
                },
                "ResourceLabel": {
                    "type": "string"
                }
            },
            "required": [
                "PredefinedMetricType"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::ScalingPolicy.StepAdjustment": {
            "additionalProperties": false,
            "properties": {
                "MetricIntervalLowerBound": {
                    "type": "number"
                },
                "MetricIntervalUpperBound": {
                    "type": "number"
                },
                "ScalingAdjustment": {
                    "type": "number"
                }
            },
            "required": [
                "ScalingAdjustment"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::ScalingPolicy.TargetTrackingConfiguration": {
            "additionalProperties": false,
            "properties": {
                "CustomizedMetricSpecification": {
                    "$ref": "#/definitions/AWS::AutoScaling::ScalingPolicy.CustomizedMetricSpecification"
                },
                "DisableScaleIn": {
                    "type": "boolean"
                },
                "PredefinedMetricSpecification": {
                    "$ref": "#/definitions/AWS::AutoScaling::ScalingPolicy.PredefinedMetricSpecification"
                },
                "TargetValue": {
                    "type": "number"
                }
            },
            "required": [
                "TargetValue"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::ScalingPolicy.TargetTrackingMetricDataQuery": {
            "additionalProperties": false,
            "properties": {
                "Expression": {
                    "type": "string"
                },
                "Id": {
                    "type": "string"
                },
                "Label": {
                    "type": "string"
                },
                "MetricStat": {
                    "$ref": "#/definitions/AWS::AutoScaling::ScalingPolicy.TargetTrackingMetricStat"
                },
                "Period": {
                    "type": "number"
                },
                "ReturnData": {
                    "type": "boolean"
                }
            },
            "required": [
                "Id"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::ScalingPolicy.TargetTrackingMetricStat": {
            "additionalProperties": false,
            "properties": {
                "Metric": {
                    "$ref": "#/definitions/AWS::AutoScaling::ScalingPolicy.Metric"
                },
                "Period": {
                    "type": "number"
                },
                "Stat": {
                    "type": "string"
                },
                "Unit": {
                    "type": "string"
                }
            },
            "required": [
                "Metric",
                "Stat"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::ScheduledAction": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AutoScalingGroupName": {
                            "type": "string"
                        },
                        "DesiredCapacity": {
                            "type": "number"
                        },
                        "EndTime": {
                            "type": "string"
                        },
                        "MaxSize": {
                            "type": "number"
                        },
                        "MinSize": {
                            "type": "number"
                        },
                        "Recurrence": {
                            "type": "string"
                        },
                        "StartTime": {
                            "type": "string"
                        },
                        "TimeZone": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "AutoScalingGroupName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AutoScaling::ScheduledAction"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::WarmPool": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AutoScalingGroupName": {
                            "type": "string"
                        },
                        "InstanceReusePolicy": {
                            "$ref": "#/definitions/AWS::AutoScaling::WarmPool.InstanceReusePolicy"
                        },
                        "MaxGroupPreparedCapacity": {
                            "type": "number"
                        },
                        "MinSize": {
                            "type": "number"
                        },
                        "PoolState": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "AutoScalingGroupName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AutoScaling::WarmPool"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::WarmPool.InstanceReusePolicy": {
            "additionalProperties": false,
            "properties": {
                "ReuseOnScaleIn": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::CloudFormation::CustomResource": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ServiceTimeout": {
                            "type": "number"
                        },
                        "ServiceToken": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ServiceToken"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFormation::CustomResource"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::GuardHook": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Alias": {
                            "type": "string"
                        },
                        "ExecutionRole": {
                            "type": "string"
                        },
                        "FailureMode": {
                            "type": "string"
                        },
                        "HookStatus": {
                            "type": "string"
                        },
                        "LogBucket": {
                            "type": "string"
                        },
                        "Options": {
                            "$ref": "#/definitions/AWS::CloudFormation::GuardHook.Options"
                        },
                        "RuleLocation": {
                            "$ref": "#/definitions/AWS::CloudFormation::GuardHook.S3Location"
                        },
                        "StackFilters": {
                            "$ref": "#/definitions/AWS::CloudFormation::GuardHook.StackFilters"
                        },
                        "TargetFilters": {
                            "$ref": "#/definitions/AWS::CloudFormation::GuardHook.TargetFilters"
                        },
                        "TargetOperations": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "Alias",
                        "ExecutionRole",
                        "FailureMode",
                        "HookStatus",
                        "RuleLocation",
                        "TargetOperations"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFormation::GuardHook"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::GuardHook.HookTarget": {
            "additionalProperties": false,
            "properties": {
                "Action": {
                    "type": "string"
                },
                "InvocationPoint": {
                    "type": "string"
                },
                "TargetName": {
                    "type": "string"
                }
            },
            "required": [
                "Action",
                "InvocationPoint",
                "TargetName"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::GuardHook.Options": {
            "additionalProperties": false,
            "properties": {
                "InputParams": {
                    "$ref": "#/definitions/AWS::CloudFormation::GuardHook.S3Location"
                }
            },
            "type": "object"
        },
        "AWS::CloudFormation::GuardHook.S3Location": {
            "additionalProperties": false,
            "properties": {
                "Uri": {
                    "type": "string"
                },
                "VersionId": {
                    "type": "string"
                }
            },
            "required": [
                "Uri"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::GuardHook.StackFilters": {
            "additionalProperties": false,
            "properties": {
                "FilteringCriteria": {
                    "type": "string"
                },
                "StackNames": {
                    "$ref": "#/definitions/AWS::CloudFormation::GuardHook.StackNames"
                },
                "StackRoles": {
                    "$ref": "#/definitions/AWS::CloudFormation::GuardHook.StackRoles"
                }
            },
            "required": [
                "FilteringCriteria"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::GuardHook.StackNames": {
            "additionalProperties": false,
            "properties": {
                "Exclude": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Include": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::CloudFormation::GuardHook.StackRoles": {
            "additionalProperties": false,
            "properties": {
                "Exclude": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Include": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::CloudFormation::GuardHook.TargetFilters": {
            "additionalProperties": false,
            "properties": {
                "Actions": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "InvocationPoints": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "TargetNames": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Targets": {
                    "items": {
                        "$ref": "#/definitions/AWS::CloudFormation::GuardHook.HookTarget"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::CloudFormation::HookDefaultVersion": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "TypeName": {
                            "type": "string"
                        },
                        "TypeVersionArn": {
                            "type": "string"
                        },
                        "VersionId": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFormation::HookDefaultVersion"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::HookTypeConfig": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Configuration": {
                            "type": "string"
                        },
                        "ConfigurationAlias": {
                            "type": "string"
                        },
                        "TypeArn": {
                            "type": "string"
                        },
                        "TypeName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Configuration"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFormation::HookTypeConfig"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::HookVersion": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ExecutionRoleArn": {
                            "type": "string"
                        },
                        "LoggingConfig": {
                            "$ref": "#/definitions/AWS::CloudFormation::HookVersion.LoggingConfig"
                        },
                        "SchemaHandlerPackage": {
                            "type": "string"
                        },
                        "TypeName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "SchemaHandlerPackage",
                        "TypeName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFormation::HookVersion"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::HookVersion.LoggingConfig": {
            "additionalProperties": false,
            "properties": {
                "LogGroupName": {
                    "type": "string"
                },
                "LogRoleArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CloudFormation::LambdaHook": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Alias": {
                            "type": "string"
                        },
                        "ExecutionRole": {
                            "type": "string"
                        },
                        "FailureMode": {
                            "type": "string"
                        },
                        "HookStatus": {
                            "type": "string"
                        },
                        "LambdaFunction": {
                            "type": "string"
                        },
                        "StackFilters": {
                            "$ref": "#/definitions/AWS::CloudFormation::LambdaHook.StackFilters"
                        },
                        "TargetFilters": {
                            "$ref": "#/definitions/AWS::CloudFormation::LambdaHook.TargetFilters"
                        },
                        "TargetOperations": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "Alias",
                        "ExecutionRole",
                        "FailureMode",
                        "HookStatus",
                        "LambdaFunction",
                        "TargetOperations"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFormation::LambdaHook"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::LambdaHook.HookTarget": {
            "additionalProperties": false,
            "properties": {
                "Action": {
                    "type": "string"
                },
                "InvocationPoint": {
                    "type": "string"
                },
                "TargetName": {
                    "type": "string"
                }
            },
            "required": [
                "Action",
                "InvocationPoint",
                "TargetName"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::LambdaHook.StackFilters": {
            "additionalProperties": false,
            "properties": {
                "FilteringCriteria": {
                    "type": "string"
                },
                "StackNames": {
                    "$ref": "#/definitions/AWS::CloudFormation::LambdaHook.StackNames"
                },
                "StackRoles": {
                    "$ref": "#/definitions/AWS::CloudFormation::LambdaHook.StackRoles"
                }
            },
            "required": [
                "FilteringCriteria"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::LambdaHook.StackNames": {
            "additionalProperties": false,
            "properties": {
                "Exclude": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Include": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::CloudFormation::LambdaHook.StackRoles": {
            "additionalProperties": false,
            "properties": {
                "Exclude": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Include": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::CloudFormation::LambdaHook.TargetFilters": {
            "additionalProperties": false,
            "properties": {
                "Actions": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "InvocationPoints": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "TargetNames": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Targets": {
                    "items": {
                        "$ref": "#/definitions/AWS::CloudFormation::LambdaHook.HookTarget"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::CloudFormation::Macro": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "FunctionName": {
                            "type": "string"
                        },
                        "LogGroupName": {
                            "type": "string"
                        },
                        "LogRoleARN": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "FunctionName",
                        "Name"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFormation::Macro"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::ModuleDefaultVersion": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Arn": {
                            "type": "string"
                        },
                        "ModuleName": {
                            "type": "string"
                        },
                        "VersionId": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFormation::ModuleDefaultVersion"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::ModuleVersion": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ModuleName": {
                            "type": "string"
                        },
                        "ModulePackage": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ModuleName",
                        "ModulePackage"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFormation::ModuleVersion"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::PublicTypeVersion": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Arn": {
                            "type": "string"
                        },
                        "LogDeliveryBucket": {
                            "type": "string"
                        },
                        "PublicVersionNumber": {
                            "type": "string"
                        },
                        "Type": {
                            "type": "string"
                        },
                        "TypeName": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFormation::PublicTypeVersion"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::Publisher": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AcceptTermsAndConditions": {
                            "type": "boolean"
                        },
                        "ConnectionArn": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "AcceptTermsAndConditions"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFormation::Publisher"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::ResourceDefaultVersion": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "TypeName": {
                            "type": "string"
                        },
                        "TypeVersionArn": {
                            "type": "string"
                        },
                        "VersionId": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFormation::ResourceDefaultVersion"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::ResourceVersion": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ExecutionRoleArn": {
                            "type": "string"
                        },
                        "LoggingConfig": {
                            "$ref": "#/definitions/AWS::CloudFormation::ResourceVersion.LoggingConfig"
                        },
                        "SchemaHandlerPackage": {
                            "type": "string"
                        },
                        "TypeName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "SchemaHandlerPackage",
                        "TypeName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFormation::ResourceVersion"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::ResourceVersion.LoggingConfig": {
            "additionalProperties": false,
            "properties": {
                "LogGroupName": {
                    "type": "string"
                },
                "LogRoleArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CloudFormation::Stack": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "NotificationARNs": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Parameters": {
                            "additionalProperties": true,
                            "patternProperties": {
                                "^[a-zA-Z0-9]+$": {
                                    "type": "string"
                                }
                            },
                            "type": "object"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "TemplateURL": {
                            "type": "string"
                        },
                        "TimeoutInMinutes": {
                            "type": "number"
                        }
                    },
                    "required": [
                        "TemplateURL"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFormation::Stack"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::StackSet": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AdministrationRoleARN": {
                            "type": "string"
                        },
                        "AutoDeployment": {
                            "$ref": "#/definitions/AWS::CloudFormation::StackSet.AutoDeployment"
                        },
                        "CallAs": {
                            "type": "string"
                        },
                        "Capabilities": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "ExecutionRoleName": {
                            "type": "string"
                        },
                        "ManagedExecution": {
                            "$ref": "#/definitions/AWS::CloudFormation::StackSet.ManagedExecution"
                        },
                        "OperationPreferences": {
                            "$ref": "#/definitions/AWS::CloudFormation::StackSet.OperationPreferences"
                        },
                        "Parameters": {
                            "items": {
                                "$ref": "#/definitions/AWS::CloudFormation::StackSet.Parameter"
                            },
                            "type": "array"
                        },
                        "PermissionModel": {
                            "type": "string"
                        },
                        "StackInstancesGroup": {
                            "items": {
                                "$ref": "#/definitions/AWS::CloudFormation::StackSet.StackInstances"
                            },
                            "type": "array"
                        },
                        "StackSetName": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "TemplateBody": {
                            "type": "string"
                        },
                        "TemplateURL": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "PermissionModel",
                        "StackSetName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFormation::StackSet"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::StackSet.AutoDeployment": {
            "additionalProperties": false,
            "properties": {
                "Enabled": {
                    "type": "boolean"
                },
                "RetainStacksOnAccountRemoval": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::CloudFormation::StackSet.DeploymentTargets": {
            "additionalProperties": false,
            "properties": {
                "AccountFilterType": {
                    "type": "string"
                },
                "Accounts": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "AccountsUrl": {
                    "type": "string"
                },
                "OrganizationalUnitIds": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::CloudFormation::StackSet.ManagedExecution": {
            "additionalProperties": false,
            "properties": {
                "Active": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::CloudFormation::StackSet.OperationPreferences": {
            "additionalProperties": false,
            "properties": {
                "ConcurrencyMode": {
                    "type": "string"
                },
                "FailureToleranceCount": {
                    "type": "number"
                },
                "FailureTolerancePercentage": {
                    "type": "number"
                },
                "MaxConcurrentCount": {
                    "type": "number"
                },
                "MaxConcurrentPercentage": {
                    "type": "number"
                },
                "RegionConcurrencyType": {
                    "type": "string"
                },
                "RegionOrder": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::CloudFormation::StackSet.Parameter": {
            "additionalProperties": false,
            "properties": {
                "ParameterKey": {
                    "type": "string"
                },
                "ParameterValue": {
                    "type": "string"
                }
            },
            "required": [
                "ParameterKey",
                "ParameterValue"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::StackSet.StackInstances": {
            "additionalProperties": false,
            "properties": {
                "DeploymentTargets": {
                    "$ref": "#/definitions/AWS::CloudFormation::StackSet.DeploymentTargets"
                },
                "ParameterOverrides": {
                    "items": {
                        "$ref": "#/definitions/AWS::CloudFormation::StackSet.Parameter"
                    },
                    "type": "array"
                },
                "Regions": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "DeploymentTargets",
                "Regions"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::TypeActivation": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AutoUpdate": {
                            "type": "boolean"
                        },
                        "ExecutionRoleArn": {
                            "type": "string"
                        },
                        "LoggingConfig": {
                            "$ref": "#/definitions/AWS::CloudFormation::TypeActivation.LoggingConfig"
                        },
                        "MajorVersion": {
                            "type": "string"
                        },
                        "PublicTypeArn": {
                            "type": "string"
                        },
                        "PublisherId": {
                            "type": "string"
                        },
                        "Type": {
                            "type": "string"
                        },
                        "TypeName": {
                            "type": "string"
                        },
                        "TypeNameAlias": {
                            "type": "string"
                        },
                        "VersionBump": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFormation::TypeActivation"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::TypeActivation.LoggingConfig": {
            "additionalProperties": false,
            "properties": {
                "LogGroupName": {
                    "type": "string"
                },
                "LogRoleArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CloudFormation::WaitCondition": {
            "additionalProperties": false,
            "properties": {
                "CreationPolicy": {
                    "type": "object"
                },
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Count": {
                            "type": "number"
                        },
                        "Handle": {
                            "type": "string"
                        },
                        "Timeout": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFormation::WaitCondition"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::WaitConditionHandle": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {},
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFormation::WaitConditionHandle"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::CloudWatch::Alarm": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ActionsEnabled": {
                            "type": "boolean"
                        },
                        "AlarmActions": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "AlarmDescription": {
                            "type": "string"
                        },
                        "AlarmName": {
                            "type": "string"
                        },
                        "ComparisonOperator": {
                            "type": "string"
                        },
                        "DatapointsToAlarm": {
                            "type": "number"
                        },
                        "Dimensions": {
                            "items": {
                                "$ref": "#/definitions/AWS::CloudWatch::Alarm.Dimension"
                            },
                            "type": "array"
                        },
                        "EvaluateLowSampleCountPercentile": {
                            "type": "string"
                        },
                        "EvaluationPeriods": {
                            "type": "number"
                        },
                        "ExtendedStatistic": {
                            "type": "string"
                        },
                        "InsufficientDataActions": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "MetricName": {
                            "type": "string"
                        },
                        "Metrics": {
                            "items": {
                                "$ref": "#/definitions/AWS::CloudWatch::Alarm.MetricDataQuery"
                            },
                            "type": "array"
                        },
                        "Namespace": {
                            "type": "string"
                        },
                        "OKActions": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Period": {
                            "type": "number"
                        },
                        "Statistic": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "Threshold": {
                            "type": "number"
                        },
                        "ThresholdMetricId": {
                            "type": "string"
                        },
                        "TreatMissingData": {
                            "type": "string"
                        },
                        "Unit": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ComparisonOperator",
                        "EvaluationPeriods"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudWatch::Alarm"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudWatch::Alarm.Dimension": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Name",
                "Value"
            ],
            "type": "object"
        },
        "AWS::CloudWatch::Alarm.Metric": {
            "additionalProperties": false,
            "properties": {
                "Dimensions": {
                    "items": {
                        "$ref": "#/definitions/AWS::CloudWatch::Alarm.Dimension"
                    },
                    "type": "array"
                },
                "MetricName": {
                    "type": "string"
                },
                "Namespace": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CloudWatch::Alarm.MetricDataQuery": {
            "additionalProperties": false,
            "properties": {
                "AccountId": {
                    "type": "string"
                },
                "Expression": {
                    "type": "string"
                },
                "Id": {
                    "type": "string"
                },
                "Label": {
                    "type": "string"
                },
                "MetricStat": {
                    "$ref": "#/definitions/AWS::CloudWatch::Alarm.MetricStat"
                },
                "Period": {
                    "type": "number"
                },
                "ReturnData": {
                    "type": "boolean"
                }
            },
            "required": [
                "Id"
            ],
            "type": "object"
        },
        "AWS::CloudWatch::Alarm.MetricStat": {
            "additionalProperties": false,
            "properties": {
                "Metric": {
                    "$ref": "#/definitions/AWS::CloudWatch::Alarm.Metric"
                },
                "Period": {
                    "type": "number"
                },
                "Stat": {
                    "type": "string"
                },
                "Unit": {
                    "type": "string"
                }
            },
            "required": [
                "Metric",
                "Period",
                "Stat"
            ],
            "type": "object"
        },
        "AWS::CloudWatch::AnomalyDetector": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Configuration": {
                            "$ref": "#/definitions/AWS::CloudWatch::AnomalyDetector.Configuration"
                        },
                        "Dimensions": {
                            "items": {
                                "$ref": "#/definitions/AWS::CloudWatch::AnomalyDetector.Dimension"
                            },
                            "type": "array"
                        },
                        "MetricCharacteristics": {
                            "$ref": "#/definitions/AWS::CloudWatch::AnomalyDetector.MetricCharacteristics"
                        },
                        "MetricMathAnomalyDetector": {
                            "$ref": "#/definitions/AWS::CloudWatch::AnomalyDetector.MetricMathAnomalyDetector"
                        },
                        "MetricName": {
                            "type": "string"
                        },
                        "Namespace": {
                            "type": "string"
                        },
                        "SingleMetricAnomalyDetector": {
                            "$ref": "#/definitions/AWS::CloudWatch::AnomalyDetector.SingleMetricAnomalyDetector"
                        },
                        "Stat": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudWatch::AnomalyDetector"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::CloudWatch::AnomalyDetector.Configuration": {
            "additionalProperties": false,
            "properties": {
                "ExcludedTimeRanges": {
                    "items": {
                        "$ref": "#/definitions/AWS::CloudWatch::AnomalyDetector.Range"
                    },
                    "type": "array"
                },
                "MetricTimeZone": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CloudWatch::AnomalyDetector.Dimension": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Name",
                "Value"
            ],
            "type": "object"
        },
        "AWS::CloudWatch::AnomalyDetector.Metric": {
            "additionalProperties": false,
            "properties": {
                "Dimensions": {
                    "items": {
                        "$ref": "#/definitions/AWS::CloudWatch::AnomalyDetector.Dimension"
                    },
                    "type": "array"
                },
                "MetricName": {
                    "type": "string"
                },
                "Namespace": {
                    "type": "string"
                }
            },
            "required": [
                "MetricName",
                "Namespace"
            ],
            "type": "object"
        },
        "AWS::CloudWatch::AnomalyDetector.MetricCharacteristics": {
            "additionalProperties": false,
            "properties": {
                "PeriodicSpikes": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::CloudWatch::AnomalyDetector.MetricDataQueries": {
            "additionalProperties": false,
            "properties": {},
            "type": "object"
        },
        "AWS::CloudWatch::AnomalyDetector.MetricDataQuery": {
            "additionalProperties": false,
            "properties": {
                "AccountId": {
                    "type": "string"
                },
                "Expression": {
                    "type": "string"
                },
                "Id": {
                    "type": "string"
                },
                "Label": {
                    "type": "string"
                },
                "MetricStat": {
                    "$ref": "#/definitions/AWS::CloudWatch::AnomalyDetector.MetricStat"
                },
                "Period": {
                    "type": "number"
                },
                "ReturnData": {
                    "type": "boolean"
                }
            },
            "required": [
                "Id"
            ],
            "type": "object"
        },
        "AWS::CloudWatch::AnomalyDetector.MetricMathAnomalyDetector": {
            "additionalProperties": false,
            "properties": {
                "MetricDataQueries": {
                    "items": {
                        "$ref": "#/definitions/AWS::CloudWatch::AnomalyDetector.MetricDataQuery"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::CloudWatch::AnomalyDetector.MetricStat": {
            "additionalProperties": false,
            "properties": {
                "Metric": {
                    "$ref": "#/definitions/AWS::CloudWatch::AnomalyDetector.Metric"
                },
                "Period": {
                    "type": "number"
                },
                "Stat": {
                    "type": "string"
                },
                "Unit": {
                    "type": "string"
                }
            },
            "required": [
                "Metric",
                "Period",
                "Stat"
            ],
            "type": "object"
        },
        "AWS::CloudWatch::AnomalyDetector.Range": {
            "additionalProperties": false,
            "properties": {
                "EndTime": {
                    "type": "string"
                },
                "StartTime": {
                    "type": "string"
                }
            },
            "required": [
                "EndTime",
                "StartTime"
            ],
            "type": "object"
        },
        "AWS::CloudWatch::AnomalyDetector.SingleMetricAnomalyDetector": {
            "additionalProperties": false,
            "properties": {
                "AccountId": {
                    "type": "string"
                },
                "Dimensions": {
                    "items": {
                        "$ref": "#/definitions/AWS::CloudWatch::AnomalyDetector.Dimension"
                    },
                    "type": "array"
                },
                "MetricName": {
                    "type": "string"
                },
                "Namespace": {
                    "type": "string"
                },
                "Stat": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CloudWatch::CompositeAlarm": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ActionsEnabled": {
                            "type": "boolean"
                        },
                        "ActionsSuppressor": {
                            "type": "string"
                        },
                        "ActionsSuppressorExtensionPeriod": {
                            "type": "number"
                        },
                        "ActionsSuppressorWaitPeriod": {
                            "type": "number"
                        },
                        "AlarmActions": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "AlarmDescription": {
                            "type": "string"
                        },
                        "AlarmName": {
                            "type": "string"
                        },
                        "AlarmRule": {
                            "type": "string"
                        },
                        "InsufficientDataActions": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "OKActions": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "AlarmRule"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudWatch::CompositeAlarm"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudWatch::Dashboard": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DashboardBody": {
                            "type": "string"
                        },
                        "DashboardName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "DashboardBody"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudWatch::Dashboard"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudWatch::InsightRule": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "RuleBody": {
                            "type": "string"
                        },
                        "RuleName": {
                            "type": "string"
                        },
                        "RuleState": {
                            "type": "string"
                        },
                        "Tags": {
                            "$ref": "#/definitions/AWS::CloudWatch::InsightRule.Tags"
                        }
                    },
                    "required": [
                        "RuleBody",
                        "RuleName",
                        "RuleState"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudWatch::InsightRule"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudWatch::InsightRule.Tags": {
            "additionalProperties": false,
            "properties": {},
            "type": "object"
        },
        "AWS::CloudWatch::MetricStream": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ExcludeFilters": {
                            "items": {
                                "$ref": "#/definitions/AWS::CloudWatch::MetricStream.MetricStreamFilter"
                            },
                            "type": "array"
                        },
                        "FirehoseArn": {
                            "type": "string"
                        },
                        "IncludeFilters": {
                            "items": {
                                "$ref": "#/definitions/AWS::CloudWatch::MetricStream.MetricStreamFilter"
                            },
                            "type": "array"
                        },
                        "IncludeLinkedAccountsMetrics": {
                            "type": "boolean"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "OutputFormat": {
                            "type": "string"
                        },
                        "RoleArn": {
                            "type": "string"
                        },
                        "StatisticsConfigurations": {
                            "items": {
                                "$ref": "#/definitions/AWS::CloudWatch::MetricStream.MetricStreamStatisticsConfiguration"
                            },
                            "type": "array"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "FirehoseArn",
                        "OutputFormat",
                        "RoleArn"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudWatch::MetricStream"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudWatch::MetricStream.MetricStreamFilter": {
            "additionalProperties": false,
            "properties": {
                "MetricNames": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Namespace": {
                    "type": "string"
                }
            },
            "required": [
                "Namespace"
            ],
            "type": "object"
        },
        "AWS::CloudWatch::MetricStream.MetricStreamStatisticsConfiguration": {
            "additionalProperties": false,
            "properties": {
                "AdditionalStatistics": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "IncludeMetrics": {
                    "items": {
                        "$ref": "#/definitions/AWS::CloudWatch::MetricStream.MetricStreamStatisticsMetric"
                    },
                    "type": "array"
                }
            },
            "required": [
                "AdditionalStatistics",
                "IncludeMetrics"
            ],
            "type": "object"
        },
        "AWS::CloudWatch::MetricStream.MetricStreamStatisticsMetric": {
            "additionalProperties": false,
            "properties": {
                "MetricName": {
                    "type": "string"
                },
                "Namespace": {
                    "type": "string"
                }
            },
            "required": [
                "MetricName",
                "Namespace"
            ],
            "type": "object"
        },
        "AWS::EC2::CapacityReservation": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AvailabilityZone": {
                            "type": "string"
                        },
                        "AvailabilityZoneId": {
                            "type": "string"
                        },
                        "EbsOptimized": {
                            "type": "boolean"
                        },
                        "EndDate": {
                            "type": "string"
                        },
                        "EndDateType": {
                            "type": "string"
                        },
                        "EphemeralStorage": {
                            "type": "boolean"
                        },
                        "InstanceCount": {
                            "type": "number"
                        },
                        "InstanceMatchCriteria": {
                            "type": "string"
                        },
                        "InstancePlatform": {
                            "type": "string"
                        },
                        "InstanceType": {
                            "type": "string"
                        },
                        "OutPostArn": {
                            "type": "string"
                        },
                        "PlacementGroupArn": {
                            "type": "string"
                        },
                        "TagSpecifications": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::CapacityReservation.TagSpecification"
                            },
                            "type": "array"
                        },
                        "Tenancy": {
                            "type": "string"
                        },
                        "UnusedReservationBillingOwnerId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "InstanceCount",
                        "InstancePlatform",
                        "InstanceType"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::CapacityReservation"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::CapacityReservation.TagSpecification": {
            "additionalProperties": false,
            "properties": {
                "ResourceType": {
                    "type": "string"
                },
                "Tags": {
                    "items": {
                        "$ref": "#/definitions/Tag"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::EC2::CapacityReservationFleet": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AllocationStrategy": {
                            "type": "string"
                        },
                        "EndDate": {
                            "type": "string"
                        },
                        "InstanceMatchCriteria": {
                            "type": "string"
                        },
                        "InstanceTypeSpecifications": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::CapacityReservationFleet.InstanceTypeSpecification"
                            },
                            "type": "array"
                        },
                        "NoRemoveEndDate": {
                            "type": "boolean"
                        },
                        "RemoveEndDate": {
                            "type": "boolean"
                        },
                        "TagSpecifications": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::CapacityReservationFleet.TagSpecification"
                            },
                            "type": "array"
                        },
                        "Tenancy": {
                            "type": "string"
                        },
                        "TotalTargetCapacity": {
                            "type": "number"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::CapacityReservationFleet"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::EC2::CapacityReservationFleet.InstanceTypeSpecification": {
            "additionalProperties": false,
            "properties": {
                "AvailabilityZone": {
                    "type": "string"
                },
                "AvailabilityZoneId": {
                    "type": "string"
                },
                "EbsOptimized": {
                    "type": "boolean"
                },
                "InstancePlatform": {
                    "type": "string"
                },
                "InstanceType": {
                    "type": "string"
                },
                "Priority": {
                    "type": "number"
                },
                "Weight": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::CapacityReservationFleet.TagSpecification": {
            "additionalProperties": false,
            "properties": {
                "ResourceType": {
                    "type": "string"
                },
                "Tags": {
                    "items": {
                        "$ref": "#/definitions/Tag"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::EC2::CarrierGateway": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "VpcId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "VpcId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::CarrierGateway"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::ClientVpnAuthorizationRule": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AccessGroupId": {
                            "type": "string"
                        },
                        "AuthorizeAllGroups": {
                            "type": "boolean"
                        },
                        "ClientVpnEndpointId": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "TargetNetworkCidr": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ClientVpnEndpointId",
                        "TargetNetworkCidr"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::ClientVpnAuthorizationRule"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::ClientVpnEndpoint": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AuthenticationOptions": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::ClientVpnEndpoint.ClientAuthenticationRequest"
                            },
                            "type": "array"
                        },
                        "ClientCidrBlock": {
                            "type": "string"
                        },
                        "ClientConnectOptions": {
                            "$ref": "#/definitions/AWS::EC2::ClientVpnEndpoint.ClientConnectOptions"
                        },
                        "ClientLoginBannerOptions": {
                            "$ref": "#/definitions/AWS::EC2::ClientVpnEndpoint.ClientLoginBannerOptions"
                        },
                        "ConnectionLogOptions": {
                            "$ref": "#/definitions/AWS::EC2::ClientVpnEndpoint.ConnectionLogOptions"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "DisconnectOnSessionTimeout": {
                            "type": "boolean"
                        },
                        "DnsServers": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "SecurityGroupIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "SelfServicePortal": {
                            "type": "string"
                        },
                        "ServerCertificateArn": {
                            "type": "string"
                        },
                        "SessionTimeoutHours": {
                            "type": "number"
                        },
                        "SplitTunnel": {
                            "type": "boolean"
                        },
                        "TagSpecifications": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::ClientVpnEndpoint.TagSpecification"
                            },
                            "type": "array"
                        },
                        "TransportProtocol": {
                            "type": "string"
                        },
                        "VpcId": {
                            "type": "string"
                        },
                        "VpnPort": {
                            "type": "number"
                        }
                    },
                    "required": [
                        "AuthenticationOptions",
                        "ClientCidrBlock",
                        "ConnectionLogOptions",
                        "ServerCertificateArn"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::ClientVpnEndpoint"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::ClientVpnEndpoint.CertificateAuthenticationRequest": {
            "additionalProperties": false,
            "properties": {
                "ClientRootCertificateChainArn": {
                    "type": "string"
                }
            },
            "required": [
                "ClientRootCertificateChainArn"
            ],
            "type": "object"
        },
        "AWS::EC2::ClientVpnEndpoint.ClientAuthenticationRequest": {
            "additionalProperties": false,
            "properties": {
                "ActiveDirectory": {
                    "$ref": "#/definitions/AWS::EC2::ClientVpnEndpoint.DirectoryServiceAuthenticationRequest"
                },
                "FederatedAuthentication": {
                    "$ref": "#/definitions/AWS::EC2::ClientVpnEndpoint.FederatedAuthenticationRequest"
                },
                "MutualAuthentication": {
                    "$ref": "#/definitions/AWS::EC2::ClientVpnEndpoint.CertificateAuthenticationRequest"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::EC2::ClientVpnEndpoint.ClientConnectOptions": {
            "additionalProperties": false,
            "properties": {
                "Enabled": {
                    "type": "boolean"
                },
                "LambdaFunctionArn": {
                    "type": "string"
                }
            },
            "required": [
                "Enabled"
            ],
            "type": "object"
        },
        "AWS::EC2::ClientVpnEndpoint.ClientLoginBannerOptions": {
            "additionalProperties": false,
            "properties": {
                "BannerText": {
                    "type": "string"
                },
                "Enabled": {
                    "type": "boolean"
                }
            },
            "required": [
                "Enabled"
            ],
            "type": "object"
        },
        "AWS::EC2::ClientVpnEndpoint.ConnectionLogOptions": {
            "additionalProperties": false,
            "properties": {
                "CloudwatchLogGroup": {
                    "type": "string"
                },
                "CloudwatchLogStream": {
                    "type": "string"
                },
                "Enabled": {
                    "type": "boolean"
                }
            },
            "required": [
                "Enabled"
            ],
            "type": "object"
        },
        "AWS::EC2::ClientVpnEndpoint.DirectoryServiceAuthenticationRequest": {
            "additionalProperties": false,
            "properties": {
                "DirectoryId": {
                    "type": "string"
                }
            },
            "required": [
                "DirectoryId"
            ],
            "type": "object"
        },
        "AWS::EC2::ClientVpnEndpoint.FederatedAuthenticationRequest": {
            "additionalProperties": false,
            "properties": {
                "SAMLProviderArn": {
                    "type": "string"
                },
                "SelfServiceSAMLProviderArn": {
                    "type": "string"
                }
            },
            "required": [
                "SAMLProviderArn"
            ],
            "type": "object"
        },
        "AWS::EC2::ClientVpnEndpoint.TagSpecification": {
            "additionalProperties": false,
            "properties": {
                "ResourceType": {
                    "type": "string"
                },
                "Tags": {
                    "items": {
                        "$ref": "#/definitions/Tag"
                    },
                    "type": "array"
                }
            },
            "required": [
                "ResourceType",
                "Tags"
            ],
            "type": "object"
        },
        "AWS::EC2::ClientVpnRoute": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ClientVpnEndpointId": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "DestinationCidrBlock": {
                            "type": "string"
                        },
                        "TargetVpcSubnetId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ClientVpnEndpointId",
                        "DestinationCidrBlock",
                        "TargetVpcSubnetId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::ClientVpnRoute"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::ClientVpnTargetNetworkAssociation": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ClientVpnEndpointId": {
                            "type": "string"
                        },
                        "SubnetId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ClientVpnEndpointId",
                        "SubnetId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::ClientVpnTargetNetworkAssociation"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::CustomerGateway": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "BgpAsn": {
                            "type": "number"
                        },
                        "BgpAsnExtended": {
                            "type": "number"
                        },
                        "CertificateArn": {
                            "type": "string"
                        },
                        "DeviceName": {
                            "type": "string"
                        },
                        "IpAddress": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "Type": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "IpAddress",
                        "Type"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::CustomerGateway"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::DHCPOptions": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DomainName": {
                            "type": "string"
                        },
                        "DomainNameServers": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Ipv6AddressPreferredLeaseTime": {
                            "type": "number"
                        },
                        "NetbiosNameServers": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "NetbiosNodeType": {
                            "type": "number"
                        },
                        "NtpServers": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::DHCPOptions"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::EC2::EC2Fleet": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Context": {
                            "type": "string"
                        },
                        "ExcessCapacityTerminationPolicy": {
                            "type": "string"
                        },
                        "LaunchTemplateConfigs": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::EC2Fleet.FleetLaunchTemplateConfigRequest"
                            },
                            "type": "array"
                        },
                        "OnDemandOptions": {
                            "$ref": "#/definitions/AWS::EC2::EC2Fleet.OnDemandOptionsRequest"
                        },
                        "ReplaceUnhealthyInstances": {
                            "type": "boolean"
                        },
                        "SpotOptions": {
                            "$ref": "#/definitions/AWS::EC2::EC2Fleet.SpotOptionsRequest"
                        },
                        "TagSpecifications": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::EC2Fleet.TagSpecification"
                            },
                            "type": "array"
                        },
                        "TargetCapacitySpecification": {
                            "$ref": "#/definitions/AWS::EC2::EC2Fleet.TargetCapacitySpecificationRequest"
                        },
                        "TerminateInstancesWithExpiration": {
                            "type": "boolean"
                        },
                        "Type": {
                            "type": "string"
                        },
                        "ValidFrom": {
                            "type": "string"
                        },
                        "ValidUntil": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "LaunchTemplateConfigs",
                        "TargetCapacitySpecification"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::EC2Fleet"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::EC2Fleet.AcceleratorCountRequest": {
            "additionalProperties": false,
            "properties": {
                "Max": {
                    "type": "number"
                },
                "Min": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::EC2Fleet.AcceleratorTotalMemoryMiBRequest": {
            "additionalProperties": false,
            "properties": {
                "Max": {
                    "type": "number"
                },
                "Min": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::EC2Fleet.BaselineEbsBandwidthMbpsRequest": {
            "additionalProperties": false,
            "properties": {
                "Max": {
                    "type": "number"
                },
                "Min": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::EC2Fleet.BaselinePerformanceFactorsRequest": {
            "additionalProperties": false,
            "properties": {
                "Cpu": {
                    "$ref": "#/definitions/AWS::EC2::EC2Fleet.CpuPerformanceFactorRequest"
                }
            },
            "type": "object"
        },
        "AWS::EC2::EC2Fleet.CapacityRebalance": {
            "additionalProperties": false,
            "properties": {
                "ReplacementStrategy": {
                    "type": "string"
                },
                "TerminationDelay": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::EC2Fleet.CapacityReservationOptionsRequest": {
            "additionalProperties": false,
            "properties": {
                "UsageStrategy": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::EC2Fleet.CpuPerformanceFactorRequest": {
            "additionalProperties": false,
            "properties": {
                "References": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::EC2Fleet.PerformanceFactorReferenceRequest"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::EC2::EC2Fleet.FleetLaunchTemplateConfigRequest": {
            "additionalProperties": false,
            "properties": {
                "LaunchTemplateSpecification": {
                    "$ref": "#/definitions/AWS::EC2::EC2Fleet.FleetLaunchTemplateSpecificationRequest"
                },
                "Overrides": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::EC2Fleet.FleetLaunchTemplateOverridesRequest"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::EC2::EC2Fleet.FleetLaunchTemplateOverridesRequest": {
            "additionalProperties": false,
            "properties": {
                "AvailabilityZone": {
                    "type": "string"
                },
                "InstanceRequirements": {
                    "$ref": "#/definitions/AWS::EC2::EC2Fleet.InstanceRequirementsRequest"
                },
                "InstanceType": {
                    "type": "string"
                },
                "MaxPrice": {
                    "type": "string"
                },
                "Placement": {
                    "$ref": "#/definitions/AWS::EC2::EC2Fleet.Placement"
                },
                "Priority": {
                    "type": "number"
                },
                "SubnetId": {
                    "type": "string"
                },
                "WeightedCapacity": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::EC2Fleet.FleetLaunchTemplateSpecificationRequest": {
            "additionalProperties": false,
            "properties": {
                "LaunchTemplateId": {
                    "type": "string"
                },
                "LaunchTemplateName": {
                    "type": "string"
                },
                "Version": {
                    "type": "string"
                }
            },
            "required": [
                "Version"
            ],
            "type": "object"
        },
        "AWS::EC2::EC2Fleet.InstanceRequirementsRequest": {
            "additionalProperties": false,
            "properties": {
                "AcceleratorCount": {
                    "$ref": "#/definitions/AWS::EC2::EC2Fleet.AcceleratorCountRequest"
                },
                "AcceleratorManufacturers": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "AcceleratorNames": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "AcceleratorTotalMemoryMiB": {
                    "$ref": "#/definitions/AWS::EC2::EC2Fleet.AcceleratorTotalMemoryMiBRequest"
                },
                "AcceleratorTypes": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "AllowedInstanceTypes": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "BareMetal": {
                    "type": "string"
                },
                "BaselineEbsBandwidthMbps": {
                    "$ref": "#/definitions/AWS::EC2::EC2Fleet.BaselineEbsBandwidthMbpsRequest"
                },
                "BaselinePerformanceFactors": {
                    "$ref": "#/definitions/AWS::EC2::EC2Fleet.BaselinePerformanceFactorsRequest"
                },
                "BurstablePerformance": {
                    "type": "string"
                },
                "CpuManufacturers": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "ExcludedInstanceTypes": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "InstanceGenerations": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "LocalStorage": {
                    "type": "string"
                },
                "LocalStorageTypes": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "MaxSpotPriceAsPercentageOfOptimalOnDemandPrice": {
                    "type": "number"
                },
                "MemoryGiBPerVCpu": {
                    "$ref": "#/definitions/AWS::EC2::EC2Fleet.MemoryGiBPerVCpuRequest"
                },
                "MemoryMiB": {
                    "$ref": "#/definitions/AWS::EC2::EC2Fleet.MemoryMiBRequest"
                },
                "NetworkBandwidthGbps": {
                    "$ref": "#/definitions/AWS::EC2::EC2Fleet.NetworkBandwidthGbpsRequest"
                },
                "NetworkInterfaceCount": {
                    "$ref": "#/definitions/AWS::EC2::EC2Fleet.NetworkInterfaceCountRequest"
                },
                "OnDemandMaxPricePercentageOverLowestPrice": {
                    "type": "number"
                },
                "RequireHibernateSupport": {
                    "type": "boolean"
                },
                "SpotMaxPricePercentageOverLowestPrice": {
                    "type": "number"
                },
                "TotalLocalStorageGB": {
                    "$ref": "#/definitions/AWS::EC2::EC2Fleet.TotalLocalStorageGBRequest"
                },
                "VCpuCount": {
                    "$ref": "#/definitions/AWS::EC2::EC2Fleet.VCpuCountRangeRequest"
                }
            },
            "type": "object"
        },
        "AWS::EC2::EC2Fleet.MaintenanceStrategies": {
            "additionalProperties": false,
            "properties": {
                "CapacityRebalance": {
                    "$ref": "#/definitions/AWS::EC2::EC2Fleet.CapacityRebalance"
                }
            },
            "type": "object"
        },
        "AWS::EC2::EC2Fleet.MemoryGiBPerVCpuRequest": {
            "additionalProperties": false,
            "properties": {
                "Max": {
                    "type": "number"
                },
                "Min": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::EC2Fleet.MemoryMiBRequest": {
            "additionalProperties": false,
            "properties": {
                "Max": {
                    "type": "number"
                },
                "Min": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::EC2Fleet.NetworkBandwidthGbpsRequest": {
            "additionalProperties": false,
            "properties": {
                "Max": {
                    "type": "number"
                },
                "Min": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::EC2Fleet.NetworkInterfaceCountRequest": {
            "additionalProperties": false,
            "properties": {
                "Max": {
                    "type": "number"
                },
                "Min": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::EC2Fleet.OnDemandOptionsRequest": {
            "additionalProperties": false,
            "properties": {
                "AllocationStrategy": {
                    "type": "string"
                },
                "CapacityReservationOptions": {
                    "$ref": "#/definitions/AWS::EC2::EC2Fleet.CapacityReservationOptionsRequest"
                },
                "MaxTotalPrice": {
                    "type": "string"
                },
                "MinTargetCapacity": {
                    "type": "number"
                },
                "SingleAvailabilityZone": {
                    "type": "boolean"
                },
                "SingleInstanceType": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::EC2::EC2Fleet.PerformanceFactorReferenceRequest": {
            "additionalProperties": false,
            "properties": {
                "InstanceFamily": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::EC2Fleet.Placement": {
            "additionalProperties": false,
            "properties": {
                "Affinity": {
                    "type": "string"
                },
                "AvailabilityZone": {
                    "type": "string"
                },
                "GroupName": {
                    "type": "string"
                },
                "HostId": {
                    "type": "string"
                },
                "HostResourceGroupArn": {
                    "type": "string"
                },
                "PartitionNumber": {
                    "type": "number"
                },
                "SpreadDomain": {
                    "type": "string"
                },
                "Tenancy": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::EC2Fleet.SpotOptionsRequest": {
            "additionalProperties": false,
            "properties": {
                "AllocationStrategy": {
                    "type": "string"
                },
                "InstanceInterruptionBehavior": {
                    "type": "string"
                },
                "InstancePoolsToUseCount": {
                    "type": "number"
                },
                "MaintenanceStrategies": {
                    "$ref": "#/definitions/AWS::EC2::EC2Fleet.MaintenanceStrategies"
                },
                "MaxTotalPrice": {
                    "type": "string"
                },
                "MinTargetCapacity": {
                    "type": "number"
                },
                "SingleAvailabilityZone": {
                    "type": "boolean"
                },
                "SingleInstanceType": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::EC2::EC2Fleet.TagSpecification": {
            "additionalProperties": false,
            "properties": {
                "ResourceType": {
                    "type": "string"
                },
                "Tags": {
                    "items": {
                        "$ref": "#/definitions/Tag"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::EC2::EC2Fleet.TargetCapacitySpecificationRequest": {
            "additionalProperties": false,
            "properties": {
                "DefaultTargetCapacityType": {
                    "type": "string"
                },
                "OnDemandTargetCapacity": {
                    "type": "number"
                },
                "SpotTargetCapacity": {
                    "type": "number"
                },
                "TargetCapacityUnitType": {
                    "type": "string"
                },
                "TotalTargetCapacity": {
                    "type": "number"
                }
            },
            "required": [
                "TotalTargetCapacity"
            ],
            "type": "object"
        },
        "AWS::EC2::EC2Fleet.TotalLocalStorageGBRequest": {
            "additionalProperties": false,
            "properties": {
                "Max": {
                    "type": "number"
                },
                "Min": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::EC2Fleet.VCpuCountRangeRequest": {
            "additionalProperties": false,
            "properties": {
                "Max": {
                    "type": "number"
                },
                "Min": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::EIP": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Address": {
                            "type": "string"
                        },
                        "Domain": {
                            "type": "string"
                        },
                        "InstanceId": {
                            "type": "string"
                        },
                        "IpamPoolId": {
                            "type": "string"
                        },
                        "NetworkBorderGroup": {
                            "type": "string"
                        },
                        "PublicIpv4Pool": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "TransferAddress": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::EIP"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::EC2::EIPAssociation": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AllocationId": {
                            "type": "string"
                        },
                        "InstanceId": {
                            "type": "string"
                        },
                        "NetworkInterfaceId": {
                            "type": "string"
                        },
                        "PrivateIpAddress": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::EIPAssociation"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::EC2::EgressOnlyInternetGateway": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "VpcId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "VpcId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::EgressOnlyInternetGateway"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::EnclaveCertificateIamRoleAssociation": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CertificateArn": {
                            "type": "string"
                        },
                        "RoleArn": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "CertificateArn",
                        "RoleArn"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::EnclaveCertificateIamRoleAssociation"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::FlowLog": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DeliverCrossAccountRole": {
                            "type": "string"
                        },
                        "DeliverLogsPermissionArn": {
                            "type": "string"
                        },
                        "DestinationOptions": {
                            "$ref": "#/definitions/AWS::EC2::FlowLog.DestinationOptions"
                        },
                        "LogDestination": {
                            "type": "string"
                        },
                        "LogDestinationType": {
                            "type": "string"
                        },
                        "LogFormat": {
                            "type": "string"
                        },
                        "LogGroupName": {
                            "type": "string"
                        },
                        "MaxAggregationInterval": {
                            "type": "number"
                        },
                        "ResourceId": {
                            "type": "string"
                        },
                        "ResourceType": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "TrafficType": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ResourceId",
                        "ResourceType"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::FlowLog"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::FlowLog.DestinationOptions": {
            "additionalProperties": false,
            "properties": {
                "FileFormat": {
                    "type": "string"
                },
                "HiveCompatiblePartitions": {
                    "type": "boolean"
                },
                "PerHourPartition": {
                    "type": "boolean"
                }
            },
            "required": [
                "FileFormat",
                "HiveCompatiblePartitions",
                "PerHourPartition"
            ],
            "type": "object"
        },
        "AWS::EC2::GatewayRouteTableAssociation": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "GatewayId": {
                            "type": "string"
                        },
                        "RouteTableId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "GatewayId",
                        "RouteTableId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::GatewayRouteTableAssociation"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::Host": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AssetId": {
                            "type": "string"
                        },
                        "AutoPlacement": {
                            "type": "string"
                        },
                        "AvailabilityZone": {
                            "type": "string"
                        },
                        "HostMaintenance": {
                            "type": "string"
                        },
                        "HostRecovery": {
                            "type": "string"
                        },
                        "InstanceFamily": {
                            "type": "string"
                        },
                        "InstanceType": {
                            "type": "string"
                        },
                        "OutpostArn": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "AvailabilityZone"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::Host"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::IPAM": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DefaultResourceDiscoveryOrganizationalUnitExclusions": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::IPAM.IpamOrganizationalUnitExclusion"
                            },
                            "type": "array"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "EnablePrivateGua": {
                            "type": "boolean"
                        },
                        "OperatingRegions": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::IPAM.IpamOperatingRegion"
                            },
                            "type": "array"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "Tier": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::IPAM"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::EC2::IPAM.IpamOperatingRegion": {
            "additionalProperties": false,
            "properties": {
                "RegionName": {
                    "type": "string"
                }
            },
            "required": [
                "RegionName"
            ],
            "type": "object"
        },
        "AWS::EC2::IPAM.IpamOrganizationalUnitExclusion": {
            "additionalProperties": false,
            "properties": {
                "OrganizationsEntityPath": {
                    "type": "string"
                }
            },
            "required": [
                "OrganizationsEntityPath"
            ],
            "type": "object"
        },
        "AWS::EC2::IPAMAllocation": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Cidr": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "IpamPoolId": {
                            "type": "string"
                        },
                        "NetmaskLength": {
                            "type": "number"
                        }
                    },
                    "required": [
                        "IpamPoolId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::IPAMAllocation"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::IPAMPool": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AddressFamily": {
                            "type": "string"
                        },
                        "AllocationDefaultNetmaskLength": {
                            "type": "number"
                        },
                        "AllocationMaxNetmaskLength": {
                            "type": "number"
                        },
                        "AllocationMinNetmaskLength": {
                            "type": "number"
                        },
                        "AllocationResourceTags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "AutoImport": {
                            "type": "boolean"
                        },
                        "AwsService": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "IpamScopeId": {
                            "type": "string"
                        },
                        "Locale": {
                            "type": "string"
                        },
                        "ProvisionedCidrs": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::IPAMPool.ProvisionedCidr"
                            },
                            "type": "array"
                        },
                        "PublicIpSource": {
                            "type": "string"
                        },
                        "PubliclyAdvertisable": {
                            "type": "boolean"
                        },
                        "SourceIpamPoolId": {
                            "type": "string"
                        },
                        "SourceResource": {
                            "$ref": "#/definitions/AWS::EC2::IPAMPool.SourceResource"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "AddressFamily",
                        "IpamScopeId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::IPAMPool"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::IPAMPool.ProvisionedCidr": {
            "additionalProperties": false,
            "properties": {
                "Cidr": {
                    "type": "string"
                }
            },
            "required": [
                "Cidr"
            ],
            "type": "object"
        },
        "AWS::EC2::IPAMPool.SourceResource": {
            "additionalProperties": false,
            "properties": {
                "ResourceId": {
                    "type": "string"
                },
                "ResourceOwner": {
                    "type": "string"
                },
                "ResourceRegion": {
                    "type": "string"
                },
                "ResourceType": {
                    "type": "string"
                }
            },
            "required": [
                "ResourceId",
                "ResourceOwner",
                "ResourceRegion",
                "ResourceType"
            ],
            "type": "object"
        },
        "AWS::EC2::IPAMPoolCidr": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Cidr": {
                            "type": "string"
                        },
                        "IpamPoolId": {
                            "type": "string"
                        },
                        "NetmaskLength": {
                            "type": "number"
                        }
                    },
                    "required": [
                        "IpamPoolId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::IPAMPoolCidr"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::IPAMResourceDiscovery": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "OperatingRegions": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::IPAMResourceDiscovery.IpamOperatingRegion"
                            },
                            "type": "array"
                        },
                        "OrganizationalUnitExclusions": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::IPAMResourceDiscovery.IpamResourceDiscoveryOrganizationalUnitExclusion"
                            },
                            "type": "array"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::IPAMResourceDiscovery"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::EC2::IPAMResourceDiscovery.IpamOperatingRegion": {
            "additionalProperties": false,
            "properties": {
                "RegionName": {
                    "type": "string"
                }
            },
            "required": [
                "RegionName"
            ],
            "type": "object"
        },
        "AWS::EC2::IPAMResourceDiscovery.IpamResourceDiscoveryOrganizationalUnitExclusion": {
            "additionalProperties": false,
            "properties": {
                "OrganizationsEntityPath": {
                    "type": "string"
                }
            },
            "required": [
                "OrganizationsEntityPath"
            ],
            "type": "object"
        },
        "AWS::EC2::IPAMResourceDiscoveryAssociation": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "IpamId": {
                            "type": "string"
                        },
                        "IpamResourceDiscoveryId": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "IpamId",
                        "IpamResourceDiscoveryId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::IPAMResourceDiscoveryAssociation"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::IPAMScope": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "IpamId": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "IpamId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::IPAMScope"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::Instance": {
            "additionalProperties": false,
            "properties": {
                "CreationPolicy": {
                    "type": "object"
                },
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AdditionalInfo": {
                            "type": "string"
                        },
                        "Affinity": {
                            "type": "string"
                        },
                        "AvailabilityZone": {
                            "type": "string"
                        },
                        "BlockDeviceMappings": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::Instance.BlockDeviceMapping"
                            },
                            "type": "array"
                        },
                        "CpuOptions": {
                            "$ref": "#/definitions/AWS::EC2::Instance.CpuOptions"
                        },
                        "CreditSpecification": {
                            "$ref": "#/definitions/AWS::EC2::Instance.CreditSpecification"
                        },
                        "DisableApiTermination": {
                            "type": "boolean"
                        },
                        "EbsOptimized": {
                            "type": "boolean"
                        },
                        "ElasticGpuSpecifications": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::Instance.ElasticGpuSpecification"
                            },
                            "type": "array"
                        },
                        "ElasticInferenceAccelerators": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::Instance.ElasticInferenceAccelerator"
                            },
                            "type": "array"
                        },
                        "EnclaveOptions": {
                            "$ref": "#/definitions/AWS::EC2::Instance.EnclaveOptions"
                        },
                        "HibernationOptions": {
                            "$ref": "#/definitions/AWS::EC2::Instance.HibernationOptions"
                        },
                        "HostId": {
                            "type": "string"
                        },
                        "HostResourceGroupArn": {
                            "type": "string"
                        },
                        "IamInstanceProfile": {
                            "type": "string"
                        },
                        "ImageId": {
                            "type": "string"
                        },
                        "InstanceInitiatedShutdownBehavior": {
                            "type": "string"
                        },
                        "InstanceType": {
                            "type": "string"
                        },
                        "Ipv6AddressCount": {
                            "type": "number"
                        },
                        "Ipv6Addresses": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::Instance.InstanceIpv6Address"
                            },
                            "type": "array"
                        },
                        "KernelId": {
                            "type": "string"
                        },
                        "KeyName": {
                            "type": "string"
                        },
                        "LaunchTemplate": {
                            "$ref": "#/definitions/AWS::EC2::Instance.LaunchTemplateSpecification"
                        },
                        "LicenseSpecifications": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::Instance.LicenseSpecification"
                            },
                            "type": "array"
                        },
                        "Monitoring": {
                            "type": "boolean"
                        },
                        "NetworkInterfaces": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::Instance.NetworkInterface"
                            },
                            "type": "array"
                        },
                        "PlacementGroupName": {
                            "type": "string"
                        },
                        "PrivateDnsNameOptions": {
                            "$ref": "#/definitions/AWS::EC2::Instance.PrivateDnsNameOptions"
                        },
                        "PrivateIpAddress": {
                            "type": "string"
                        },
                        "PropagateTagsToVolumeOnCreation": {
                            "type": "boolean"
                        },
                        "RamdiskId": {
                            "type": "string"
                        },
                        "SecurityGroupIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "SecurityGroups": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "SourceDestCheck": {
                            "type": "boolean"
                        },
                        "SsmAssociations": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::Instance.SsmAssociation"
                            },
                            "type": "array"
                        },
                        "SubnetId": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "Tenancy": {
                            "type": "string"
                        },
                        "UserData": {
                            "type": "string"
                        },
                        "Volumes": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::Instance.Volume"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::Instance"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::EC2::Instance.AssociationParameter": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Value": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Key",
                "Value"
            ],
            "type": "object"
        },
        "AWS::EC2::Instance.BlockDeviceMapping": {
            "additionalProperties": false,
            "properties": {
                "DeviceName": {
                    "type": "string"
                },
                "Ebs": {
                    "$ref": "#/definitions/AWS::EC2::Instance.Ebs"
                },
                "NoDevice": {
                    "type": "object"
                },
                "VirtualName": {
                    "type": "string"
                }
            },
            "required": [
                "DeviceName"
            ],
            "type": "object"
        },
        "AWS::EC2::Instance.CpuOptions": {
            "additionalProperties": false,
            "properties": {
                "CoreCount": {
                    "type": "number"
                },
                "ThreadsPerCore": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::Instance.CreditSpecification": {
            "additionalProperties": false,
            "properties": {
                "CPUCredits": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::Instance.Ebs": {
            "additionalProperties": false,
            "properties": {
                "DeleteOnTermination": {
                    "type": "boolean"
                },
                "Encrypted": {
                    "type": "boolean"
                },
                "Iops": {
                    "type": "number"
                },
                "KmsKeyId": {
                    "type": "string"
                },
                "SnapshotId": {
                    "type": "string"
                },
                "VolumeSize": {
                    "type": "number"
                },
                "VolumeType": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::Instance.ElasticGpuSpecification": {
            "additionalProperties": false,
            "properties": {
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::EC2::Instance.ElasticInferenceAccelerator": {
            "additionalProperties": false,
            "properties": {
                "Count": {
                    "type": "number"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::EC2::Instance.EnclaveOptions": {
            "additionalProperties": false,
            "properties": {
                "Enabled": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::EC2::Instance.HibernationOptions": {
            "additionalProperties": false,
            "properties": {
                "Configured": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::EC2::Instance.InstanceIpv6Address": {
            "additionalProperties": false,
            "properties": {
                "Ipv6Address": {
                    "type": "string"
                }
            },
            "required": [
                "Ipv6Address"
            ],
            "type": "object"
        },
        "AWS::EC2::Instance.LaunchTemplateSpecification": {
            "additionalProperties": false,
            "properties": {
                "LaunchTemplateId": {
                    "type": "string"
                },
                "LaunchTemplateName": {
                    "type": "string"
                },
                "Version": {
                    "type": "string"
                }
            },
            "required": [
                "Version"
            ],
            "type": "object"
        },
        "AWS::EC2::Instance.LicenseSpecification": {
            "additionalProperties": false,
            "properties": {
                "LicenseConfigurationArn": {
                    "type": "string"
                }
            },
            "required": [
                "LicenseConfigurationArn"
            ],
            "type": "object"
        },
        "AWS::EC2::Instance.NetworkInterface": {
            "additionalProperties": false,
            "properties": {
                "AssociateCarrierIpAddress": {
                    "type": "boolean"
                },
                "AssociatePublicIpAddress": {
                    "type": "boolean"
                },
                "DeleteOnTermination": {
                    "type": "boolean"
                },
                "Description": {
                    "type": "string"
                },
                "DeviceIndex": {
                    "type": "string"
                },
                "GroupSet": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Ipv6AddressCount": {
                    "type": "number"
                },
                "Ipv6Addresses": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::Instance.InstanceIpv6Address"
                    },
                    "type": "array"
                },
                "NetworkInterfaceId": {
                    "type": "string"
                },
                "PrivateIpAddress": {
                    "type": "string"
                },
                "PrivateIpAddresses": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::Instance.PrivateIpAddressSpecification"
                    },
                    "type": "array"
                },
                "SecondaryPrivateIpAddressCount": {
                    "type": "number"
                },
                "SubnetId": {
                    "type": "string"
                }
            },
            "required": [
                "DeviceIndex"
            ],
            "type": "object"
        },
        "AWS::EC2::Instance.PrivateDnsNameOptions": {
            "additionalProperties": false,
            "properties": {
                "EnableResourceNameDnsAAAARecord": {
                    "type": "boolean"
                },
                "EnableResourceNameDnsARecord": {
                    "type": "boolean"
                },
                "HostnameType": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::Instance.PrivateIpAddressSpecification": {
            "additionalProperties": false,
            "properties": {
                "Primary": {
                    "type": "boolean"
                },
                "PrivateIpAddress": {
                    "type": "string"
                }
            },
            "required": [
                "Primary",
                "PrivateIpAddress"
            ],
            "type": "object"
        },
        "AWS::EC2::Instance.SsmAssociation": {
            "additionalProperties": false,
            "properties": {
                "AssociationParameters": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::Instance.AssociationParameter"
                    },
                    "type": "array"
                },
                "DocumentName": {
                    "type": "string"
                }
            },
            "required": [
                "DocumentName"
            ],
            "type": "object"
        },
        "AWS::EC2::Instance.State": {
            "additionalProperties": false,
            "properties": {
                "Code": {
                    "type": "string"
                },
                "Name": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::Instance.Volume": {
            "additionalProperties": false,
            "properties": {
                "Device": {
                    "type": "string"
                },
                "VolumeId": {
                    "type": "string"
                }
            },
            "required": [
                "Device",
                "VolumeId"
            ],
            "type": "object"
        },
        "AWS::EC2::InstanceConnectEndpoint": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ClientToken": {
                            "type": "string"
                        },
                        "PreserveClientIp": {
                            "type": "boolean"
                        },
                        "SecurityGroupIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "SubnetId": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "SubnetId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::InstanceConnectEndpoint"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::InternetGateway": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::InternetGateway"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::EC2::KeyPair": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "KeyFormat": {
                            "type": "string"
                        },
                        "KeyName": {
                            "type": "string"
                        },
                        "KeyType": {
                            "type": "string"
                        },
                        "PublicKeyMaterial": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "KeyName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::KeyPair"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "LaunchTemplateData": {
                            "$ref": "#/definitions/AWS::EC2::LaunchTemplate.LaunchTemplateData"
                        },
                        "LaunchTemplateName": {
                            "type": "string"
                        },
                        "TagSpecifications": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::LaunchTemplate.LaunchTemplateTagSpecification"
                            },
                            "type": "array"
                        },
                        "VersionDescription": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "LaunchTemplateData"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::LaunchTemplate"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.AcceleratorCount": {
            "additionalProperties": false,
            "properties": {
                "Max": {
                    "type": "number"
                },
                "Min": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.AcceleratorTotalMemoryMiB": {
            "additionalProperties": false,
            "properties": {
                "Max": {
                    "type": "number"
                },
                "Min": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.BaselineEbsBandwidthMbps": {
            "additionalProperties": false,
            "properties": {
                "Max": {
                    "type": "number"
                },
                "Min": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.BaselinePerformanceFactors": {
            "additionalProperties": false,
            "properties": {
                "Cpu": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.Cpu"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.BlockDeviceMapping": {
            "additionalProperties": false,
            "properties": {
                "DeviceName": {
                    "type": "string"
                },
                "Ebs": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.Ebs"
                },
                "NoDevice": {
                    "type": "string"
                },
                "VirtualName": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.CapacityReservationSpecification": {
            "additionalProperties": false,
            "properties": {
                "CapacityReservationPreference": {
                    "type": "string"
                },
                "CapacityReservationTarget": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.CapacityReservationTarget"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.CapacityReservationTarget": {
            "additionalProperties": false,
            "properties": {
                "CapacityReservationId": {
                    "type": "string"
                },
                "CapacityReservationResourceGroupArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.ConnectionTrackingSpecification": {
            "additionalProperties": false,
            "properties": {
                "TcpEstablishedTimeout": {
                    "type": "number"
                },
                "UdpStreamTimeout": {
                    "type": "number"
                },
                "UdpTimeout": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.Cpu": {
            "additionalProperties": false,
            "properties": {
                "References": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::LaunchTemplate.Reference"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.CpuOptions": {
            "additionalProperties": false,
            "properties": {
                "AmdSevSnp": {
                    "type": "string"
                },
                "CoreCount": {
                    "type": "number"
                },
                "ThreadsPerCore": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.CreditSpecification": {
            "additionalProperties": false,
            "properties": {
                "CpuCredits": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.Ebs": {
            "additionalProperties": false,
            "properties": {
                "DeleteOnTermination": {
                    "type": "boolean"
                },
                "Encrypted": {
                    "type": "boolean"
                },
                "Iops": {
                    "type": "number"
                },
                "KmsKeyId": {
                    "type": "string"
                },
                "SnapshotId": {
                    "type": "string"
                },
                "Throughput": {
                    "type": "number"
                },
                "VolumeSize": {
                    "type": "number"
                },
                "VolumeType": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.ElasticGpuSpecification": {
            "additionalProperties": false,
            "properties": {
                "Type": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.EnaSrdSpecification": {
            "additionalProperties": false,
            "properties": {
                "EnaSrdEnabled": {
                    "type": "boolean"
                },
                "EnaSrdUdpSpecification": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.EnaSrdUdpSpecification"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.EnaSrdUdpSpecification": {
            "additionalProperties": false,
            "properties": {
                "EnaSrdUdpEnabled": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.EnclaveOptions": {
            "additionalProperties": false,
            "properties": {
                "Enabled": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.HibernationOptions": {
            "additionalProperties": false,
            "properties": {
                "Configured": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.IamInstanceProfile": {
            "additionalProperties": false,
            "properties": {
                "Arn": {
                    "type": "string"
                },
                "Name": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.InstanceMarketOptions": {
            "additionalProperties": false,
            "properties": {
                "MarketType": {
                    "type": "string"
                },
                "SpotOptions": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.SpotOptions"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.InstanceRequirements": {
            "additionalProperties": false,
            "properties": {
                "AcceleratorCount": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.AcceleratorCount"
                },
                "AcceleratorManufacturers": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "AcceleratorNames": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "AcceleratorTotalMemoryMiB": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.AcceleratorTotalMemoryMiB"
                },
                "AcceleratorTypes": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "AllowedInstanceTypes": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "BareMetal": {
                    "type": "string"
                },
                "BaselineEbsBandwidthMbps": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.BaselineEbsBandwidthMbps"
                },
                "BaselinePerformanceFactors": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.BaselinePerformanceFactors"
                },
                "BurstablePerformance": {
                    "type": "string"
                },
                "CpuManufacturers": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "ExcludedInstanceTypes": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "InstanceGenerations": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "LocalStorage": {
                    "type": "string"
                },
                "LocalStorageTypes": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "MaxSpotPriceAsPercentageOfOptimalOnDemandPrice": {
                    "type": "number"
                },
                "MemoryGiBPerVCpu": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.MemoryGiBPerVCpu"
                },
                "MemoryMiB": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.MemoryMiB"
                },
                "NetworkBandwidthGbps": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.NetworkBandwidthGbps"
                },
                "NetworkInterfaceCount": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.NetworkInterfaceCount"
                },
                "OnDemandMaxPricePercentageOverLowestPrice": {
                    "type": "number"
                },
                "RequireHibernateSupport": {
                    "type": "boolean"
                },
                "SpotMaxPricePercentageOverLowestPrice": {
                    "type": "number"
                },
                "TotalLocalStorageGB": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.TotalLocalStorageGB"
                },
                "VCpuCount": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.VCpuCount"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.Ipv4PrefixSpecification": {
            "additionalProperties": false,
            "properties": {
                "Ipv4Prefix": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.Ipv6Add": {
            "additionalProperties": false,
            "properties": {
                "Ipv6Address": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.Ipv6PrefixSpecification": {
            "additionalProperties": false,
            "properties": {
                "Ipv6Prefix": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.LaunchTemplateData": {
            "additionalProperties": false,
            "properties": {
                "BlockDeviceMappings": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::LaunchTemplate.BlockDeviceMapping"
                    },
                    "type": "array"
                },
                "CapacityReservationSpecification": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.CapacityReservationSpecification"
                },
                "CpuOptions": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.CpuOptions"
                },
                "CreditSpecification": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.CreditSpecification"
                },
                "DisableApiStop": {
                    "type": "boolean"
                },
                "DisableApiTermination": {
                    "type": "boolean"
                },
                "EbsOptimized": {
                    "type": "boolean"
                },
                "ElasticGpuSpecifications": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::LaunchTemplate.ElasticGpuSpecification"
                    },
                    "type": "array"
                },
                "ElasticInferenceAccelerators": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::LaunchTemplate.LaunchTemplateElasticInferenceAccelerator"
                    },
                    "type": "array"
                },
                "EnclaveOptions": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.EnclaveOptions"
                },
                "HibernationOptions": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.HibernationOptions"
                },
                "IamInstanceProfile": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.IamInstanceProfile"
                },
                "ImageId": {
                    "type": "string"
                },
                "InstanceInitiatedShutdownBehavior": {
                    "type": "string"
                },
                "InstanceMarketOptions": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.InstanceMarketOptions"
                },
                "InstanceRequirements": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.InstanceRequirements"
                },
                "InstanceType": {
                    "type": "string"
                },
                "KernelId": {
                    "type": "string"
                },
                "KeyName": {
                    "type": "string"
                },
                "LicenseSpecifications": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::LaunchTemplate.LicenseSpecification"
                    },
                    "type": "array"
                },
                "MaintenanceOptions": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.MaintenanceOptions"
                },
                "MetadataOptions": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.MetadataOptions"
                },
                "Monitoring": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.Monitoring"
                },
                "NetworkInterfaces": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::LaunchTemplate.NetworkInterface"
                    },
                    "type": "array"
                },
                "NetworkPerformanceOptions": {
                    "type": "object"
                },
                "Placement": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.Placement"
                },
                "PrivateDnsNameOptions": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.PrivateDnsNameOptions"
                },
                "RamDiskId": {
                    "type": "string"
                },
                "SecurityGroupIds": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "SecurityGroups": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "TagSpecifications": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::LaunchTemplate.TagSpecification"
                    },
                    "type": "array"
                },
                "UserData": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.LaunchTemplateElasticInferenceAccelerator": {
            "additionalProperties": false,
            "properties": {
                "Count": {
                    "type": "number"
                },
                "Type": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.LaunchTemplateTagSpecification": {
            "additionalProperties": false,
            "properties": {
                "ResourceType": {
                    "type": "string"
                },
                "Tags": {
                    "items": {
                        "$ref": "#/definitions/Tag"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.LicenseSpecification": {
            "additionalProperties": false,
            "properties": {
                "LicenseConfigurationArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.MaintenanceOptions": {
            "additionalProperties": false,
            "properties": {
                "AutoRecovery": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.MemoryGiBPerVCpu": {
            "additionalProperties": false,
            "properties": {
                "Max": {
                    "type": "number"
                },
                "Min": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.MemoryMiB": {
            "additionalProperties": false,
            "properties": {
                "Max": {
                    "type": "number"
                },
                "Min": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.MetadataOptions": {
            "additionalProperties": false,
            "properties": {
                "HttpEndpoint": {
                    "type": "string"
                },
                "HttpProtocolIpv6": {
                    "type": "string"
                },
                "HttpPutResponseHopLimit": {
                    "type": "number"
                },
                "HttpTokens": {
                    "type": "string"
                },
                "InstanceMetadataTags": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.Monitoring": {
            "additionalProperties": false,
            "properties": {
                "Enabled": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.NetworkBandwidthGbps": {
            "additionalProperties": false,
            "properties": {
                "Max": {
                    "type": "number"
                },
                "Min": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.NetworkInterface": {
            "additionalProperties": false,
            "properties": {
                "AssociateCarrierIpAddress": {
                    "type": "boolean"
                },
                "AssociatePublicIpAddress": {
                    "type": "boolean"
                },
                "ConnectionTrackingSpecification": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.ConnectionTrackingSpecification"
                },
                "DeleteOnTermination": {
                    "type": "boolean"
                },
                "Description": {
                    "type": "string"
                },
                "DeviceIndex": {
                    "type": "number"
                },
                "EnaSrdSpecification": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.EnaSrdSpecification"
                },
                "Groups": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "InterfaceType": {
                    "type": "string"
                },
                "Ipv4PrefixCount": {
                    "type": "number"
                },
                "Ipv4Prefixes": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::LaunchTemplate.Ipv4PrefixSpecification"
                    },
                    "type": "array"
                },
                "Ipv6AddressCount": {
                    "type": "number"
                },
                "Ipv6Addresses": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::LaunchTemplate.Ipv6Add"
                    },
                    "type": "array"
                },
                "Ipv6PrefixCount": {
                    "type": "number"
                },
                "Ipv6Prefixes": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::LaunchTemplate.Ipv6PrefixSpecification"
                    },
                    "type": "array"
                },
                "NetworkCardIndex": {
                    "type": "number"
                },
                "NetworkInterfaceId": {
                    "type": "string"
                },
                "PrimaryIpv6": {
                    "type": "boolean"
                },
                "PrivateIpAddress": {
                    "type": "string"
                },
                "PrivateIpAddresses": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::LaunchTemplate.PrivateIpAdd"
                    },
                    "type": "array"
                },
                "SecondaryPrivateIpAddressCount": {
                    "type": "number"
                },
                "SubnetId": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.NetworkInterfaceCount": {
            "additionalProperties": false,
            "properties": {
                "Max": {
                    "type": "number"
                },
                "Min": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.Placement": {
            "additionalProperties": false,
            "properties": {
                "Affinity": {
                    "type": "string"
                },
                "AvailabilityZone": {
                    "type": "string"
                },
                "GroupId": {
                    "type": "string"
                },
                "GroupName": {
                    "type": "string"
                },
                "HostId": {
                    "type": "string"
                },
                "HostResourceGroupArn": {
                    "type": "string"
                },
                "PartitionNumber": {
                    "type": "number"
                },
                "SpreadDomain": {
                    "type": "string"
                },
                "Tenancy": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.PrivateDnsNameOptions": {
            "additionalProperties": false,
            "properties": {
                "EnableResourceNameDnsAAAARecord": {
                    "type": "boolean"
                },
                "EnableResourceNameDnsARecord": {
                    "type": "boolean"
                },
                "HostnameType": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.PrivateIpAdd": {
            "additionalProperties": false,
            "properties": {
                "Primary": {
                    "type": "boolean"
                },
                "PrivateIpAddress": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.Reference": {
            "additionalProperties": false,
            "properties": {
                "InstanceFamily": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.SpotOptions": {
            "additionalProperties": false,
            "properties": {
                "BlockDurationMinutes": {
                    "type": "number"
                },
                "InstanceInterruptionBehavior": {
                    "type": "string"
                },
                "MaxPrice": {
                    "type": "string"
                },
                "SpotInstanceType": {
                    "type": "string"
                },
                "ValidUntil": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.TagSpecification": {
            "additionalProperties": false,
            "properties": {
                "ResourceType": {
                    "type": "string"
                },
                "Tags": {
                    "items": {
                        "$ref": "#/definitions/Tag"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.TotalLocalStorageGB": {
            "additionalProperties": false,
            "properties": {
                "Max": {
                    "type": "number"
                },
                "Min": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.VCpuCount": {
            "additionalProperties": false,
            "properties": {
                "Max": {
                    "type": "number"
                },
                "Min": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LocalGatewayRoute": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DestinationCidrBlock": {
                            "type": "string"
                        },
                        "LocalGatewayRouteTableId": {
                            "type": "string"
                        },
                        "LocalGatewayVirtualInterfaceGroupId": {
                            "type": "string"
                        },
                        "NetworkInterfaceId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "DestinationCidrBlock",
                        "LocalGatewayRouteTableId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::LocalGatewayRoute"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::LocalGatewayRouteTable": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "LocalGatewayId": {
                            "type": "string"
                        },
                        "Mode": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "LocalGatewayId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::LocalGatewayRouteTable"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::LocalGatewayRouteTableVPCAssociation": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "LocalGatewayRouteTableId": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "VpcId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "LocalGatewayRouteTableId",
                        "VpcId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::LocalGatewayRouteTableVPCAssociation"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::LocalGatewayRouteTableVirtualInterfaceGroupAssociation": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "LocalGatewayRouteTableId": {
                            "type": "string"
                        },
                        "LocalGatewayVirtualInterfaceGroupId": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "LocalGatewayRouteTableId",
                        "LocalGatewayVirtualInterfaceGroupId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::LocalGatewayRouteTableVirtualInterfaceGroupAssociation"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::NatGateway": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AllocationId": {
                            "type": "string"
                        },
                        "ConnectivityType": {
                            "type": "string"
                        },
                        "MaxDrainDurationSeconds": {
                            "type": "number"
                        },
                        "PrivateIpAddress": {
                            "type": "string"
                        },
                        "SecondaryAllocationIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "SecondaryPrivateIpAddressCount": {
                            "type": "number"
                        },
                        "SecondaryPrivateIpAddresses": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "SubnetId": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "SubnetId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::NatGateway"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::NetworkAcl": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "VpcId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "VpcId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::NetworkAcl"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::NetworkAclEntry": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CidrBlock": {
                            "type": "string"
                        },
                        "Egress": {
                            "type": "boolean"
                        },
                        "Icmp": {
                            "$ref": "#/definitions/AWS::EC2::NetworkAclEntry.Icmp"
                        },
                        "Ipv6CidrBlock": {
                            "type": "string"
                        },
                        "NetworkAclId": {
                            "type": "string"
                        },
                        "PortRange": {
                            "$ref": "#/definitions/AWS::EC2::NetworkAclEntry.PortRange"
                        },
                        "Protocol": {
                            "type": "number"
                        },
                        "RuleAction": {
                            "type": "string"
                        },
                        "RuleNumber": {
                            "type": "number"
                        }
                    },
                    "required": [
                        "NetworkAclId",
                        "Protocol",
                        "RuleAction",
                        "RuleNumber"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::NetworkAclEntry"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::NetworkAclEntry.Icmp": {
            "additionalProperties": false,
            "properties": {
                "Code": {
                    "type": "number"
                },
                "Type": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::NetworkAclEntry.PortRange": {
            "additionalProperties": false,
            "properties": {
                "From": {
                    "type": "number"
                },
                "To": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::NetworkInsightsAccessScope": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ExcludePaths": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::NetworkInsightsAccessScope.AccessScopePathRequest"
                            },
                            "type": "array"
                        },
                        "MatchPaths": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::NetworkInsightsAccessScope.AccessScopePathRequest"
                            },
                            "type": "array"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::NetworkInsightsAccessScope"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::EC2::NetworkInsightsAccessScope.AccessScopePathRequest": {
            "additionalProperties": false,
            "properties": {
                "Destination": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAccessScope.PathStatementRequest"
                },
                "Source": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAccessScope.PathStatementRequest"
                },
                "ThroughResources": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::NetworkInsightsAccessScope.ThroughResourcesStatementRequest"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::EC2::NetworkInsightsAccessScope.PacketHeaderStatementRequest": {
            "additionalProperties": false,
            "properties": {
                "DestinationAddresses": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "DestinationPorts": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "DestinationPrefixLists": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Protocols": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "SourceAddresses": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "SourcePorts": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "SourcePrefixLists": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::EC2::NetworkInsightsAccessScope.PathStatementRequest": {
            "additionalProperties": false,
            "properties": {
                "PacketHeaderStatement": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAccessScope.PacketHeaderStatementRequest"
                },
                "ResourceStatement": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAccessScope.ResourceStatementRequest"
                }
            },
            "type": "object"
        },
        "AWS::EC2::NetworkInsightsAccessScope.ResourceStatementRequest": {
            "additionalProperties": false,
            "properties": {
                "ResourceTypes": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Resources": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::EC2::NetworkInsightsAccessScope.ThroughResourcesStatementRequest": {
            "additionalProperties": false,
            "properties": {
                "ResourceStatement": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAccessScope.ResourceStatementRequest"
                }
            },
            "type": "object"
        },
        "AWS::EC2::NetworkInsightsAccessScopeAnalysis": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "NetworkInsightsAccessScopeId": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "NetworkInsightsAccessScopeId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::NetworkInsightsAccessScopeAnalysis"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::NetworkInsightsAnalysis": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AdditionalAccounts": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "FilterInArns": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "NetworkInsightsPathId": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "NetworkInsightsPathId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::NetworkInsightsAnalysis"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::NetworkInsightsAnalysis.AdditionalDetail": {
            "additionalProperties": false,
            "properties": {
                "AdditionalDetailType": {
                    "type": "string"
                },
                "Component": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisComponent"
                },
                "LoadBalancers": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisComponent"
                    },
                    "type": "array"
                },
                "ServiceName": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::NetworkInsightsAnalysis.AlternatePathHint": {
            "additionalProperties": false,
            "properties": {
                "ComponentArn": {
                    "type": "string"
                },
                "ComponentId": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::NetworkInsightsAnalysis.AnalysisAclRule": {
            "additionalProperties": false,
            "properties": {
                "Cidr": {
                    "type": "string"
                },
                "Egress": {
                    "type": "boolean"
                },
                "PortRange": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.PortRange"
                },
                "Protocol": {
                    "type": "string"
                },
                "RuleAction": {
                    "type": "string"
                },
                "RuleNumber": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::NetworkInsightsAnalysis.AnalysisComponent": {
            "additionalProperties": false,
            "properties": {
                "Arn": {
                    "type": "string"
                },
                "Id": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::NetworkInsightsAnalysis.AnalysisLoadBalancerListener": {
            "additionalProperties": false,
            "properties": {
                "InstancePort": {
                    "type": "number"
                },
                "LoadBalancerPort": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::NetworkInsightsAnalysis.AnalysisLoadBalancerTarget": {
            "additionalProperties": false,
            "properties": {
                "Address": {
                    "type": "string"
                },
                "AvailabilityZone": {
                    "type": "string"
                },
                "Instance": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisComponent"
                },
                "Port": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::NetworkInsightsAnalysis.AnalysisPacketHeader": {
            "additionalProperties": false,
            "properties": {
                "DestinationAddresses": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "DestinationPortRanges": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.PortRange"
                    },
                    "type": "array"
                },
                "Protocol": {
                    "type": "string"
                },
                "SourceAddresses": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "SourcePortRanges": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.PortRange"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::EC2::NetworkInsightsAnalysis.AnalysisRouteTableRoute": {
            "additionalProperties": false,
            "properties": {
                "NatGatewayId": {
                    "type": "string"
                },
                "NetworkInterfaceId": {
                    "type": "string"
                },
                "Origin": {
                    "type": "string"
                },
                "State": {
                    "type": "string"
                },
                "TransitGatewayId": {
                    "type": "string"
                },
                "VpcPeeringConnectionId": {
                    "type": "string"
                },
                "destinationCidr": {
                    "type": "string"
                },
                "destinationPrefixListId": {
                    "type": "string"
                },
                "egressOnlyInternetGatewayId": {
                    "type": "string"
                },
                "gatewayId": {
                    "type": "string"
                },
                "instanceId": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::NetworkInsightsAnalysis.AnalysisSecurityGroupRule": {
            "additionalProperties": false,
            "properties": {
                "Cidr": {
                    "type": "string"
                },
                "Direction": {
                    "type": "string"
                },
                "PortRange": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.PortRange"
                },
                "PrefixListId": {
                    "type": "string"
                },
                "Protocol": {
                    "type": "string"
                },
                "SecurityGroupId": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::NetworkInsightsAnalysis.Explanation": {
            "additionalProperties": false,
            "properties": {
                "Acl": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisComponent"
                },
                "AclRule": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisAclRule"
                },
                "Address": {
                    "type": "string"
                },
                "Addresses": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "AttachedTo": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisComponent"
                },
                "AvailabilityZones": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Cidrs": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "ClassicLoadBalancerListener": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisLoadBalancerListener"
                },
                "Component": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisComponent"
                },
                "ComponentAccount": {
                    "type": "string"
                },
                "ComponentRegion": {
                    "type": "string"
                },
                "CustomerGateway": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisComponent"
                },
                "Destination": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisComponent"
                },
                "DestinationVpc": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisComponent"
                },
                "Direction": {
                    "type": "string"
                },
                "ElasticLoadBalancerListener": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisComponent"
                },
                "ExplanationCode": {
                    "type": "string"
                },
                "IngressRouteTable": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisComponent"
                },
                "InternetGateway": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisComponent"
                },
                "LoadBalancerArn": {
                    "type": "string"
                },
                "LoadBalancerListenerPort": {
                    "type": "number"
                },
                "LoadBalancerTarget": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisLoadBalancerTarget"
                },
                "LoadBalancerTargetGroup": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisComponent"
                },
                "LoadBalancerTargetGroups": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisComponent"
                    },
                    "type": "array"
                },
                "LoadBalancerTargetPort": {
                    "type": "number"
                },
                "MissingComponent": {
                    "type": "string"
                },
                "NatGateway": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisComponent"
                },
                "NetworkInterface": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisComponent"
                },
                "PacketField": {
                    "type": "string"
                },
                "Port": {
                    "type": "number"
                },
                "PortRanges": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.PortRange"
                    },
                    "type": "array"
                },
                "PrefixList": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisComponent"
                },
                "Protocols": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "RouteTable": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisComponent"
                },
                "RouteTableRoute": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisRouteTableRoute"
                },
                "SecurityGroup": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisComponent"
                },
                "SecurityGroupRule": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisSecurityGroupRule"
                },
                "SecurityGroups": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisComponent"
                    },
                    "type": "array"
                },
                "SourceVpc": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisComponent"
                },
                "State": {
                    "type": "string"
                },
                "Subnet": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisComponent"
                },
                "SubnetRouteTable": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisComponent"
                },
                "TransitGateway": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisComponent"
                },
                "TransitGatewayAttachment": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisComponent"
                },
                "TransitGatewayRouteTable": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisComponent"
                },
                "TransitGatewayRouteTableRoute": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.TransitGatewayRouteTableRoute"
                },
                "Vpc": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisComponent"
                },
                "VpcPeeringConnection": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisComponent"
                },
                "VpnConnection": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisComponent"
                },
                "VpnGateway": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisComponent"
                },
                "vpcEndpoint": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisComponent"
                }
            },
            "type": "object"
        },
        "AWS::EC2::NetworkInsightsAnalysis.PathComponent": {
            "additionalProperties": false,
            "properties": {
                "AclRule": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisAclRule"
                },
                "AdditionalDetails": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AdditionalDetail"
                    },
                    "type": "array"
                },
                "Component": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisComponent"
                },
                "DestinationVpc": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisComponent"
                },
                "ElasticLoadBalancerListener": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisComponent"
                },
                "Explanations": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.Explanation"
                    },
                    "type": "array"
                },
                "InboundHeader": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisPacketHeader"
                },
                "OutboundHeader": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisPacketHeader"
                },
                "RouteTableRoute": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisRouteTableRoute"
                },
                "SecurityGroupRule": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisSecurityGroupRule"
                },
                "SequenceNumber": {
                    "type": "number"
                },
                "ServiceName": {
                    "type": "string"
                },
                "SourceVpc": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisComponent"
                },
                "Subnet": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisComponent"
                },
                "TransitGateway": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisComponent"
                },
                "TransitGatewayRouteTableRoute": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.TransitGatewayRouteTableRoute"
                },
                "Vpc": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsAnalysis.AnalysisComponent"
                }
            },
            "type": "object"
        },
        "AWS::EC2::NetworkInsightsAnalysis.PortRange": {
            "additionalProperties": false,
            "properties": {
                "From": {
                    "type": "number"
                },
                "To": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::NetworkInsightsAnalysis.TransitGatewayRouteTableRoute": {
            "additionalProperties": false,
            "properties": {
                "AttachmentId": {
                    "type": "string"
                },
                "DestinationCidr": {
                    "type": "string"
                },
                "PrefixListId": {
                    "type": "string"
                },
                "ResourceId": {
                    "type": "string"
                },
                "ResourceType": {
                    "type": "string"
                },
                "RouteOrigin": {
                    "type": "string"
                },
                "State": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::NetworkInsightsPath": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Destination": {
                            "type": "string"
                        },
                        "DestinationIp": {
                            "type": "string"
                        },
                        "DestinationPort": {
                            "type": "number"
                        },
                        "FilterAtDestination": {
                            "$ref": "#/definitions/AWS::EC2::NetworkInsightsPath.PathFilter"
                        },
                        "FilterAtSource": {
                            "$ref": "#/definitions/AWS::EC2::NetworkInsightsPath.PathFilter"
                        },
                        "Protocol": {
                            "type": "string"
                        },
                        "Source": {
                            "type": "string"
                        },
                        "SourceIp": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "Protocol",
                        "Source"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::NetworkInsightsPath"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::NetworkInsightsPath.FilterPortRange": {
            "additionalProperties": false,
            "properties": {
                "FromPort": {
                    "type": "number"
                },
                "ToPort": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::NetworkInsightsPath.PathFilter": {
            "additionalProperties": false,
            "properties": {
                "DestinationAddress": {
                    "type": "string"
                },
                "DestinationPortRange": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsPath.FilterPortRange"
                },
                "SourceAddress": {
                    "type": "string"
                },
                "SourcePortRange": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInsightsPath.FilterPortRange"
                }
            },
            "type": "object"
        },
        "AWS::EC2::NetworkInterface": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ConnectionTrackingSpecification": {
                            "$ref": "#/definitions/AWS::EC2::NetworkInterface.ConnectionTrackingSpecification"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "GroupSet": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "InterfaceType": {
                            "type": "string"
                        },
                        "Ipv4PrefixCount": {
                            "type": "number"
                        },
                        "Ipv4Prefixes": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::NetworkInterface.Ipv4PrefixSpecification"
                            },
                            "type": "array"
                        },
                        "Ipv6AddressCount": {
                            "type": "number"
                        },
                        "Ipv6Addresses": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::NetworkInterface.InstanceIpv6Address"
                            },
                            "type": "array"
                        },
                        "Ipv6PrefixCount": {
                            "type": "number"
                        },
                        "Ipv6Prefixes": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::NetworkInterface.Ipv6PrefixSpecification"
                            },
                            "type": "array"
                        },
                        "PrivateIpAddress": {
                            "type": "string"
                        },
                        "PrivateIpAddresses": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::NetworkInterface.PrivateIpAddressSpecification"
                            },
                            "type": "array"
                        },
                        "SecondaryPrivateIpAddressCount": {
                            "type": "number"
                        },
                        "SourceDestCheck": {
                            "type": "boolean"
                        },
                        "SubnetId": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "SubnetId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::NetworkInterface"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::NetworkInterface.ConnectionTrackingSpecification": {
            "additionalProperties": false,
            "properties": {
                "TcpEstablishedTimeout": {
                    "type": "number"
                },
                "UdpStreamTimeout": {
                    "type": "number"
                },
                "UdpTimeout": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::NetworkInterface.InstanceIpv6Address": {
            "additionalProperties": false,
            "properties": {
                "Ipv6Address": {
                    "type": "string"
                }
            },
            "required": [
                "Ipv6Address"
            ],
            "type": "object"
        },
        "AWS::EC2::NetworkInterface.Ipv4PrefixSpecification": {
            "additionalProperties": false,
            "properties": {
                "Ipv4Prefix": {
                    "type": "string"
                }
            },
            "required": [
                "Ipv4Prefix"
            ],
            "type": "object"
        },
        "AWS::EC2::NetworkInterface.Ipv6PrefixSpecification": {
            "additionalProperties": false,
            "properties": {
                "Ipv6Prefix": {
                    "type": "string"
                }
            },
            "required": [
                "Ipv6Prefix"
            ],
            "type": "object"
        },
        "AWS::EC2::NetworkInterface.PrivateIpAddressSpecification": {
            "additionalProperties": false,
            "properties": {
                "Primary": {
                    "type": "boolean"
                },
                "PrivateIpAddress": {
                    "type": "string"
                }
            },
            "required": [
                "Primary",
                "PrivateIpAddress"
            ],
            "type": "object"
        },
        "AWS::EC2::NetworkInterfaceAttachment": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DeleteOnTermination": {
                            "type": "boolean"
                        },
                        "DeviceIndex": {
                            "type": "string"
                        },
                        "EnaSrdSpecification": {
                            "$ref": "#/definitions/AWS::EC2::NetworkInterfaceAttachment.EnaSrdSpecification"
                        },
                        "InstanceId": {
                            "type": "string"
                        },
                        "NetworkInterfaceId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "DeviceIndex",
                        "InstanceId",
                        "NetworkInterfaceId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::NetworkInterfaceAttachment"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::NetworkInterfaceAttachment.EnaSrdSpecification": {
            "additionalProperties": false,
            "properties": {
                "EnaSrdEnabled": {
                    "type": "boolean"
                },
                "EnaSrdUdpSpecification": {
                    "$ref": "#/definitions/AWS::EC2::NetworkInterfaceAttachment.EnaSrdUdpSpecification"
                }
            },
            "type": "object"
        },
        "AWS::EC2::NetworkInterfaceAttachment.EnaSrdUdpSpecification": {
            "additionalProperties": false,
            "properties": {
                "EnaSrdUdpEnabled": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::EC2::NetworkInterfacePermission": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AwsAccountId": {
                            "type": "string"
                        },
                        "NetworkInterfaceId": {
                            "type": "string"
                        },
                        "Permission": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "AwsAccountId",
                        "NetworkInterfaceId",
                        "Permission"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::NetworkInterfacePermission"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::NetworkPerformanceMetricSubscription": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Destination": {
                            "type": "string"
                        },
                        "Metric": {
                            "type": "string"
                        },
                        "Source": {
                            "type": "string"
                        },
                        "Statistic": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Destination",
                        "Metric",
                        "Source",
                        "Statistic"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::NetworkPerformanceMetricSubscription"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::PlacementGroup": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "PartitionCount": {
                            "type": "number"
                        },
                        "SpreadLevel": {
                            "type": "string"
                        },
                        "Strategy": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::PlacementGroup"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::EC2::PrefixList": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AddressFamily": {
                            "type": "string"
                        },
                        "Entries": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::PrefixList.Entry"
                            },
                            "type": "array"
                        },
                        "MaxEntries": {
                            "type": "number"
                        },
                        "PrefixListName": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "AddressFamily",
                        "PrefixListName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::PrefixList"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::PrefixList.Entry": {
            "additionalProperties": false,
            "properties": {
                "Cidr": {
                    "type": "string"
                },
                "Description": {
                    "type": "string"
                }
            },
            "required": [
                "Cidr"
            ],
            "type": "object"
        },
        "AWS::EC2::Route": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CarrierGatewayId": {
                            "type": "string"
                        },
                        "CoreNetworkArn": {
                            "type": "string"
                        },
                        "DestinationCidrBlock": {
                            "type": "string"
                        },
                        "DestinationIpv6CidrBlock": {
                            "type": "string"
                        },
                        "DestinationPrefixListId": {
                            "type": "string"
                        },
                        "EgressOnlyInternetGatewayId": {
                            "type": "string"
                        },
                        "GatewayId": {
                            "type": "string"
                        },
                        "InstanceId": {
                            "type": "string"
                        },
                        "LocalGatewayId": {
                            "type": "string"
                        },
                        "NatGatewayId": {
                            "type": "string"
                        },
                        "NetworkInterfaceId": {
                            "type": "string"
                        },
                        "RouteTableId": {
                            "type": "string"
                        },
                        "TransitGatewayId": {
                            "type": "string"
                        },
                        "VpcEndpointId": {
                            "type": "string"
                        },
                        "VpcPeeringConnectionId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "RouteTableId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::Route"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::RouteTable": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "VpcId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "VpcId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::RouteTable"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::SecurityGroup": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "GroupDescription": {
                            "type": "string"
                        },
                        "GroupName": {
                            "type": "string"
                        },
                        "SecurityGroupEgress": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::SecurityGroup.Egress"
                            },
                            "type": "array"
                        },
                        "SecurityGroupIngress": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::SecurityGroup.Ingress"
                            },
                            "type": "array"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "VpcId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "GroupDescription"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::SecurityGroup"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::SecurityGroup.Egress": {
            "additionalProperties": false,
            "properties": {
                "CidrIp": {
                    "type": "string"
                },
                "CidrIpv6": {
                    "type": "string"
                },
                "Description": {
                    "type": "string"
                },
                "DestinationPrefixListId": {
                    "type": "string"
                },
                "DestinationSecurityGroupId": {
                    "type": "string"
                },
                "FromPort": {
                    "type": "number"
                },
                "IpProtocol": {
                    "type": "string"
                },
                "ToPort": {
                    "type": "number"
                }
            },
            "required": [
                "IpProtocol"
            ],
            "type": "object"
        },
        "AWS::EC2::SecurityGroup.Ingress": {
            "additionalProperties": false,
            "properties": {
                "CidrIp": {
                    "type": "string"
                },
                "CidrIpv6": {
                    "type": "string"
                },
                "Description": {
                    "type": "string"
                },
                "FromPort": {
                    "type": "number"
                },
                "IpProtocol": {
                    "type": "string"
                },
                "SourcePrefixListId": {
                    "type": "string"
                },
                "SourceSecurityGroupId": {
                    "type": "string"
                },
                "SourceSecurityGroupName": {
                    "type": "string"
                },
                "SourceSecurityGroupOwnerId": {
                    "type": "string"
                },
                "ToPort": {
                    "type": "number"
                }
            },
            "required": [
                "IpProtocol"
            ],
            "type": "object"
        },
        "AWS::EC2::SecurityGroupEgress": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CidrIp": {
                            "type": "string"
                        },
                        "CidrIpv6": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "DestinationPrefixListId": {
                            "type": "string"
                        },
                        "DestinationSecurityGroupId": {
                            "type": "string"
                        },
                        "FromPort": {
                            "type": "number"
                        },
                        "GroupId": {
                            "type": "string"
                        },
                        "IpProtocol": {
                            "type": "string"
                        },
                        "ToPort": {
                            "type": "number"
                        }
                    },
                    "required": [
                        "GroupId",
                        "IpProtocol"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::SecurityGroupEgress"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::SecurityGroupIngress": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CidrIp": {
                            "type": "string"
                        },
                        "CidrIpv6": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "FromPort": {
                            "type": "number"
                        },
                        "GroupId": {
                            "type": "string"
                        },
                        "GroupName": {
                            "type": "string"
                        },
                        "IpProtocol": {
                            "type": "string"
                        },
                        "SourcePrefixListId": {
                            "type": "string"
                        },
                        "SourceSecurityGroupId": {
                            "type": "string"
                        },
                        "SourceSecurityGroupName": {
                            "type": "string"
                        },
                        "SourceSecurityGroupOwnerId": {
                            "type": "string"
                        },
                        "ToPort": {
                            "type": "number"
                        }
                    },
                    "required": [
                        "IpProtocol"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::SecurityGroupIngress"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::SecurityGroupVpcAssociation": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "GroupId": {
                            "type": "string"
                        },
                        "VpcId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "GroupId",
                        "VpcId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::SecurityGroupVpcAssociation"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::SnapshotBlockPublicAccess": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "State": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "State"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::SnapshotBlockPublicAccess"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::SpotFleet": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "SpotFleetRequestConfigData": {
                            "$ref": "#/definitions/AWS::EC2::SpotFleet.SpotFleetRequestConfigData"
                        }
                    },
                    "required": [
                        "SpotFleetRequestConfigData"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::SpotFleet"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::SpotFleet.AcceleratorCountRequest": {
            "additionalProperties": false,
            "properties": {
                "Max": {
                    "type": "number"
                },
                "Min": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::SpotFleet.AcceleratorTotalMemoryMiBRequest": {
            "additionalProperties": false,
            "properties": {
                "Max": {
                    "type": "number"
                },
                "Min": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::SpotFleet.BaselineEbsBandwidthMbpsRequest": {
            "additionalProperties": false,
            "properties": {
                "Max": {
                    "type": "number"
                },
                "Min": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::SpotFleet.BaselinePerformanceFactorsRequest": {
            "additionalProperties": false,
            "properties": {
                "Cpu": {
                    "$ref": "#/definitions/AWS::EC2::SpotFleet.CpuPerformanceFactorRequest"
                }
            },
            "type": "object"
        },
        "AWS::EC2::SpotFleet.BlockDeviceMapping": {
            "additionalProperties": false,
            "properties": {
                "DeviceName": {
                    "type": "string"
                },
                "Ebs": {
                    "$ref": "#/definitions/AWS::EC2::SpotFleet.EbsBlockDevice"
                },
                "NoDevice": {
                    "type": "string"
                },
                "VirtualName": {
                    "type": "string"
                }
            },
            "required": [
                "DeviceName"
            ],
            "type": "object"
        },
        "AWS::EC2::SpotFleet.ClassicLoadBalancer": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                }
            },
            "required": [
                "Name"
            ],
            "type": "object"
        },
        "AWS::EC2::SpotFleet.ClassicLoadBalancersConfig": {
            "additionalProperties": false,
            "properties": {
                "ClassicLoadBalancers": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::SpotFleet.ClassicLoadBalancer"
                    },
                    "type": "array"
                }
            },
            "required": [
                "ClassicLoadBalancers"
            ],
            "type": "object"
        },
        "AWS::EC2::SpotFleet.CpuPerformanceFactorRequest": {
            "additionalProperties": false,
            "properties": {
                "References": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::SpotFleet.PerformanceFactorReferenceRequest"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::EC2::SpotFleet.EbsBlockDevice": {
            "additionalProperties": false,
            "properties": {
                "DeleteOnTermination": {
                    "type": "boolean"
                },
                "Encrypted": {
                    "type": "boolean"
                },
                "Iops": {
                    "type": "number"
                },
                "SnapshotId": {
                    "type": "string"
                },
                "VolumeSize": {
                    "type": "number"
                },
                "VolumeType": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::SpotFleet.FleetLaunchTemplateSpecification": {
            "additionalProperties": false,
            "properties": {
                "LaunchTemplateId": {
                    "type": "string"
                },
                "LaunchTemplateName": {
                    "type": "string"
                },
                "Version": {
                    "type": "string"
                }
            },
            "required": [
                "Version"
            ],
            "type": "object"
        },
        "AWS::EC2::SpotFleet.GroupIdentifier": {
            "additionalProperties": false,
            "properties": {
                "GroupId": {
                    "type": "string"
                }
            },
            "required": [
                "GroupId"
            ],
            "type": "object"
        },
        "AWS::EC2::SpotFleet.IamInstanceProfileSpecification": {
            "additionalProperties": false,
            "properties": {
                "Arn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::SpotFleet.InstanceIpv6Address": {
            "additionalProperties": false,
            "properties": {
                "Ipv6Address": {
                    "type": "string"
                }
            },
            "required": [
                "Ipv6Address"
            ],
            "type": "object"
        },
        "AWS::EC2::SpotFleet.InstanceNetworkInterfaceSpecification": {
            "additionalProperties": false,
            "properties": {
                "AssociatePublicIpAddress": {
                    "type": "boolean"
                },
                "DeleteOnTermination": {
                    "type": "boolean"
                },
                "Description": {
                    "type": "string"
                },
                "DeviceIndex": {
                    "type": "number"
                },
                "Groups": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Ipv6AddressCount": {
                    "type": "number"
                },
                "Ipv6Addresses": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::SpotFleet.InstanceIpv6Address"
                    },
                    "type": "array"
                },
                "NetworkInterfaceId": {
                    "type": "string"
                },
                "PrivateIpAddresses": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::SpotFleet.PrivateIpAddressSpecification"
                    },
                    "type": "array"
                },
                "SecondaryPrivateIpAddressCount": {
                    "type": "number"
                },
                "SubnetId": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::SpotFleet.InstanceRequirementsRequest": {
            "additionalProperties": false,
            "properties": {
                "AcceleratorCount": {
                    "$ref": "#/definitions/AWS::EC2::SpotFleet.AcceleratorCountRequest"
                },
                "AcceleratorManufacturers": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "AcceleratorNames": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "AcceleratorTotalMemoryMiB": {
                    "$ref": "#/definitions/AWS::EC2::SpotFleet.AcceleratorTotalMemoryMiBRequest"
                },
                "AcceleratorTypes": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "AllowedInstanceTypes": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "BareMetal": {
                    "type": "string"
                },
                "BaselineEbsBandwidthMbps": {
                    "$ref": "#/definitions/AWS::EC2::SpotFleet.BaselineEbsBandwidthMbpsRequest"
                },
                "BaselinePerformanceFactors": {
                    "$ref": "#/definitions/AWS::EC2::SpotFleet.BaselinePerformanceFactorsRequest"
                },
                "BurstablePerformance": {
                    "type": "string"
                },
                "CpuManufacturers": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "ExcludedInstanceTypes": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "InstanceGenerations": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "LocalStorage": {
                    "type": "string"
                },
                "LocalStorageTypes": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "MaxSpotPriceAsPercentageOfOptimalOnDemandPrice": {
                    "type": "number"
                },
                "MemoryGiBPerVCpu": {
                    "$ref": "#/definitions/AWS::EC2::SpotFleet.MemoryGiBPerVCpuRequest"
                },
                "MemoryMiB": {
                    "$ref": "#/definitions/AWS::EC2::SpotFleet.MemoryMiBRequest"
                },
                "NetworkBandwidthGbps": {
                    "$ref": "#/definitions/AWS::EC2::SpotFleet.NetworkBandwidthGbpsRequest"
                },
                "NetworkInterfaceCount": {
                    "$ref": "#/definitions/AWS::EC2::SpotFleet.NetworkInterfaceCountRequest"
                },
                "OnDemandMaxPricePercentageOverLowestPrice": {
                    "type": "number"
                },
                "RequireHibernateSupport": {
                    "type": "boolean"
                },
                "SpotMaxPricePercentageOverLowestPrice": {
                    "type": "number"
                },
                "TotalLocalStorageGB": {
                    "$ref": "#/definitions/AWS::EC2::SpotFleet.TotalLocalStorageGBRequest"
                },
                "VCpuCount": {
                    "$ref": "#/definitions/AWS::EC2::SpotFleet.VCpuCountRangeRequest"
                }
            },
            "type": "object"
        },
        "AWS::EC2::SpotFleet.LaunchTemplateConfig": {
            "additionalProperties": false,
            "properties": {
                "LaunchTemplateSpecification": {
                    "$ref": "#/definitions/AWS::EC2::SpotFleet.FleetLaunchTemplateSpecification"
                },
                "Overrides": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::SpotFleet.LaunchTemplateOverrides"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::EC2::SpotFleet.LaunchTemplateOverrides": {
            "additionalProperties": false,
            "properties": {
                "AvailabilityZone": {
                    "type": "string"
                },
                "InstanceRequirements": {
                    "$ref": "#/definitions/AWS::EC2::SpotFleet.InstanceRequirementsRequest"
                },
                "InstanceType": {
                    "type": "string"
                },
                "Priority": {
                    "type": "number"
                },
                "SpotPrice": {
                    "type": "string"
                },
                "SubnetId": {
                    "type": "string"
                },
                "WeightedCapacity": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::SpotFleet.LoadBalancersConfig": {
            "additionalProperties": false,
            "properties": {
                "ClassicLoadBalancersConfig": {
                    "$ref": "#/definitions/AWS::EC2::SpotFleet.ClassicLoadBalancersConfig"
                },
                "TargetGroupsConfig": {
                    "$ref": "#/definitions/AWS::EC2::SpotFleet.TargetGroupsConfig"
                }
            },
            "type": "object"
        },
        "AWS::EC2::SpotFleet.MemoryGiBPerVCpuRequest": {
            "additionalProperties": false,
            "properties": {
                "Max": {
                    "type": "number"
                },
                "Min": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::SpotFleet.MemoryMiBRequest": {
            "additionalProperties": false,
            "properties": {
                "Max": {
                    "type": "number"
                },
                "Min": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::SpotFleet.NetworkBandwidthGbpsRequest": {
            "additionalProperties": false,
            "properties": {
                "Max": {
                    "type": "number"
                },
                "Min": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::SpotFleet.NetworkInterfaceCountRequest": {
            "additionalProperties": false,
            "properties": {
                "Max": {
                    "type": "number"
                },
                "Min": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::SpotFleet.PerformanceFactorReferenceRequest": {
            "additionalProperties": false,
            "properties": {
                "InstanceFamily": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::SpotFleet.PrivateIpAddressSpecification": {
            "additionalProperties": false,
            "properties": {
                "Primary": {
                    "type": "boolean"
                },
                "PrivateIpAddress": {
                    "type": "string"
                }
            },
            "required": [
                "PrivateIpAddress"
            ],
            "type": "object"
        },
        "AWS::EC2::SpotFleet.SpotCapacityRebalance": {
            "additionalProperties": false,
            "properties": {
                "ReplacementStrategy": {
                    "type": "string"
                },
                "TerminationDelay": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::SpotFleet.SpotFleetLaunchSpecification": {
            "additionalProperties": false,
            "properties": {
                "BlockDeviceMappings": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::SpotFleet.BlockDeviceMapping"
                    },
                    "type": "array"
                },
                "EbsOptimized": {
                    "type": "boolean"
                },
                "IamInstanceProfile": {
                    "$ref": "#/definitions/AWS::EC2::SpotFleet.IamInstanceProfileSpecification"
                },
                "ImageId": {
                    "type": "string"
                },
                "InstanceRequirements": {
                    "$ref": "#/definitions/AWS::EC2::SpotFleet.InstanceRequirementsRequest"
                },
                "InstanceType": {
                    "type": "string"
                },
                "KernelId": {
                    "type": "string"
                },
                "KeyName": {
                    "type": "string"
                },
                "Monitoring": {
                    "$ref": "#/definitions/AWS::EC2::SpotFleet.SpotFleetMonitoring"
                },
                "NetworkInterfaces": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::SpotFleet.InstanceNetworkInterfaceSpecification"
                    },
                    "type": "array"
                },
                "Placement": {
                    "$ref": "#/definitions/AWS::EC2::SpotFleet.SpotPlacement"
                },
                "RamdiskId": {
                    "type": "string"
                },
                "SecurityGroups": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::SpotFleet.GroupIdentifier"
                    },
                    "type": "array"
                },
                "SpotPrice": {
                    "type": "string"
                },
                "SubnetId": {
                    "type": "string"
                },
                "TagSpecifications": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::SpotFleet.SpotFleetTagSpecification"
                    },
                    "type": "array"
                },
                "UserData": {
                    "type": "string"
                },
                "WeightedCapacity": {
                    "type": "number"
                }
            },
            "required": [
                "ImageId"
            ],
            "type": "object"
        },
        "AWS::EC2::SpotFleet.SpotFleetMonitoring": {
            "additionalProperties": false,
            "properties": {
                "Enabled": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::EC2::SpotFleet.SpotFleetRequestConfigData": {
            "additionalProperties": false,
            "properties": {
                "AllocationStrategy": {
                    "type": "string"
                },
                "Context": {
                    "type": "string"
                },
                "ExcessCapacityTerminationPolicy": {
                    "type": "string"
                },
                "IamFleetRole": {
                    "type": "string"
                },
                "InstanceInterruptionBehavior": {
                    "type": "string"
                },
                "InstancePoolsToUseCount": {
                    "type": "number"
                },
                "LaunchSpecifications": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::SpotFleet.SpotFleetLaunchSpecification"
                    },
                    "type": "array"
                },
                "LaunchTemplateConfigs": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::SpotFleet.LaunchTemplateConfig"
                    },
                    "type": "array"
                },
                "LoadBalancersConfig": {
                    "$ref": "#/definitions/AWS::EC2::SpotFleet.LoadBalancersConfig"
                },
                "OnDemandAllocationStrategy": {
                    "type": "string"
                },
                "OnDemandMaxTotalPrice": {
                    "type": "string"
                },
                "OnDemandTargetCapacity": {
                    "type": "number"
                },
                "ReplaceUnhealthyInstances": {
                    "type": "boolean"
                },
                "SpotMaintenanceStrategies": {
                    "$ref": "#/definitions/AWS::EC2::SpotFleet.SpotMaintenanceStrategies"
                },
                "SpotMaxTotalPrice": {
                    "type": "string"
                },
                "SpotPrice": {
                    "type": "string"
                },
                "TagSpecifications": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::SpotFleet.SpotFleetTagSpecification"
                    },
                    "type": "array"
                },
                "TargetCapacity": {
                    "type": "number"
                },
                "TargetCapacityUnitType": {
                    "type": "string"
                },
                "TerminateInstancesWithExpiration": {
                    "type": "boolean"
                },
                "Type": {
                    "type": "string"
                },
                "ValidFrom": {
                    "type": "string"
                },
                "ValidUntil": {
                    "type": "string"
                }
            },
            "required": [
                "IamFleetRole",
                "TargetCapacity"
            ],
            "type": "object"
        },
        "AWS::EC2::SpotFleet.SpotFleetTagSpecification": {
            "additionalProperties": false,
            "properties": {
                "ResourceType": {
                    "type": "string"
                },
                "Tags": {
                    "items": {
                        "$ref": "#/definitions/Tag"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::EC2::SpotFleet.SpotMaintenanceStrategies": {
            "additionalProperties": false,
            "properties": {
                "CapacityRebalance": {
                    "$ref": "#/definitions/AWS::EC2::SpotFleet.SpotCapacityRebalance"
                }
            },
            "type": "object"
        },
        "AWS::EC2::SpotFleet.SpotPlacement": {
            "additionalProperties": false,
            "properties": {
                "AvailabilityZone": {
                    "type": "string"
                },
                "GroupName": {
                    "type": "string"
                },
                "Tenancy": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::SpotFleet.TargetGroup": {
            "additionalProperties": false,
            "properties": {
                "Arn": {
                    "type": "string"
                }
            },
            "required": [
                "Arn"
            ],
            "type": "object"
        },
        "AWS::EC2::SpotFleet.TargetGroupsConfig": {
            "additionalProperties": false,
            "properties": {
                "TargetGroups": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::SpotFleet.TargetGroup"
                    },
                    "type": "array"
                }
            },
            "required": [
                "TargetGroups"
            ],
            "type": "object"
        },
        "AWS::EC2::SpotFleet.TotalLocalStorageGBRequest": {
            "additionalProperties": false,
            "properties": {
                "Max": {
                    "type": "number"
                },
                "Min": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::SpotFleet.VCpuCountRangeRequest": {
            "additionalProperties": false,
            "properties": {
                "Max": {
                    "type": "number"
                },
                "Min": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::Subnet": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AssignIpv6AddressOnCreation": {
                            "type": "boolean"
                        },
                        "AvailabilityZone": {
                            "type": "string"
                        },
                        "AvailabilityZoneId": {
                            "type": "string"
                        },
                        "CidrBlock": {
                            "type": "string"
                        },
                        "EnableDns64": {
                            "type": "boolean"
                        },
                        "EnableLniAtDeviceIndex": {
                            "type": "number"
                        },
                        "Ipv4IpamPoolId": {
                            "type": "string"
                        },
                        "Ipv4NetmaskLength": {
                            "type": "number"
                        },
                        "Ipv6CidrBlock": {
                            "type": "string"
                        },
                        "Ipv6IpamPoolId": {
                            "type": "string"
                        },
                        "Ipv6Native": {
                            "type": "boolean"
                        },
                        "Ipv6NetmaskLength": {
                            "type": "number"
                        },
                        "MapPublicIpOnLaunch": {
                            "type": "boolean"
                        },
                        "OutpostArn": {
                            "type": "string"
                        },
                        "PrivateDnsNameOptionsOnLaunch": {
                            "$ref": "#/definitions/AWS::EC2::Subnet.PrivateDnsNameOptionsOnLaunch"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "VpcId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "VpcId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::Subnet"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::Subnet.PrivateDnsNameOptionsOnLaunch": {
            "additionalProperties": false,
            "properties": {
                "EnableResourceNameDnsAAAARecord": {
                    "type": "boolean"
                },
                "EnableResourceNameDnsARecord": {
                    "type": "boolean"
                },
                "HostnameType": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::SubnetCidrBlock": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Ipv6CidrBlock": {
                            "type": "string"
                        },
                        "Ipv6IpamPoolId": {
                            "type": "string"
                        },
                        "Ipv6NetmaskLength": {
                            "type": "number"
                        },
                        "SubnetId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "SubnetId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::SubnetCidrBlock"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::SubnetNetworkAclAssociation": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "NetworkAclId": {
                            "type": "string"
                        },
                        "SubnetId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "NetworkAclId",
                        "SubnetId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::SubnetNetworkAclAssociation"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::SubnetRouteTableAssociation": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "RouteTableId": {
                            "type": "string"
                        },
                        "SubnetId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "RouteTableId",
                        "SubnetId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::SubnetRouteTableAssociation"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::TrafficMirrorFilter": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "NetworkServices": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::TrafficMirrorFilter"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::EC2::TrafficMirrorFilterRule": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "DestinationCidrBlock": {
                            "type": "string"
                        },
                        "DestinationPortRange": {
                            "$ref": "#/definitions/AWS::EC2::TrafficMirrorFilterRule.TrafficMirrorPortRange"
                        },
                        "Protocol": {
                            "type": "number"
                        },
                        "RuleAction": {
                            "type": "string"
                        },
                        "RuleNumber": {
                            "type": "number"
                        },
                        "SourceCidrBlock": {
                            "type": "string"
                        },
                        "SourcePortRange": {
                            "$ref": "#/definitions/AWS::EC2::TrafficMirrorFilterRule.TrafficMirrorPortRange"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "TrafficDirection": {
                            "type": "string"
                        },
                        "TrafficMirrorFilterId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "DestinationCidrBlock",
                        "RuleAction",
                        "RuleNumber",
                        "SourceCidrBlock",
                        "TrafficDirection",
                        "TrafficMirrorFilterId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::TrafficMirrorFilterRule"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::TrafficMirrorFilterRule.TrafficMirrorPortRange": {
            "additionalProperties": false,
            "properties": {
                "FromPort": {
                    "type": "number"
                },
                "ToPort": {
                    "type": "number"
                }
            },
            "required": [
                "FromPort",
                "ToPort"
            ],
            "type": "object"
        },
        "AWS::EC2::TrafficMirrorSession": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "NetworkInterfaceId": {
                            "type": "string"
                        },
                        "PacketLength": {
                            "type": "number"
                        },
                        "SessionNumber": {
                            "type": "number"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "TrafficMirrorFilterId": {
                            "type": "string"
                        },
                        "TrafficMirrorTargetId": {
                            "type": "string"
                        },
                        "VirtualNetworkId": {
                            "type": "number"
                        }
                    },
                    "required": [
                        "NetworkInterfaceId",
                        "SessionNumber",
                        "TrafficMirrorFilterId",
                        "TrafficMirrorTargetId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::TrafficMirrorSession"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::TrafficMirrorTarget": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "GatewayLoadBalancerEndpointId": {
                            "type": "string"
                        },
                        "NetworkInterfaceId": {
                            "type": "string"
                        },
                        "NetworkLoadBalancerArn": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::TrafficMirrorTarget"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::EC2::TransitGateway": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AmazonSideAsn": {
                            "type": "number"
                        },
                        "AssociationDefaultRouteTableId": {
                            "type": "string"
                        },
                        "AutoAcceptSharedAttachments": {
                            "type": "string"
                        },
                        "DefaultRouteTableAssociation": {
                            "type": "string"
                        },
                        "DefaultRouteTablePropagation": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "DnsSupport": {
                            "type": "string"
                        },
                        "MulticastSupport": {
                            "type": "string"
                        },
                        "PropagationDefaultRouteTableId": {
                            "type": "string"
                        },
                        "SecurityGroupReferencingSupport": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "TransitGatewayCidrBlocks": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "VpnEcmpSupport": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::TransitGateway"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::EC2::TransitGatewayAttachment": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Options": {
                            "$ref": "#/definitions/AWS::EC2::TransitGatewayAttachment.Options"
                        },
                        "SubnetIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "TransitGatewayId": {
                            "type": "string"
                        },
                        "VpcId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "SubnetIds",
                        "TransitGatewayId",
                        "VpcId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::TransitGatewayAttachment"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::TransitGatewayAttachment.Options": {
            "additionalProperties": false,
            "properties": {
                "ApplianceModeSupport": {
                    "type": "string"
                },
                "DnsSupport": {
                    "type": "string"
                },
                "Ipv6Support": {
                    "type": "string"
                },
                "SecurityGroupReferencingSupport": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::TransitGatewayConnect": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Options": {
                            "$ref": "#/definitions/AWS::EC2::TransitGatewayConnect.TransitGatewayConnectOptions"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "TransportTransitGatewayAttachmentId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Options",
                        "TransportTransitGatewayAttachmentId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::TransitGatewayConnect"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::TransitGatewayConnect.TransitGatewayConnectOptions": {
            "additionalProperties": false,
            "properties": {
                "Protocol": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::TransitGatewayMulticastDomain": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Options": {
                            "$ref": "#/definitions/AWS::EC2::TransitGatewayMulticastDomain.Options"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "TransitGatewayId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "TransitGatewayId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::TransitGatewayMulticastDomain"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::TransitGatewayMulticastDomain.Options": {
            "additionalProperties": false,
            "properties": {
                "AutoAcceptSharedAssociations": {
                    "type": "string"
                },
                "Igmpv2Support": {
                    "type": "string"
                },
                "StaticSourcesSupport": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::TransitGatewayMulticastDomainAssociation": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "SubnetId": {
                            "type": "string"
                        },
                        "TransitGatewayAttachmentId": {
                            "type": "string"
                        },
                        "TransitGatewayMulticastDomainId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "SubnetId",
                        "TransitGatewayAttachmentId",
                        "TransitGatewayMulticastDomainId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::TransitGatewayMulticastDomainAssociation"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::TransitGatewayMulticastGroupMember": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "GroupIpAddress": {
                            "type": "string"
                        },
                        "NetworkInterfaceId": {
                            "type": "string"
                        },
                        "TransitGatewayMulticastDomainId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "GroupIpAddress",
                        "NetworkInterfaceId",
                        "TransitGatewayMulticastDomainId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::TransitGatewayMulticastGroupMember"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::TransitGatewayMulticastGroupSource": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "GroupIpAddress": {
                            "type": "string"
                        },
                        "NetworkInterfaceId": {
                            "type": "string"
                        },
                        "TransitGatewayMulticastDomainId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "GroupIpAddress",
                        "NetworkInterfaceId",
                        "TransitGatewayMulticastDomainId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::TransitGatewayMulticastGroupSource"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::TransitGatewayPeeringAttachment": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "PeerAccountId": {
                            "type": "string"
                        },
                        "PeerRegion": {
                            "type": "string"
                        },
                        "PeerTransitGatewayId": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "TransitGatewayId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "PeerAccountId",
                        "PeerRegion",
                        "PeerTransitGatewayId",
                        "TransitGatewayId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::TransitGatewayPeeringAttachment"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::TransitGatewayPeeringAttachment.PeeringAttachmentStatus": {
            "additionalProperties": false,
            "properties": {
                "Code": {
                    "type": "string"
                },
                "Message": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::TransitGatewayRoute": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Blackhole": {
                            "type": "boolean"
                        },
                        "DestinationCidrBlock": {
                            "type": "string"
                        },
                        "TransitGatewayAttachmentId": {
                            "type": "string"
                        },
                        "TransitGatewayRouteTableId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "DestinationCidrBlock",
                        "TransitGatewayRouteTableId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::TransitGatewayRoute"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::TransitGatewayRouteTable": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "TransitGatewayId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "TransitGatewayId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::TransitGatewayRouteTable"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::TransitGatewayRouteTableAssociation": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "TransitGatewayAttachmentId": {
                            "type": "string"
                        },
                        "TransitGatewayRouteTableId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "TransitGatewayAttachmentId",
                        "TransitGatewayRouteTableId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::TransitGatewayRouteTableAssociation"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::TransitGatewayRouteTablePropagation": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "TransitGatewayAttachmentId": {
                            "type": "string"
                        },
                        "TransitGatewayRouteTableId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "TransitGatewayAttachmentId",
                        "TransitGatewayRouteTableId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::TransitGatewayRouteTablePropagation"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::TransitGatewayVpcAttachment": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AddSubnetIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Options": {
                            "$ref": "#/definitions/AWS::EC2::TransitGatewayVpcAttachment.Options"
                        },
                        "RemoveSubnetIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "SubnetIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "TransitGatewayId": {
                            "type": "string"
                        },
                        "VpcId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "SubnetIds",
                        "TransitGatewayId",
                        "VpcId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::TransitGatewayVpcAttachment"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::TransitGatewayVpcAttachment.Options": {
            "additionalProperties": false,
            "properties": {
                "ApplianceModeSupport": {
                    "type": "string"
                },
                "DnsSupport": {
                    "type": "string"
                },
                "Ipv6Support": {
                    "type": "string"
                },
                "SecurityGroupReferencingSupport": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::VPC": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CidrBlock": {
                            "type": "string"
                        },
                        "EnableDnsHostnames": {
                            "type": "boolean"
                        },
                        "EnableDnsSupport": {
                            "type": "boolean"
                        },
                        "InstanceTenancy": {
                            "type": "string"
                        },
                        "Ipv4IpamPoolId": {
                            "type": "string"
                        },
                        "Ipv4NetmaskLength": {
                            "type": "number"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::VPC"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::EC2::VPCBlockPublicAccessExclusion": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "InternetGatewayExclusionMode": {
                            "type": "string"
                        },
                        "SubnetId": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "VpcId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "InternetGatewayExclusionMode"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::VPCBlockPublicAccessExclusion"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::VPCBlockPublicAccessOptions": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "InternetGatewayBlockMode": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "InternetGatewayBlockMode"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::VPCBlockPublicAccessOptions"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::VPCCidrBlock": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AmazonProvidedIpv6CidrBlock": {
                            "type": "boolean"
                        },
                        "CidrBlock": {
                            "type": "string"
                        },
                        "Ipv4IpamPoolId": {
                            "type": "string"
                        },
                        "Ipv4NetmaskLength": {
                            "type": "number"
                        },
                        "Ipv6CidrBlock": {
                            "type": "string"
                        },
                        "Ipv6CidrBlockNetworkBorderGroup": {
                            "type": "string"
                        },
                        "Ipv6IpamPoolId": {
                            "type": "string"
                        },
                        "Ipv6NetmaskLength": {
                            "type": "number"
                        },
                        "Ipv6Pool": {
                            "type": "string"
                        },
                        "VpcId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "VpcId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::VPCCidrBlock"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::VPCDHCPOptionsAssociation": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DhcpOptionsId": {
                            "type": "string"
                        },
                        "VpcId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "DhcpOptionsId",
                        "VpcId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::VPCDHCPOptionsAssociation"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::VPCEndpoint": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DnsOptions": {
                            "$ref": "#/definitions/AWS::EC2::VPCEndpoint.DnsOptionsSpecification"
                        },
                        "IpAddressType": {
                            "type": "string"
                        },
                        "PolicyDocument": {
                            "type": "object"
                        },
                        "PrivateDnsEnabled": {
                            "type": "boolean"
                        },
                        "ResourceConfigurationArn": {
                            "type": "string"
                        },
                        "RouteTableIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "SecurityGroupIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "ServiceName": {
                            "type": "string"
                        },
                        "ServiceNetworkArn": {
                            "type": "string"
                        },
                        "SubnetIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "VpcEndpointType": {
                            "type": "string"
                        },
                        "VpcId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "VpcId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::VPCEndpoint"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::VPCEndpoint.DnsOptionsSpecification": {
            "additionalProperties": false,
            "properties": {
                "DnsRecordIpType": {
                    "type": "string"
                },
                "PrivateDnsOnlyForInboundResolverEndpoint": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::VPCEndpointConnectionNotification": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ConnectionEvents": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "ConnectionNotificationArn": {
                            "type": "string"
                        },
                        "ServiceId": {
                            "type": "string"
                        },
                        "VPCEndpointId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ConnectionEvents",
                        "ConnectionNotificationArn"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::VPCEndpointConnectionNotification"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::VPCEndpointService": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AcceptanceRequired": {
                            "type": "boolean"
                        },
                        "ContributorInsightsEnabled": {
                            "type": "boolean"
                        },
                        "GatewayLoadBalancerArns": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "NetworkLoadBalancerArns": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "PayerResponsibility": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::VPCEndpointService"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::EC2::VPCEndpointServicePermissions": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AllowedPrincipals": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "ServiceId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ServiceId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::VPCEndpointServicePermissions"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::VPCGatewayAttachment": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "InternetGatewayId": {
                            "type": "string"
                        },
                        "VpcId": {
                            "type": "string"
                        },
                        "VpnGatewayId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "VpcId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::VPCGatewayAttachment"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::VPCPeeringConnection": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "PeerOwnerId": {
                            "type": "string"
                        },
                        "PeerRegion": {
                            "type": "string"
                        },
                        "PeerRoleArn": {
                            "type": "string"
                        },
                        "PeerVpcId": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "VpcId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "PeerVpcId",
                        "VpcId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::VPCPeeringConnection"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::VPNConnection": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CustomerGatewayId": {
                            "type": "string"
                        },
                        "EnableAcceleration": {
                            "type": "boolean"
                        },
                        "LocalIpv4NetworkCidr": {
                            "type": "string"
                        },
                        "LocalIpv6NetworkCidr": {
                            "type": "string"
                        },
                        "OutsideIpAddressType": {
                            "type": "string"
                        },
                        "RemoteIpv4NetworkCidr": {
                            "type": "string"
                        },
                        "RemoteIpv6NetworkCidr": {
                            "type": "string"
                        },
                        "StaticRoutesOnly": {
                            "type": "boolean"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "TransitGatewayId": {
                            "type": "string"
                        },
                        "TransportTransitGatewayAttachmentId": {
                            "type": "string"
                        },
                        "TunnelInsideIpVersion": {
                            "type": "string"
                        },
                        "Type": {
                            "type": "string"
                        },
                        "VpnGatewayId": {
                            "type": "string"
                        },
                        "VpnTunnelOptionsSpecifications": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::VPNConnection.VpnTunnelOptionsSpecification"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "CustomerGatewayId",
                        "Type"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::VPNConnection"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::VPNConnection.CloudwatchLogOptionsSpecification": {
            "additionalProperties": false,
            "properties": {
                "LogEnabled": {
                    "type": "boolean"
                },
                "LogGroupArn": {
                    "type": "string"
                },
                "LogOutputFormat": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::VPNConnection.IKEVersionsRequestListValue": {
            "additionalProperties": false,
            "properties": {
                "Value": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::VPNConnection.Phase1DHGroupNumbersRequestListValue": {
            "additionalProperties": false,
            "properties": {
                "Value": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::VPNConnection.Phase1EncryptionAlgorithmsRequestListValue": {
            "additionalProperties": false,
            "properties": {
                "Value": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::VPNConnection.Phase1IntegrityAlgorithmsRequestListValue": {
            "additionalProperties": false,
            "properties": {
                "Value": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::VPNConnection.Phase2DHGroupNumbersRequestListValue": {
            "additionalProperties": false,
            "properties": {
                "Value": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::VPNConnection.Phase2EncryptionAlgorithmsRequestListValue": {
            "additionalProperties": false,
            "properties": {
                "Value": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::VPNConnection.Phase2IntegrityAlgorithmsRequestListValue": {
            "additionalProperties": false,
            "properties": {
                "Value": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::VPNConnection.VpnTunnelLogOptionsSpecification": {
            "additionalProperties": false,
            "properties": {
                "CloudwatchLogOptions": {
                    "$ref": "#/definitions/AWS::EC2::VPNConnection.CloudwatchLogOptionsSpecification"
                }
            },
            "type": "object"
        },
        "AWS::EC2::VPNConnection.VpnTunnelOptionsSpecification": {
            "additionalProperties": false,
            "properties": {
                "DPDTimeoutAction": {
                    "type": "string"
                },
                "DPDTimeoutSeconds": {
                    "type": "number"
                },
                "EnableTunnelLifecycleControl": {
                    "type": "boolean"
                },
                "IKEVersions": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::VPNConnection.IKEVersionsRequestListValue"
                    },
                    "type": "array"
                },
                "LogOptions": {
                    "$ref": "#/definitions/AWS::EC2::VPNConnection.VpnTunnelLogOptionsSpecification"
                },
                "Phase1DHGroupNumbers": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::VPNConnection.Phase1DHGroupNumbersRequestListValue"
                    },
                    "type": "array"
                },
                "Phase1EncryptionAlgorithms": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::VPNConnection.Phase1EncryptionAlgorithmsRequestListValue"
                    },
                    "type": "array"
                },
                "Phase1IntegrityAlgorithms": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::VPNConnection.Phase1IntegrityAlgorithmsRequestListValue"
                    },
                    "type": "array"
                },
                "Phase1LifetimeSeconds": {
                    "type": "number"
                },
                "Phase2DHGroupNumbers": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::VPNConnection.Phase2DHGroupNumbersRequestListValue"
                    },
                    "type": "array"
                },
                "Phase2EncryptionAlgorithms": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::VPNConnection.Phase2EncryptionAlgorithmsRequestListValue"
                    },
                    "type": "array"
                },
                "Phase2IntegrityAlgorithms": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::VPNConnection.Phase2IntegrityAlgorithmsRequestListValue"
                    },
                    "type": "array"
                },
                "Phase2LifetimeSeconds": {
                    "type": "number"
                },
                "PreSharedKey": {
                    "type": "string"
                },
                "RekeyFuzzPercentage": {
                    "type": "number"
                },
                "RekeyMarginTimeSeconds": {
                    "type": "number"
                },
                "ReplayWindowSize": {
                    "type": "number"
                },
                "StartupAction": {
                    "type": "string"
                },
                "TunnelInsideCidr": {
                    "type": "string"
                },
                "TunnelInsideIpv6Cidr": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::VPNConnectionRoute": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DestinationCidrBlock": {
                            "type": "string"
                        },
                        "VpnConnectionId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "DestinationCidrBlock",
                        "VpnConnectionId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::VPNConnectionRoute"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::VPNGateway": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AmazonSideAsn": {
                            "type": "number"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "Type": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Type"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::VPNGateway"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::VPNGatewayRoutePropagation": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "RouteTableIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "VpnGatewayId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "RouteTableIds",
                        "VpnGatewayId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::VPNGatewayRoutePropagation"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::VerifiedAccessEndpoint": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApplicationDomain": {
                            "type": "string"
                        },
                        "AttachmentType": {
                            "type": "string"
                        },
                        "CidrOptions": {
                            "$ref": "#/definitions/AWS::EC2::VerifiedAccessEndpoint.CidrOptions"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "DomainCertificateArn": {
                            "type": "string"
                        },
                        "EndpointDomainPrefix": {
                            "type": "string"
                        },
                        "EndpointType": {
                            "type": "string"
                        },
                        "LoadBalancerOptions": {
                            "$ref": "#/definitions/AWS::EC2::VerifiedAccessEndpoint.LoadBalancerOptions"
                        },
                        "NetworkInterfaceOptions": {
                            "$ref": "#/definitions/AWS::EC2::VerifiedAccessEndpoint.NetworkInterfaceOptions"
                        },
                        "PolicyDocument": {
                            "type": "string"
                        },
                        "PolicyEnabled": {
                            "type": "boolean"
                        },
                        "RdsOptions": {
                            "$ref": "#/definitions/AWS::EC2::VerifiedAccessEndpoint.RdsOptions"
                        },
                        "SecurityGroupIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "SseSpecification": {
                            "$ref": "#/definitions/AWS::EC2::VerifiedAccessEndpoint.SseSpecification"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "VerifiedAccessGroupId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "AttachmentType",
                        "EndpointType",
                        "VerifiedAccessGroupId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::VerifiedAccessEndpoint"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::VerifiedAccessEndpoint.CidrOptions": {
            "additionalProperties": false,
            "properties": {
                "Cidr": {
                    "type": "string"
                },
                "PortRanges": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::VerifiedAccessEndpoint.PortRange"
                    },
                    "type": "array"
                },
                "Protocol": {
                    "type": "string"
                },
                "SubnetIds": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::EC2::VerifiedAccessEndpoint.LoadBalancerOptions": {
            "additionalProperties": false,
            "properties": {
                "LoadBalancerArn": {
                    "type": "string"
                },
                "Port": {
                    "type": "number"
                },
                "PortRanges": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::VerifiedAccessEndpoint.PortRange"
                    },
                    "type": "array"
                },
                "Protocol": {
                    "type": "string"
                },
                "SubnetIds": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::EC2::VerifiedAccessEndpoint.NetworkInterfaceOptions": {
            "additionalProperties": false,
            "properties": {
                "NetworkInterfaceId": {
                    "type": "string"
                },
                "Port": {
                    "type": "number"
                },
                "PortRanges": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::VerifiedAccessEndpoint.PortRange"
                    },
                    "type": "array"
                },
                "Protocol": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::VerifiedAccessEndpoint.PortRange": {
            "additionalProperties": false,
            "properties": {
                "FromPort": {
                    "type": "number"
                },
                "ToPort": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::VerifiedAccessEndpoint.RdsOptions": {
            "additionalProperties": false,
            "properties": {
                "Port": {
                    "type": "number"
                },
                "Protocol": {
                    "type": "string"
                },
                "RdsDbClusterArn": {
                    "type": "string"
                },
                "RdsDbInstanceArn": {
                    "type": "string"
                },
                "RdsDbProxyArn": {
                    "type": "string"
                },
                "RdsEndpoint": {
                    "type": "string"
                },
                "SubnetIds": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::EC2::VerifiedAccessEndpoint.SseSpecification": {
            "additionalProperties": false,
            "properties": {
                "CustomerManagedKeyEnabled": {
                    "type": "boolean"
                },
                "KmsKeyArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::VerifiedAccessGroup": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "PolicyDocument": {
                            "type": "string"
                        },
                        "PolicyEnabled": {
                            "type": "boolean"
                        },
                        "SseSpecification": {
                            "$ref": "#/definitions/AWS::EC2::VerifiedAccessGroup.SseSpecification"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "VerifiedAccessInstanceId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "VerifiedAccessInstanceId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::VerifiedAccessGroup"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::VerifiedAccessGroup.SseSpecification": {
            "additionalProperties": false,
            "properties": {
                "CustomerManagedKeyEnabled": {
                    "type": "boolean"
                },
                "KmsKeyArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::VerifiedAccessInstance": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CidrEndpointsCustomSubDomain": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "FipsEnabled": {
                            "type": "boolean"
                        },
                        "LoggingConfigurations": {
                            "$ref": "#/definitions/AWS::EC2::VerifiedAccessInstance.VerifiedAccessLogs"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "VerifiedAccessTrustProviderIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "VerifiedAccessTrustProviders": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::VerifiedAccessInstance.VerifiedAccessTrustProvider"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::VerifiedAccessInstance"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::EC2::VerifiedAccessInstance.CloudWatchLogs": {
            "additionalProperties": false,
            "properties": {
                "Enabled": {
                    "type": "boolean"
                },
                "LogGroup": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::VerifiedAccessInstance.KinesisDataFirehose": {
            "additionalProperties": false,
            "properties": {
                "DeliveryStream": {
                    "type": "string"
                },
                "Enabled": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::EC2::VerifiedAccessInstance.S3": {
            "additionalProperties": false,
            "properties": {
                "BucketName": {
                    "type": "string"
                },
                "BucketOwner": {
                    "type": "string"
                },
                "Enabled": {
                    "type": "boolean"
                },
                "Prefix": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::VerifiedAccessInstance.VerifiedAccessLogs": {
            "additionalProperties": false,
            "properties": {
                "CloudWatchLogs": {
                    "$ref": "#/definitions/AWS::EC2::VerifiedAccessInstance.CloudWatchLogs"
                },
                "IncludeTrustContext": {
                    "type": "boolean"
                },
                "KinesisDataFirehose": {
                    "$ref": "#/definitions/AWS::EC2::VerifiedAccessInstance.KinesisDataFirehose"
                },
                "LogVersion": {
                    "type": "string"
                },
                "S3": {
                    "$ref": "#/definitions/AWS::EC2::VerifiedAccessInstance.S3"
                }
            },
            "type": "object"
        },
        "AWS::EC2::VerifiedAccessInstance.VerifiedAccessTrustProvider": {
            "additionalProperties": false,
            "properties": {
                "Description": {
                    "type": "string"
                },
                "DeviceTrustProviderType": {
                    "type": "string"
                },
                "TrustProviderType": {
                    "type": "string"
                },
                "UserTrustProviderType": {
                    "type": "string"
                },
                "VerifiedAccessTrustProviderId": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::VerifiedAccessTrustProvider": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "DeviceOptions": {
                            "$ref": "#/definitions/AWS::EC2::VerifiedAccessTrustProvider.DeviceOptions"
                        },
                        "DeviceTrustProviderType": {
                            "type": "string"
                        },
                        "NativeApplicationOidcOptions": {
                            "$ref": "#/definitions/AWS::EC2::VerifiedAccessTrustProvider.NativeApplicationOidcOptions"
                        },
                        "OidcOptions": {
                            "$ref": "#/definitions/AWS::EC2::VerifiedAccessTrustProvider.OidcOptions"
                        },
                        "PolicyReferenceName": {
                            "type": "string"
                        },
                        "SseSpecification": {
                            "$ref": "#/definitions/AWS::EC2::VerifiedAccessTrustProvider.SseSpecification"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "TrustProviderType": {
                            "type": "string"
                        },
                        "UserTrustProviderType": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "PolicyReferenceName",
                        "TrustProviderType"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::VerifiedAccessTrustProvider"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::VerifiedAccessTrustProvider.DeviceOptions": {
            "additionalProperties": false,
            "properties": {
                "PublicSigningKeyUrl": {
                    "type": "string"
                },
                "TenantId": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::VerifiedAccessTrustProvider.NativeApplicationOidcOptions": {
            "additionalProperties": false,
            "properties": {
                "AuthorizationEndpoint": {
                    "type": "string"
                },
                "ClientId": {
                    "type": "string"
                },
                "ClientSecret": {
                    "type": "string"
                },
                "Issuer": {
                    "type": "string"
                },
                "PublicSigningKeyEndpoint": {
                    "type": "string"
                },
                "Scope": {
                    "type": "string"
                },
                "TokenEndpoint": {
                    "type": "string"
                },
                "UserInfoEndpoint": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::VerifiedAccessTrustProvider.OidcOptions": {
            "additionalProperties": false,
            "properties": {
                "AuthorizationEndpoint": {
                    "type": "string"
                },
                "ClientId": {
                    "type": "string"
                },
                "ClientSecret": {
                    "type": "string"
                },
                "Issuer": {
                    "type": "string"
                },
                "Scope": {
                    "type": "string"
                },
                "TokenEndpoint": {
                    "type": "string"
                },
                "UserInfoEndpoint": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::VerifiedAccessTrustProvider.SseSpecification": {
            "additionalProperties": false,
            "properties": {
                "CustomerManagedKeyEnabled": {
                    "type": "boolean"
                },
                "KmsKeyArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::Volume": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AutoEnableIO": {
                            "type": "boolean"
                        },
                        "AvailabilityZone": {
                            "type": "string"
                        },
                        "Encrypted": {
                            "type": "boolean"
                        },
                        "Iops": {
                            "type": "number"
                        },
                        "KmsKeyId": {
                            "type": "string"
                        },
                        "MultiAttachEnabled": {
                            "type": "boolean"
                        },
                        "OutpostArn": {
                            "type": "string"
                        },
                        "Size": {
                            "type": "number"
                        },
                        "SnapshotId": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "Throughput": {
                            "type": "number"
                        },
                        "VolumeType": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "AvailabilityZone"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::Volume"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::VolumeAttachment": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Device": {
                            "type": "string"
                        },
                        "InstanceId": {
                            "type": "string"
                        },
                        "VolumeId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "InstanceId",
                        "VolumeId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::VolumeAttachment"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ECR::PublicRepository": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "RepositoryCatalogData": {
                            "$ref": "#/definitions/AWS::ECR::PublicRepository.RepositoryCatalogData"
                        },
                        "RepositoryName": {
                            "type": "string"
                        },
                        "RepositoryPolicyText": {
                            "type": "object"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ECR::PublicRepository"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::ECR::PublicRepository.RepositoryCatalogData": {
            "additionalProperties": false,
            "properties": {
                "AboutText": {
                    "type": "string"
                },
                "Architectures": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "OperatingSystems": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "RepositoryDescription": {
                    "type": "string"
                },
                "UsageText": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ECR::PullThroughCacheRule": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CredentialArn": {
                            "type": "string"
                        },
                        "EcrRepositoryPrefix": {
                            "type": "string"
                        },
                        "UpstreamRegistry": {
                            "type": "string"
                        },
                        "UpstreamRegistryUrl": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ECR::PullThroughCacheRule"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::ECR::RegistryPolicy": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "PolicyText": {
                            "type": "object"
                        }
                    },
                    "required": [
                        "PolicyText"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ECR::RegistryPolicy"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ECR::ReplicationConfiguration": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ReplicationConfiguration": {
                            "$ref": "#/definitions/AWS::ECR::ReplicationConfiguration.ReplicationConfiguration"
                        }
                    },
                    "required": [
                        "ReplicationConfiguration"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ECR::ReplicationConfiguration"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ECR::ReplicationConfiguration.ReplicationConfiguration": {
            "additionalProperties": false,
            "properties": {
                "Rules": {
                    "items": {
                        "$ref": "#/definitions/AWS::ECR::ReplicationConfiguration.ReplicationRule"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Rules"
            ],
            "type": "object"
        },
        "AWS::ECR::ReplicationConfiguration.ReplicationDestination": {
            "additionalProperties": false,
            "properties": {
                "Region": {
                    "type": "string"
                },
                "RegistryId": {
                    "type": "string"
                }
            },
            "required": [
                "Region",
                "RegistryId"
            ],
            "type": "object"
        },
        "AWS::ECR::ReplicationConfiguration.ReplicationRule": {
            "additionalProperties": false,
            "properties": {
                "Destinations": {
                    "items": {
                        "$ref": "#/definitions/AWS::ECR::ReplicationConfiguration.ReplicationDestination"
                    },
                    "type": "array"
                },
                "RepositoryFilters": {
                    "items": {
                        "$ref": "#/definitions/AWS::ECR::ReplicationConfiguration.RepositoryFilter"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Destinations"
            ],
            "type": "object"
        },
        "AWS::ECR::ReplicationConfiguration.RepositoryFilter": {
            "additionalProperties": false,
            "properties": {
                "Filter": {
                    "type": "string"
                },
                "FilterType": {
                    "type": "string"
                }
            },
            "required": [
                "Filter",
                "FilterType"
            ],
            "type": "object"
        },
        "AWS::ECR::Repository": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "EmptyOnDelete": {
                            "type": "boolean"
                        },
                        "EncryptionConfiguration": {
                            "$ref": "#/definitions/AWS::ECR::Repository.EncryptionConfiguration"
                        },
                        "ImageScanningConfiguration": {
                            "$ref": "#/definitions/AWS::ECR::Repository.ImageScanningConfiguration"
                        },
                        "ImageTagMutability": {
                            "type": "string"
                        },
                        "LifecyclePolicy": {
                            "$ref": "#/definitions/AWS::ECR::Repository.LifecyclePolicy"
                        },
                        "RepositoryName": {
                            "type": "string"
                        },
                        "RepositoryPolicyText": {
                            "type": "object"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ECR::Repository"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::ECR::Repository.EncryptionConfiguration": {
            "additionalProperties": false,
            "properties": {
                "EncryptionType": {
                    "type": "string"
                },
                "KmsKey": {
                    "type": "string"
                }
            },
            "required": [
                "EncryptionType"
            ],
            "type": "object"
        },
        "AWS::ECR::Repository.ImageScanningConfiguration": {
            "additionalProperties": false,
            "properties": {
                "ScanOnPush": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::ECR::Repository.LifecyclePolicy": {
            "additionalProperties": false,
            "properties": {
                "LifecyclePolicyText": {
                    "type": "string"
                },
                "RegistryId": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ECR::RepositoryCreationTemplate": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AppliedFor": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "CustomRoleArn": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "EncryptionConfiguration": {
                            "$ref": "#/definitions/AWS::ECR::RepositoryCreationTemplate.EncryptionConfiguration"
                        },
                        "ImageTagMutability": {
                            "type": "string"
                        },
                        "LifecyclePolicy": {
                            "type": "string"
                        },
                        "Prefix": {
                            "type": "string"
                        },
                        "RepositoryPolicy": {
                            "type": "string"
                        },
                        "ResourceTags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "AppliedFor",
                        "Prefix"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ECR::RepositoryCreationTemplate"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ECR::RepositoryCreationTemplate.EncryptionConfiguration": {
            "additionalProperties": false,
            "properties": {
                "EncryptionType": {
                    "type": "string"
                },
                "KmsKey": {
                    "type": "string"
                }
            },
            "required": [
                "EncryptionType"
            ],
            "type": "object"
        },
        "AWS::EKS::AccessEntry": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AccessPolicies": {
                            "items": {
                                "$ref": "#/definitions/AWS::EKS::AccessEntry.AccessPolicy"
                            },
                            "type": "array"
                        },
                        "ClusterName": {
                            "type": "string"
                        },
                        "KubernetesGroups": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "PrincipalArn": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "Type": {
                            "type": "string"
                        },
                        "Username": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ClusterName",
                        "PrincipalArn"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EKS::AccessEntry"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EKS::AccessEntry.AccessPolicy": {
            "additionalProperties": false,
            "properties": {
                "AccessScope": {
                    "$ref": "#/definitions/AWS::EKS::AccessEntry.AccessScope"
                },
                "PolicyArn": {
                    "type": "string"
                }
            },
            "required": [
                "AccessScope",
                "PolicyArn"
            ],
            "type": "object"
        },
        "AWS::EKS::AccessEntry.AccessScope": {
            "additionalProperties": false,
            "properties": {
                "Namespaces": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::EKS::Addon": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AddonName": {
                            "type": "string"
                        },
                        "AddonVersion": {
                            "type": "string"
                        },
                        "ClusterName": {
                            "type": "string"
                        },
                        "ConfigurationValues": {
                            "type": "string"
                        },
                        "PodIdentityAssociations": {
                            "items": {
                                "$ref": "#/definitions/AWS::EKS::Addon.PodIdentityAssociation"
                            },
                            "type": "array"
                        },
                        "PreserveOnDelete": {
                            "type": "boolean"
                        },
                        "ResolveConflicts": {
                            "type": "string"
                        },
                        "ServiceAccountRoleArn": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "AddonName",
                        "ClusterName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EKS::Addon"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EKS::Addon.PodIdentityAssociation": {
            "additionalProperties": false,
            "properties": {
                "RoleArn": {
                    "type": "string"
                },
                "ServiceAccount": {
                    "type": "string"
                }
            },
            "required": [
                "RoleArn",
                "ServiceAccount"
            ],
            "type": "object"
        },
        "AWS::EKS::Cluster": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AccessConfig": {
                            "$ref": "#/definitions/AWS::EKS::Cluster.AccessConfig"
                        },
                        "BootstrapSelfManagedAddons": {
                            "type": "boolean"
                        },
                        "ComputeConfig": {
                            "$ref": "#/definitions/AWS::EKS::Cluster.ComputeConfig"
                        },
                        "EncryptionConfig": {
                            "items": {
                                "$ref": "#/definitions/AWS::EKS::Cluster.EncryptionConfig"
                            },
                            "type": "array"
                        },
                        "KubernetesNetworkConfig": {
                            "$ref": "#/definitions/AWS::EKS::Cluster.KubernetesNetworkConfig"
                        },
                        "Logging": {
                            "$ref": "#/definitions/AWS::EKS::Cluster.Logging"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "OutpostConfig": {
                            "$ref": "#/definitions/AWS::EKS::Cluster.OutpostConfig"
                        },
                        "RemoteNetworkConfig": {
                            "$ref": "#/definitions/AWS::EKS::Cluster.RemoteNetworkConfig"
                        },
                        "ResourcesVpcConfig": {
                            "$ref": "#/definitions/AWS::EKS::Cluster.ResourcesVpcConfig"
                        },
                        "RoleArn": {
                            "type": "string"
                        },
                        "StorageConfig": {
                            "$ref": "#/definitions/AWS::EKS::Cluster.StorageConfig"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "UpgradePolicy": {
                            "$ref": "#/definitions/AWS::EKS::Cluster.UpgradePolicy"
                        },
                        "Version": {
                            "type": "string"
                        },
                        "ZonalShiftConfig": {
                            "$ref": "#/definitions/AWS::EKS::Cluster.ZonalShiftConfig"
                        }
                    },
                    "required": [
                        "ResourcesVpcConfig",
                        "RoleArn"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EKS::Cluster"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EKS::Cluster.AccessConfig": {
            "additionalProperties": false,
            "properties": {
                "AuthenticationMode": {
                    "type": "string"
                },
                "BootstrapClusterCreatorAdminPermissions": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::EKS::Cluster.BlockStorage": {
            "additionalProperties": false,
            "properties": {
                "Enabled": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::EKS::Cluster.ClusterLogging": {
            "additionalProperties": false,
            "properties": {
                "EnabledTypes": {
                    "items": {
                        "$ref": "#/definitions/AWS::EKS::Cluster.LoggingTypeConfig"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::EKS::Cluster.ComputeConfig": {
            "additionalProperties": false,
            "properties": {
                "Enabled": {
                    "type": "boolean"
                },
                "NodePools": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "NodeRoleArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EKS::Cluster.ControlPlanePlacement": {
            "additionalProperties": false,
            "properties": {
                "GroupName": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EKS::Cluster.ElasticLoadBalancing": {
            "additionalProperties": false,
            "properties": {
                "Enabled": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::EKS::Cluster.EncryptionConfig": {
            "additionalProperties": false,
            "properties": {
                "Provider": {
                    "$ref": "#/definitions/AWS::EKS::Cluster.Provider"
                },
                "Resources": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::EKS::Cluster.KubernetesNetworkConfig": {
            "additionalProperties": false,
            "properties": {
                "ElasticLoadBalancing": {
                    "$ref": "#/definitions/AWS::EKS::Cluster.ElasticLoadBalancing"
                },
                "IpFamily": {
                    "type": "string"
                },
                "ServiceIpv4Cidr": {
                    "type": "string"
                },
                "ServiceIpv6Cidr": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EKS::Cluster.Logging": {
            "additionalProperties": false,
            "properties": {
                "ClusterLogging": {
                    "$ref": "#/definitions/AWS::EKS::Cluster.ClusterLogging"
                }
            },
            "type": "object"
        },
        "AWS::EKS::Cluster.LoggingTypeConfig": {
            "additionalProperties": false,
            "properties": {
                "Type": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EKS::Cluster.OutpostConfig": {
            "additionalProperties": false,
            "properties": {
                "ControlPlaneInstanceType": {
                    "type": "string"
                },
                "ControlPlanePlacement": {
                    "$ref": "#/definitions/AWS::EKS::Cluster.ControlPlanePlacement"
                },
                "OutpostArns": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "ControlPlaneInstanceType",
                "OutpostArns"
            ],
            "type": "object"
        },
        "AWS::EKS::Cluster.Provider": {
            "additionalProperties": false,
            "properties": {
                "KeyArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EKS::Cluster.RemoteNetworkConfig": {
            "additionalProperties": false,
            "properties": {
                "RemoteNodeNetworks": {
                    "items": {
                        "$ref": "#/definitions/AWS::EKS::Cluster.RemoteNodeNetwork"
                    },
                    "type": "array"
                },
                "RemotePodNetworks": {
                    "items": {
                        "$ref": "#/definitions/AWS::EKS::Cluster.RemotePodNetwork"
                    },
                    "type": "array"
                }
            },
            "required": [
                "RemoteNodeNetworks"
            ],
            "type": "object"
        },
        "AWS::EKS::Cluster.RemoteNodeNetwork": {
            "additionalProperties": false,
            "properties": {
                "Cidrs": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Cidrs"
            ],
            "type": "object"
        },
        "AWS::EKS::Cluster.RemotePodNetwork": {
            "additionalProperties": false,
            "properties": {
                "Cidrs": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Cidrs"
            ],
            "type": "object"
        },
        "AWS::EKS::Cluster.ResourcesVpcConfig": {
            "additionalProperties": false,
            "properties": {
                "EndpointPrivateAccess": {
                    "type": "boolean"
                },
                "EndpointPublicAccess": {
                    "type": "boolean"
                },
                "PublicAccessCidrs": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "SecurityGroupIds": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "SubnetIds": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "SubnetIds"
            ],
            "type": "object"
        },
        "AWS::EKS::Cluster.StorageConfig": {
            "additionalProperties": false,
            "properties": {
                "BlockStorage": {
                    "$ref": "#/definitions/AWS::EKS::Cluster.BlockStorage"
                }
            },
            "type": "object"
        },
        "AWS::EKS::Cluster.UpgradePolicy": {
            "additionalProperties": false,
            "properties": {
                "SupportType": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EKS::Cluster.ZonalShiftConfig": {
            "additionalProperties": false,
            "properties": {
                "Enabled": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::EKS::FargateProfile": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ClusterName": {
                            "type": "string"
                        },
                        "FargateProfileName": {
                            "type": "string"
                        },
                        "PodExecutionRoleArn": {
                            "type": "string"
                        },
                        "Selectors": {
                            "items": {
                                "$ref": "#/definitions/AWS::EKS::FargateProfile.Selector"
                            },
                            "type": "array"
                        },
                        "Subnets": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "ClusterName",
                        "PodExecutionRoleArn",
                        "Selectors"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EKS::FargateProfile"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EKS::FargateProfile.Label": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Key",
                "Value"
            ],
            "type": "object"
        },
        "AWS::EKS::FargateProfile.Selector": {
            "additionalProperties": false,
            "properties": {
                "Labels": {
                    "items": {
                        "$ref": "#/definitions/AWS::EKS::FargateProfile.Label"
                    },
                    "type": "array"
                },
                "Namespace": {
                    "type": "string"
                }
            },
            "required": [
                "Namespace"
            ],
            "type": "object"
        },
        "AWS::EKS::IdentityProviderConfig": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ClusterName": {
                            "type": "string"
                        },
                        "IdentityProviderConfigName": {
                            "type": "string"
                        },
                        "Oidc": {
                            "$ref": "#/definitions/AWS::EKS::IdentityProviderConfig.OidcIdentityProviderConfig"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "Type": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ClusterName",
                        "Type"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EKS::IdentityProviderConfig"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EKS::IdentityProviderConfig.OidcIdentityProviderConfig": {
            "additionalProperties": false,
            "properties": {
                "ClientId": {
                    "type": "string"
                },
                "GroupsClaim": {
                    "type": "string"
                },
                "GroupsPrefix": {
                    "type": "string"
                },
                "IssuerUrl": {
                    "type": "string"
                },
                "RequiredClaims": {
                    "items": {
                        "$ref": "#/definitions/AWS::EKS::IdentityProviderConfig.RequiredClaim"
                    },
                    "type": "array"
                },
                "UsernameClaim": {
                    "type": "string"
                },
                "UsernamePrefix": {
                    "type": "string"
                }
            },
            "required": [
                "ClientId",
                "IssuerUrl"
            ],
            "type": "object"
        },
        "AWS::EKS::IdentityProviderConfig.RequiredClaim": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Key",
                "Value"
            ],
            "type": "object"
        },
        "AWS::EKS::Nodegroup": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AmiType": {
                            "type": "string"
                        },
                        "CapacityType": {
                            "type": "string"
                        },
                        "ClusterName": {
                            "type": "string"
                        },
                        "DiskSize": {
                            "type": "number"
                        },
                        "ForceUpdateEnabled": {
                            "type": "boolean"
                        },
                        "InstanceTypes": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Labels": {
                            "additionalProperties": true,
                            "patternProperties": {
                                "^[a-zA-Z0-9]+$": {
                                    "type": "string"
                                }
                            },
                            "type": "object"
                        },
                        "LaunchTemplate": {
                            "$ref": "#/definitions/AWS::EKS::Nodegroup.LaunchTemplateSpecification"
                        },
                        "NodeRepairConfig": {
                            "$ref": "#/definitions/AWS::EKS::Nodegroup.NodeRepairConfig"
                        },
                        "NodeRole": {
                            "type": "string"
                        },
                        "NodegroupName": {
                            "type": "string"
                        },
                        "ReleaseVersion": {
                            "type": "string"
                        },
                        "RemoteAccess": {
                            "$ref": "#/definitions/AWS::EKS::Nodegroup.RemoteAccess"
                        },
                        "ScalingConfig": {
                            "$ref": "#/definitions/AWS::EKS::Nodegroup.ScalingConfig"
                        },
                        "Subnets": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Tags": {
                            "additionalProperties": true,
                            "patternProperties": {
                                "^[a-zA-Z0-9]+$": {
                                    "type": "string"
                                }
                            },
                            "type": "object"
                        },
                        "Taints": {
                            "items": {
                                "$ref": "#/definitions/AWS::EKS::Nodegroup.Taint"
                            },
                            "type": "array"
                        },
                        "UpdateConfig": {
                            "$ref": "#/definitions/AWS::EKS::Nodegroup.UpdateConfig"
                        },
                        "Version": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ClusterName",
                        "NodeRole",
                        "Subnets"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EKS::Nodegroup"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EKS::Nodegroup.LaunchTemplateSpecification": {
            "additionalProperties": false,
            "properties": {
                "Id": {
                    "type": "string"
                },
                "Name": {
                    "type": "string"
                },
                "Version": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EKS::Nodegroup.NodeRepairConfig": {
            "additionalProperties": false,
            "properties": {
                "Enabled": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::EKS::Nodegroup.RemoteAccess": {
            "additionalProperties": false,
            "properties": {
                "Ec2SshKey": {
                    "type": "string"
                },
                "SourceSecurityGroups": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Ec2SshKey"
            ],
            "type": "object"
        },
        "AWS::EKS::Nodegroup.ScalingConfig": {
            "additionalProperties": false,
            "properties": {
                "DesiredSize": {
                    "type": "number"
                },
                "MaxSize": {
                    "type": "number"
                },
                "MinSize": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EKS::Nodegroup.Taint": {
            "additionalProperties": false,
            "properties": {
                "Effect": {
                    "type": "string"
                },
                "Key": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EKS::Nodegroup.UpdateConfig": {
            "additionalProperties": false,
            "properties": {
                "MaxUnavailable": {
                    "type": "number"
                },
                "MaxUnavailablePercentage": {
                    "type": "number"
                },
                "UpdateStrategy": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EKS::PodIdentityAssociation": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ClusterName": {
                            "type": "string"
                        },
                        "Namespace": {
                            "type": "string"
                        },
                        "RoleArn": {
                            "type": "string"
                        },
                        "ServiceAccount": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "ClusterName",
                        "Namespace",
                        "RoleArn",
                        "ServiceAccount"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EKS::PodIdentityAssociation"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancing::LoadBalancer": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AccessLoggingPolicy": {
                            "$ref": "#/definitions/AWS::ElasticLoadBalancing::LoadBalancer.AccessLoggingPolicy"
                        },
                        "AppCookieStickinessPolicy": {
                            "items": {
                                "$ref": "#/definitions/AWS::ElasticLoadBalancing::LoadBalancer.AppCookieStickinessPolicy"
                            },
                            "type": "array"
                        },
                        "AvailabilityZones": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "ConnectionDrainingPolicy": {
                            "$ref": "#/definitions/AWS::ElasticLoadBalancing::LoadBalancer.ConnectionDrainingPolicy"
                        },
                        "ConnectionSettings": {
                            "$ref": "#/definitions/AWS::ElasticLoadBalancing::LoadBalancer.ConnectionSettings"
                        },
                        "CrossZone": {
                            "type": "boolean"
                        },
                        "HealthCheck": {
                            "$ref": "#/definitions/AWS::ElasticLoadBalancing::LoadBalancer.HealthCheck"
                        },
                        "Instances": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "LBCookieStickinessPolicy": {
                            "items": {
                                "$ref": "#/definitions/AWS::ElasticLoadBalancing::LoadBalancer.LBCookieStickinessPolicy"
                            },
                            "type": "array"
                        },
                        "Listeners": {
                            "items": {
                                "$ref": "#/definitions/AWS::ElasticLoadBalancing::LoadBalancer.Listeners"
                            },
                            "type": "array"
                        },
                        "LoadBalancerName": {
                            "type": "string"
                        },
                        "Policies": {
                            "items": {
                                "$ref": "#/definitions/AWS::ElasticLoadBalancing::LoadBalancer.Policies"
                            },
                            "type": "array"
                        },
                        "Scheme": {
                            "type": "string"
                        },
                        "SecurityGroups": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Subnets": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "Listeners"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ElasticLoadBalancing::LoadBalancer"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancing::LoadBalancer.AccessLoggingPolicy": {
            "additionalProperties": false,
            "properties": {
                "EmitInterval": {
                    "type": "number"
                },
                "Enabled": {
                    "type": "boolean"
                },
                "S3BucketName": {
                    "type": "string"
                },
                "S3BucketPrefix": {
                    "type": "string"
                }
            },
            "required": [
                "Enabled",
                "S3BucketName"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancing::LoadBalancer.AppCookieStickinessPolicy": {
            "additionalProperties": false,
            "properties": {
                "CookieName": {
                    "type": "string"
                },
                "PolicyName": {
                    "type": "string"
                }
            },
            "required": [
                "CookieName",
                "PolicyName"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancing::LoadBalancer.ConnectionDrainingPolicy": {
            "additionalProperties": false,
            "properties": {
                "Enabled": {
                    "type": "boolean"
                },
                "Timeout": {
                    "type": "number"
                }
            },
            "required": [
                "Enabled"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancing::LoadBalancer.ConnectionSettings": {
            "additionalProperties": false,
            "properties": {
                "IdleTimeout": {
                    "type": "number"
                }
            },
            "required": [
                "IdleTimeout"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancing::LoadBalancer.HealthCheck": {
            "additionalProperties": false,
            "properties": {
                "HealthyThreshold": {
                    "type": "string"
                },
                "Interval": {
                    "type": "string"
                },
                "Target": {
                    "type": "string"
                },
                "Timeout": {
                    "type": "string"
                },
                "UnhealthyThreshold": {
                    "type": "string"
                }
            },
            "required": [
                "HealthyThreshold",
                "Interval",
                "Target",
                "Timeout",
                "UnhealthyThreshold"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancing::LoadBalancer.LBCookieStickinessPolicy": {
            "additionalProperties": false,
            "properties": {
                "CookieExpirationPeriod": {
                    "type": "string"
                },
                "PolicyName": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ElasticLoadBalancing::LoadBalancer.Listeners": {
            "additionalProperties": false,
            "properties": {
                "InstancePort": {
                    "type": "string"
                },
                "InstanceProtocol": {
                    "type": "string"
                },
                "LoadBalancerPort": {
                    "type": "string"
                },
                "PolicyNames": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Protocol": {
                    "type": "string"
                },
                "SSLCertificateId": {
                    "type": "string"
                }
            },
            "required": [
                "InstancePort",
                "LoadBalancerPort",
                "Protocol"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancing::LoadBalancer.Policies": {
            "additionalProperties": false,
            "properties": {
                "Attributes": {
                    "items": {
                        "type": "object"
                    },
                    "type": "array"
                },
                "InstancePorts": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "LoadBalancerPorts": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "PolicyName": {
                    "type": "string"
                },
                "PolicyType": {
                    "type": "string"
                }
            },
            "required": [
                "Attributes",
                "PolicyName",
                "PolicyType"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::Listener": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AlpnPolicy": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Certificates": {
                            "items": {
                                "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::Listener.Certificate"
                            },
                            "type": "array"
                        },
                        "DefaultActions": {
                            "items": {
                                "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::Listener.Action"
                            },
                            "type": "array"
                        },
                        "ListenerAttributes": {
                            "items": {
                                "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::Listener.ListenerAttribute"
                            },
                            "type": "array"
                        },
                        "LoadBalancerArn": {
                            "type": "string"
                        },
                        "MutualAuthentication": {
                            "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::Listener.MutualAuthentication"
                        },
                        "Port": {
                            "type": "number"
                        },
                        "Protocol": {
                            "type": "string"
                        },
                        "SslPolicy": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "DefaultActions",
                        "LoadBalancerArn"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ElasticLoadBalancingV2::Listener"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::Listener.Action": {
            "additionalProperties": false,
            "properties": {
                "AuthenticateCognitoConfig": {
                    "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::Listener.AuthenticateCognitoConfig"
                },
                "AuthenticateOidcConfig": {
                    "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::Listener.AuthenticateOidcConfig"
                },
                "FixedResponseConfig": {
                    "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::Listener.FixedResponseConfig"
                },
                "ForwardConfig": {
                    "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::Listener.ForwardConfig"
                },
                "Order": {
                    "type": "number"
                },
                "RedirectConfig": {
                    "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::Listener.RedirectConfig"
                },
                "TargetGroupArn": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::Listener.AuthenticateCognitoConfig": {
            "additionalProperties": false,
            "properties": {
                "AuthenticationRequestExtraParams": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "OnUnauthenticatedRequest": {
                    "type": "string"
                },
                "Scope": {
                    "type": "string"
                },
                "SessionCookieName": {
                    "type": "string"
                },
                "SessionTimeout": {
                    "type": "string"
                },
                "UserPoolArn": {
                    "type": "string"
                },
                "UserPoolClientId": {
                    "type": "string"
                },
                "UserPoolDomain": {
                    "type": "string"
                }
            },
            "required": [
                "UserPoolArn",
                "UserPoolClientId",
                "UserPoolDomain"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::Listener.AuthenticateOidcConfig": {
            "additionalProperties": false,
            "properties": {
                "AuthenticationRequestExtraParams": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "AuthorizationEndpoint": {
                    "type": "string"
                },
                "ClientId": {
                    "type": "string"
                },
                "ClientSecret": {
                    "type": "string"
                },
                "Issuer": {
                    "type": "string"
                },
                "OnUnauthenticatedRequest": {
                    "type": "string"
                },
                "Scope": {
                    "type": "string"
                },
                "SessionCookieName": {
                    "type": "string"
                },
                "SessionTimeout": {
                    "type": "string"
                },
                "TokenEndpoint": {
                    "type": "string"
                },
                "UseExistingClientSecret": {
                    "type": "boolean"
                },
                "UserInfoEndpoint": {
                    "type": "string"
                }
            },
            "required": [
                "AuthorizationEndpoint",
                "ClientId",
                "Issuer",
                "TokenEndpoint",
                "UserInfoEndpoint"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::Listener.Certificate": {
            "additionalProperties": false,
            "properties": {
                "CertificateArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::Listener.FixedResponseConfig": {
            "additionalProperties": false,
            "properties": {
                "ContentType": {
                    "type": "string"
                },
                "MessageBody": {
                    "type": "string"
                },
                "StatusCode": {
                    "type": "string"
                }
            },
            "required": [
                "StatusCode"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::Listener.ForwardConfig": {
            "additionalProperties": false,
            "properties": {
                "TargetGroupStickinessConfig": {
                    "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::Listener.TargetGroupStickinessConfig"
                },
                "TargetGroups": {
                    "items": {
                        "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::Listener.TargetGroupTuple"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::Listener.ListenerAttribute": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::Listener.MutualAuthentication": {
            "additionalProperties": false,
            "properties": {
                "AdvertiseTrustStoreCaNames": {
                    "type": "string"
                },
                "IgnoreClientCertificateExpiry": {
                    "type": "boolean"
                },
                "Mode": {
                    "type": "string"
                },
                "TrustStoreArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::Listener.RedirectConfig": {
            "additionalProperties": false,
            "properties": {
                "Host": {
                    "type": "string"
                },
                "Path": {
                    "type": "string"
                },
                "Port": {
                    "type": "string"
                },
                "Protocol": {
                    "type": "string"
                },
                "Query": {
                    "type": "string"
                },
                "StatusCode": {
                    "type": "string"
                }
            },
            "required": [
                "StatusCode"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::Listener.TargetGroupStickinessConfig": {
            "additionalProperties": false,
            "properties": {
                "DurationSeconds": {
                    "type": "number"
                },
                "Enabled": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::Listener.TargetGroupTuple": {
            "additionalProperties": false,
            "properties": {
                "TargetGroupArn": {
                    "type": "string"
                },
                "Weight": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::ListenerCertificate": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Certificates": {
                            "items": {
                                "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::ListenerCertificate.Certificate"
                            },
                            "type": "array"
                        },
                        "ListenerArn": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Certificates",
                        "ListenerArn"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ElasticLoadBalancingV2::ListenerCertificate"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::ListenerCertificate.Certificate": {
            "additionalProperties": false,
            "properties": {
                "CertificateArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::ListenerRule": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Actions": {
                            "items": {
                                "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::ListenerRule.Action"
                            },
                            "type": "array"
                        },
                        "Conditions": {
                            "items": {
                                "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::ListenerRule.RuleCondition"
                            },
                            "type": "array"
                        },
                        "ListenerArn": {
                            "type": "string"
                        },
                        "Priority": {
                            "type": "number"
                        }
                    },
                    "required": [
                        "Actions",
                        "Conditions",
                        "Priority"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ElasticLoadBalancingV2::ListenerRule"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::ListenerRule.Action": {
            "additionalProperties": false,
            "properties": {
                "AuthenticateCognitoConfig": {
                    "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::ListenerRule.AuthenticateCognitoConfig"
                },
                "AuthenticateOidcConfig": {
                    "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::ListenerRule.AuthenticateOidcConfig"
                },
                "FixedResponseConfig": {
                    "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::ListenerRule.FixedResponseConfig"
                },
                "ForwardConfig": {
                    "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::ListenerRule.ForwardConfig"
                },
                "Order": {
                    "type": "number"
                },
                "RedirectConfig": {
                    "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::ListenerRule.RedirectConfig"
                },
                "TargetGroupArn": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::ListenerRule.AuthenticateCognitoConfig": {
            "additionalProperties": false,
            "properties": {
                "AuthenticationRequestExtraParams": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "OnUnauthenticatedRequest": {
                    "type": "string"
                },
                "Scope": {
                    "type": "string"
                },
                "SessionCookieName": {
                    "type": "string"
                },
                "SessionTimeout": {
                    "type": "number"
                },
                "UserPoolArn": {
                    "type": "string"
                },
                "UserPoolClientId": {
                    "type": "string"
                },
                "UserPoolDomain": {
                    "type": "string"
                }
            },
            "required": [
                "UserPoolArn",
                "UserPoolClientId",
                "UserPoolDomain"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::ListenerRule.AuthenticateOidcConfig": {
            "additionalProperties": false,
            "properties": {
                "AuthenticationRequestExtraParams": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "AuthorizationEndpoint": {
                    "type": "string"
                },
                "ClientId": {
                    "type": "string"
                },
                "ClientSecret": {
                    "type": "string"
                },
                "Issuer": {
                    "type": "string"
                },
                "OnUnauthenticatedRequest": {
                    "type": "string"
                },
                "Scope": {
                    "type": "string"
                },
                "SessionCookieName": {
                    "type": "string"
                },
                "SessionTimeout": {
                    "type": "number"
                },
                "TokenEndpoint": {
                    "type": "string"
                },
                "UseExistingClientSecret": {
                    "type": "boolean"
                },
                "UserInfoEndpoint": {
                    "type": "string"
                }
            },
            "required": [
                "AuthorizationEndpoint",
                "ClientId",
                "Issuer",
                "TokenEndpoint",
                "UserInfoEndpoint"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::ListenerRule.FixedResponseConfig": {
            "additionalProperties": false,
            "properties": {
                "ContentType": {
                    "type": "string"
                },
                "MessageBody": {
                    "type": "string"
                },
                "StatusCode": {
                    "type": "string"
                }
            },
            "required": [
                "StatusCode"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::ListenerRule.ForwardConfig": {
            "additionalProperties": false,
            "properties": {
                "TargetGroupStickinessConfig": {
                    "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::ListenerRule.TargetGroupStickinessConfig"
                },
                "TargetGroups": {
                    "items": {
                        "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::ListenerRule.TargetGroupTuple"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::ListenerRule.HostHeaderConfig": {
            "additionalProperties": false,
            "properties": {
                "Values": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::ListenerRule.HttpHeaderConfig": {
            "additionalProperties": false,
            "properties": {
                "HttpHeaderName": {
                    "type": "string"
                },
                "Values": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::ListenerRule.HttpRequestMethodConfig": {
            "additionalProperties": false,
            "properties": {
                "Values": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::ListenerRule.PathPatternConfig": {
            "additionalProperties": false,
            "properties": {
                "Values": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::ListenerRule.QueryStringConfig": {
            "additionalProperties": false,
            "properties": {
                "Values": {
                    "items": {
                        "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::ListenerRule.QueryStringKeyValue"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::ListenerRule.QueryStringKeyValue": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::ListenerRule.RedirectConfig": {
            "additionalProperties": false,
            "properties": {
                "Host": {
                    "type": "string"
                },
                "Path": {
                    "type": "string"
                },
                "Port": {
                    "type": "string"
                },
                "Protocol": {
                    "type": "string"
                },
                "Query": {
                    "type": "string"
                },
                "StatusCode": {
                    "type": "string"
                }
            },
            "required": [
                "StatusCode"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::ListenerRule.RuleCondition": {
            "additionalProperties": false,
            "properties": {
                "Field": {
                    "type": "string"
                },
                "HostHeaderConfig": {
                    "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::ListenerRule.HostHeaderConfig"
                },
                "HttpHeaderConfig": {
                    "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::ListenerRule.HttpHeaderConfig"
                },
                "HttpRequestMethodConfig": {
                    "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::ListenerRule.HttpRequestMethodConfig"
                },
                "PathPatternConfig": {
                    "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::ListenerRule.PathPatternConfig"
                },
                "QueryStringConfig": {
                    "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::ListenerRule.QueryStringConfig"
                },
                "SourceIpConfig": {
                    "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::ListenerRule.SourceIpConfig"
                },
                "Values": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::ListenerRule.SourceIpConfig": {
            "additionalProperties": false,
            "properties": {
                "Values": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::ListenerRule.TargetGroupStickinessConfig": {
            "additionalProperties": false,
            "properties": {
                "DurationSeconds": {
                    "type": "number"
                },
                "Enabled": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::ListenerRule.TargetGroupTuple": {
            "additionalProperties": false,
            "properties": {
                "TargetGroupArn": {
                    "type": "string"
                },
                "Weight": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::LoadBalancer": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "EnablePrefixForIpv6SourceNat": {
                            "type": "string"
                        },
                        "EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic": {
                            "type": "string"
                        },
                        "IpAddressType": {
                            "type": "string"
                        },
                        "LoadBalancerAttributes": {
                            "items": {
                                "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::LoadBalancer.LoadBalancerAttribute"
                            },
                            "type": "array"
                        },
                        "MinimumLoadBalancerCapacity": {
                            "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::LoadBalancer.MinimumLoadBalancerCapacity"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "Scheme": {
                            "type": "string"
                        },
                        "SecurityGroups": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "SubnetMappings": {
                            "items": {
                                "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::LoadBalancer.SubnetMapping"
                            },
                            "type": "array"
                        },
                        "Subnets": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "Type": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ElasticLoadBalancingV2::LoadBalancer"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::LoadBalancer.LoadBalancerAttribute": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::LoadBalancer.MinimumLoadBalancerCapacity": {
            "additionalProperties": false,
            "properties": {
                "CapacityUnits": {
                    "type": "number"
                }
            },
            "required": [
                "CapacityUnits"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::LoadBalancer.SubnetMapping": {
            "additionalProperties": false,
            "properties": {
                "AllocationId": {
                    "type": "string"
                },
                "IPv6Address": {
                    "type": "string"
                },
                "PrivateIPv4Address": {
                    "type": "string"
                },
                "SourceNatIpv6Prefix": {
                    "type": "string"
                },
                "SubnetId": {
                    "type": "string"
                }
            },
            "required": [
                "SubnetId"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::TargetGroup": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "HealthCheckEnabled": {
                            "type": "boolean"
                        },
                        "HealthCheckIntervalSeconds": {
                            "type": "number"
                        },
                        "HealthCheckPath": {
                            "type": "string"
                        },
                        "HealthCheckPort": {
                            "type": "string"
                        },
                        "HealthCheckProtocol": {
                            "type": "string"
                        },
                        "HealthCheckTimeoutSeconds": {
                            "type": "number"
                        },
                        "HealthyThresholdCount": {
                            "type": "number"
                        },
                        "IpAddressType": {
                            "type": "string"
                        },
                        "Matcher": {
                            "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::TargetGroup.Matcher"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "Port": {
                            "type": "number"
                        },
                        "Protocol": {
                            "type": "string"
                        },
                        "ProtocolVersion": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "TargetGroupAttributes": {
                            "items": {
                                "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::TargetGroup.TargetGroupAttribute"
                            },
                            "type": "array"
                        },
                        "TargetType": {
                            "type": "string"
                        },
                        "Targets": {
                            "items": {
                                "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::TargetGroup.TargetDescription"
                            },
                            "type": "array"
                        },
                        "UnhealthyThresholdCount": {
                            "type": "number"
                        },
                        "VpcId": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ElasticLoadBalancingV2::TargetGroup"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::TargetGroup.Matcher": {
            "additionalProperties": false,
            "properties": {
                "GrpcCode": {
                    "type": "string"
                },
                "HttpCode": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::TargetGroup.TargetDescription": {
            "additionalProperties": false,
            "properties": {
                "AvailabilityZone": {
                    "type": "string"
                },
                "Id": {
                    "type": "string"
                },
                "Port": {
                    "type": "number"
                }
            },
            "required": [
                "Id"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::TargetGroup.TargetGroupAttribute": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::TrustStore": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CaCertificatesBundleS3Bucket": {
                            "type": "string"
                        },
                        "CaCertificatesBundleS3Key": {
                            "type": "string"
                        },
                        "CaCertificatesBundleS3ObjectVersion": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ElasticLoadBalancingV2::TrustStore"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::TrustStoreRevocation": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "RevocationContents": {
                            "items": {
                                "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::TrustStoreRevocation.RevocationContent"
                            },
                            "type": "array"
                        },
                        "TrustStoreArn": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ElasticLoadBalancingV2::TrustStoreRevocation"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::TrustStoreRevocation.RevocationContent": {
            "additionalProperties": false,
            "properties": {
                "RevocationType": {
                    "type": "string"
                },
                "S3Bucket": {
                    "type": "string"
                },
                "S3Key": {
                    "type": "string"
                },
                "S3ObjectVersion": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::TrustStoreRevocation.TrustStoreRevocation": {
            "additionalProperties": false,
            "properties": {
                "NumberOfRevokedEntries": {
                    "type": "number"
                },
                "RevocationId": {
                    "type": "string"
                },
                "RevocationType": {
                    "type": "string"
                },
                "TrustStoreArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Events::ApiDestination": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ConnectionArn": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "HttpMethod": {
                            "type": "string"
                        },
                        "InvocationEndpoint": {
                            "type": "string"
                        },
                        "InvocationRateLimitPerSecond": {
                            "type": "number"
                        },
                        "Name": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ConnectionArn",
                        "HttpMethod",
                        "InvocationEndpoint"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Events::ApiDestination"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Events::Archive": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ArchiveName": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "EventPattern": {
                            "type": "object"
                        },
                        "RetentionDays": {
                            "type": "number"
                        },
                        "SourceArn": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "SourceArn"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Events::Archive"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Events::Connection": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AuthParameters": {
                            "$ref": "#/definitions/AWS::Events::Connection.AuthParameters"
                        },
                        "AuthorizationType": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "InvocationConnectivityParameters": {
                            "$ref": "#/definitions/AWS::Events::Connection.InvocationConnectivityParameters"
                        },
                        "Name": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Events::Connection"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::Events::Connection.ApiKeyAuthParameters": {
            "additionalProperties": false,
            "properties": {
                "ApiKeyName": {
                    "type": "string"
                },
                "ApiKeyValue": {
                    "type": "string"
                }
            },
            "required": [
                "ApiKeyName",
                "ApiKeyValue"
            ],
            "type": "object"
        },
        "AWS::Events::Connection.AuthParameters": {
            "additionalProperties": false,
            "properties": {
                "ApiKeyAuthParameters": {
                    "$ref": "#/definitions/AWS::Events::Connection.ApiKeyAuthParameters"
                },
                "BasicAuthParameters": {
                    "$ref": "#/definitions/AWS::Events::Connection.BasicAuthParameters"
                },
                "ConnectivityParameters": {
                    "$ref": "#/definitions/AWS::Events::Connection.ConnectivityParameters"
                },
                "InvocationHttpParameters": {
                    "$ref": "#/definitions/AWS::Events::Connection.ConnectionHttpParameters"
                },
                "OAuthParameters": {
                    "$ref": "#/definitions/AWS::Events::Connection.OAuthParameters"
                }
            },
            "type": "object"
        },
        "AWS::Events::Connection.BasicAuthParameters": {
            "additionalProperties": false,
            "properties": {
                "Password": {
                    "type": "string"
                },
                "Username": {
                    "type": "string"
                }
            },
            "required": [
                "Password",
                "Username"
            ],
            "type": "object"
        },
        "AWS::Events::Connection.ClientParameters": {
            "additionalProperties": false,
            "properties": {
                "ClientID": {
                    "type": "string"
                },
                "ClientSecret": {
                    "type": "string"
                }
            },
            "required": [
                "ClientID",
                "ClientSecret"
            ],
            "type": "object"
        },
        "AWS::Events::Connection.ConnectionHttpParameters": {
            "additionalProperties": false,
            "properties": {
                "BodyParameters": {
                    "items": {
                        "$ref": "#/definitions/AWS::Events::Connection.Parameter"
                    },
                    "type": "array"
                },
                "HeaderParameters": {
                    "items": {
                        "$ref": "#/definitions/AWS::Events::Connection.Parameter"
                    },
                    "type": "array"
                },
                "QueryStringParameters": {
                    "items": {
                        "$ref": "#/definitions/AWS::Events::Connection.Parameter"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::Events::Connection.ConnectivityParameters": {
            "additionalProperties": false,
            "properties": {
                "ResourceParameters": {
                    "$ref": "#/definitions/AWS::Events::Connection.ResourceParameters"
                }
            },
            "required": [
                "ResourceParameters"
            ],
            "type": "object"
        },
        "AWS::Events::Connection.InvocationConnectivityParameters": {
            "additionalProperties": false,
            "properties": {
                "ResourceParameters": {
                    "$ref": "#/definitions/AWS::Events::Connection.ResourceParameters"
                }
            },
            "required": [
                "ResourceParameters"
            ],
            "type": "object"
        },
        "AWS::Events::Connection.OAuthParameters": {
            "additionalProperties": false,
            "properties": {
                "AuthorizationEndpoint": {
                    "type": "string"
                },
                "ClientParameters": {
                    "$ref": "#/definitions/AWS::Events::Connection.ClientParameters"
                },
                "HttpMethod": {
                    "type": "string"
                },
                "OAuthHttpParameters": {
                    "$ref": "#/definitions/AWS::Events::Connection.ConnectionHttpParameters"
                }
            },
            "required": [
                "AuthorizationEndpoint",
                "ClientParameters",
                "HttpMethod"
            ],
            "type": "object"
        },
        "AWS::Events::Connection.Parameter": {
            "additionalProperties": false,
            "properties": {
                "IsValueSecret": {
                    "type": "boolean"
                },
                "Key": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Key",
                "Value"
            ],
            "type": "object"
        },
        "AWS::Events::Connection.ResourceParameters": {
            "additionalProperties": false,
            "properties": {
                "ResourceAssociationArn": {
                    "type": "string"
                },
                "ResourceConfigurationArn": {
                    "type": "string"
                }
            },
            "required": [
                "ResourceConfigurationArn"
            ],
            "type": "object"
        },
        "AWS::Events::Endpoint": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "EventBuses": {
                            "items": {
                                "$ref": "#/definitions/AWS::Events::Endpoint.EndpointEventBus"
                            },
                            "type": "array"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "ReplicationConfig": {
                            "$ref": "#/definitions/AWS::Events::Endpoint.ReplicationConfig"
                        },
                        "RoleArn": {
                            "type": "string"
                        },
                        "RoutingConfig": {
                            "$ref": "#/definitions/AWS::Events::Endpoint.RoutingConfig"
                        }
                    },
                    "required": [
                        "EventBuses",
                        "RoutingConfig"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Events::Endpoint"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Events::Endpoint.EndpointEventBus": {
            "additionalProperties": false,
            "properties": {
                "EventBusArn": {
                    "type": "string"
                }
            },
            "required": [
                "EventBusArn"
            ],
            "type": "object"
        },
        "AWS::Events::Endpoint.FailoverConfig": {
            "additionalProperties": false,
            "properties": {
                "Primary": {
                    "$ref": "#/definitions/AWS::Events::Endpoint.Primary"
                },
                "Secondary": {
                    "$ref": "#/definitions/AWS::Events::Endpoint.Secondary"
                }
            },
            "required": [
                "Primary",
                "Secondary"
            ],
            "type": "object"
        },
        "AWS::Events::Endpoint.Primary": {
            "additionalProperties": false,
            "properties": {
                "HealthCheck": {
                    "type": "string"
                }
            },
            "required": [
                "HealthCheck"
            ],
            "type": "object"
        },
        "AWS::Events::Endpoint.ReplicationConfig": {
            "additionalProperties": false,
            "properties": {
                "State": {
                    "type": "string"
                }
            },
            "required": [
                "State"
            ],
            "type": "object"
        },
        "AWS::Events::Endpoint.RoutingConfig": {
            "additionalProperties": false,
            "properties": {
                "FailoverConfig": {
                    "$ref": "#/definitions/AWS::Events::Endpoint.FailoverConfig"
                }
            },
            "required": [
                "FailoverConfig"
            ],
            "type": "object"
        },
        "AWS::Events::Endpoint.Secondary": {
            "additionalProperties": false,
            "properties": {
                "Route": {
                    "type": "string"
                }
            },
            "required": [
                "Route"
            ],
            "type": "object"
        },
        "AWS::Events::EventBus": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DeadLetterConfig": {
                            "$ref": "#/definitions/AWS::Events::EventBus.DeadLetterConfig"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "EventSourceName": {
                            "type": "string"
                        },
                        "KmsKeyIdentifier": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "Policy": {
                            "type": "object"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "Name"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Events::EventBus"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Events::EventBus.DeadLetterConfig": {
            "additionalProperties": false,
            "properties": {
                "Arn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Events::EventBusPolicy": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Action": {
                            "type": "string"
                        },
                        "Condition": {
                            "$ref": "#/definitions/AWS::Events::EventBusPolicy.Condition"
                        },
                        "EventBusName": {
                            "type": "string"
                        },
                        "Principal": {
                            "type": "string"
                        },
                        "Statement": {
                            "type": "object"
                        },
                        "StatementId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "StatementId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Events::EventBusPolicy"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Events::EventBusPolicy.Condition": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Events::Rule": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "EventBusName": {
                            "type": "string"
                        },
                        "EventPattern": {
                            "type": "object"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "RoleArn": {
                            "type": "string"
                        },
                        "ScheduleExpression": {
                            "type": "string"
                        },
                        "State": {
                            "type": "string"
                        },
                        "Targets": {
                            "items": {
                                "$ref": "#/definitions/AWS::Events::Rule.Target"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Events::Rule"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::Events::Rule.AppSyncParameters": {
            "additionalProperties": false,
            "properties": {
                "GraphQLOperation": {
                    "type": "string"
                }
            },
            "required": [
                "GraphQLOperation"
            ],
            "type": "object"
        },
        "AWS::Events::Rule.AwsVpcConfiguration": {
            "additionalProperties": false,
            "properties": {
                "AssignPublicIp": {
                    "type": "string"
                },
                "SecurityGroups": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Subnets": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Subnets"
            ],
            "type": "object"
        },
        "AWS::Events::Rule.BatchArrayProperties": {
            "additionalProperties": false,
            "properties": {
                "Size": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::Events::Rule.BatchParameters": {
            "additionalProperties": false,
            "properties": {
                "ArrayProperties": {
                    "$ref": "#/definitions/AWS::Events::Rule.BatchArrayProperties"
                },
                "JobDefinition": {
                    "type": "string"
                },
                "JobName": {
                    "type": "string"
                },
                "RetryStrategy": {
                    "$ref": "#/definitions/AWS::Events::Rule.BatchRetryStrategy"
                }
            },
            "required": [
                "JobDefinition",
                "JobName"
            ],
            "type": "object"
        },
        "AWS::Events::Rule.BatchRetryStrategy": {
            "additionalProperties": false,
            "properties": {
                "Attempts": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::Events::Rule.CapacityProviderStrategyItem": {
            "additionalProperties": false,
            "properties": {
                "Base": {
                    "type": "number"
                },
                "CapacityProvider": {
                    "type": "string"
                },
                "Weight": {
                    "type": "number"
                }
            },
            "required": [
                "CapacityProvider"
            ],
            "type": "object"
        },
        "AWS::Events::Rule.DeadLetterConfig": {
            "additionalProperties": false,
            "properties": {
                "Arn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Events::Rule.EcsParameters": {
            "additionalProperties": false,
            "properties": {
                "CapacityProviderStrategy": {
                    "items": {
                        "$ref": "#/definitions/AWS::Events::Rule.CapacityProviderStrategyItem"
                    },
                    "type": "array"
                },
                "EnableECSManagedTags": {
                    "type": "boolean"
                },
                "EnableExecuteCommand": {
                    "type": "boolean"
                },
                "Group": {
                    "type": "string"
                },
                "LaunchType": {
                    "type": "string"
                },
                "NetworkConfiguration": {
                    "$ref": "#/definitions/AWS::Events::Rule.NetworkConfiguration"
                },
                "PlacementConstraints": {
                    "items": {
                        "$ref": "#/definitions/AWS::Events::Rule.PlacementConstraint"
                    },
                    "type": "array"
                },
                "PlacementStrategies": {
                    "items": {
                        "$ref": "#/definitions/AWS::Events::Rule.PlacementStrategy"
                    },
                    "type": "array"
                },
                "PlatformVersion": {
                    "type": "string"
                },
                "PropagateTags": {
                    "type": "string"
                },
                "ReferenceId": {
                    "type": "string"
                },
                "TagList": {
                    "items": {
                        "$ref": "#/definitions/Tag"
                    },
                    "type": "array"
                },
                "TaskCount": {
                    "type": "number"
                },
                "TaskDefinitionArn": {
                    "type": "string"
                }
            },
            "required": [
                "TaskDefinitionArn"
            ],
            "type": "object"
        },
        "AWS::Events::Rule.HttpParameters": {
            "additionalProperties": false,
            "properties": {
                "HeaderParameters": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "PathParameterValues": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "QueryStringParameters": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                }
            },
            "type": "object"
        },
        "AWS::Events::Rule.InputTransformer": {
            "additionalProperties": false,
            "properties": {
                "InputPathsMap": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "InputTemplate": {
                    "type": "string"
                }
            },
            "required": [
                "InputTemplate"
            ],
            "type": "object"
        },
        "AWS::Events::Rule.KinesisParameters": {
            "additionalProperties": false,
            "properties": {
                "PartitionKeyPath": {
                    "type": "string"
                }
            },
            "required": [
                "PartitionKeyPath"
            ],
            "type": "object"
        },
        "AWS::Events::Rule.NetworkConfiguration": {
            "additionalProperties": false,
            "properties": {
                "AwsVpcConfiguration": {
                    "$ref": "#/definitions/AWS::Events::Rule.AwsVpcConfiguration"
                }
            },
            "type": "object"
        },
        "AWS::Events::Rule.PlacementConstraint": {
            "additionalProperties": false,
            "properties": {
                "Expression": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Events::Rule.PlacementStrategy": {
            "additionalProperties": false,
            "properties": {
                "Field": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Events::Rule.RedshiftDataParameters": {
            "additionalProperties": false,
            "properties": {
                "Database": {
                    "type": "string"
                },
                "DbUser": {
                    "type": "string"
                },
                "SecretManagerArn": {
                    "type": "string"
                },
                "Sql": {
                    "type": "string"
                },
                "Sqls": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "StatementName": {
                    "type": "string"
                },
                "WithEvent": {
                    "type": "boolean"
                }
            },
            "required": [
                "Database"
            ],
            "type": "object"
        },
        "AWS::Events::Rule.RetryPolicy": {
            "additionalProperties": false,
            "properties": {
                "MaximumEventAgeInSeconds": {
                    "type": "number"
                },
                "MaximumRetryAttempts": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::Events::Rule.RunCommandParameters": {
            "additionalProperties": false,
            "properties": {
                "RunCommandTargets": {
                    "items": {
                        "$ref": "#/definitions/AWS::Events::Rule.RunCommandTarget"
                    },
                    "type": "array"
                }
            },
            "required": [
                "RunCommandTargets"
            ],
            "type": "object"
        },
        "AWS::Events::Rule.RunCommandTarget": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Values": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Key",
                "Values"
            ],
            "type": "object"
        },
        "AWS::Events::Rule.SageMakerPipelineParameter": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Name",
                "Value"
            ],
            "type": "object"
        },
        "AWS::Events::Rule.SageMakerPipelineParameters": {
            "additionalProperties": false,
            "properties": {
                "PipelineParameterList": {
                    "items": {
                        "$ref": "#/definitions/AWS::Events::Rule.SageMakerPipelineParameter"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::Events::Rule.SqsParameters": {
            "additionalProperties": false,
            "properties": {
                "MessageGroupId": {
                    "type": "string"
                }
            },
            "required": [
                "MessageGroupId"
            ],
            "type": "object"
        },
        "AWS::Events::Rule.Target": {
            "additionalProperties": false,
            "properties": {
                "AppSyncParameters": {
                    "$ref": "#/definitions/AWS::Events::Rule.AppSyncParameters"
                },
                "Arn": {
                    "type": "string"
                },
                "BatchParameters": {
                    "$ref": "#/definitions/AWS::Events::Rule.BatchParameters"
                },
                "DeadLetterConfig": {
                    "$ref": "#/definitions/AWS::Events::Rule.DeadLetterConfig"
                },
                "EcsParameters": {
                    "$ref": "#/definitions/AWS::Events::Rule.EcsParameters"
                },
                "HttpParameters": {
                    "$ref": "#/definitions/AWS::Events::Rule.HttpParameters"
                },
                "Id": {
                    "type": "string"
                },
                "Input": {
                    "type": "string"
                },
                "InputPath": {
                    "type": "string"
                },
                "InputTransformer": {
                    "$ref": "#/definitions/AWS::Events::Rule.InputTransformer"
                },
                "KinesisParameters": {
                    "$ref": "#/definitions/AWS::Events::Rule.KinesisParameters"
                },
                "RedshiftDataParameters": {
                    "$ref": "#/definitions/AWS::Events::Rule.RedshiftDataParameters"
                },
                "RetryPolicy": {
                    "$ref": "#/definitions/AWS::Events::Rule.RetryPolicy"
                },
                "RoleArn": {
                    "type": "string"
                },
                "RunCommandParameters": {
                    "$ref": "#/definitions/AWS::Events::Rule.RunCommandParameters"
                },
                "SageMakerPipelineParameters": {
                    "$ref": "#/definitions/AWS::Events::Rule.SageMakerPipelineParameters"
                },
                "SqsParameters": {
                    "$ref": "#/definitions/AWS::Events::Rule.SqsParameters"
                }
            },
            "required": [
                "Arn",
                "Id"
            ],
            "type": "object"
        },
        "AWS::IAM::AccessKey": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Serial": {
                            "type": "number"
                        },
                        "Status": {
                            "type": "string"
                        },
                        "UserName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "UserName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::IAM::AccessKey"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::IAM::Group": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "GroupName": {
                            "type": "string"
                        },
                        "ManagedPolicyArns": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Path": {
                            "type": "string"
                        },
                        "Policies": {
                            "items": {
                                "$ref": "#/definitions/AWS::IAM::Group.Policy"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::IAM::Group"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::IAM::Group.Policy": {
            "additionalProperties": false,
            "properties": {
                "PolicyDocument": {
                    "type": "object"
                },
                "PolicyName": {
                    "type": "string"
                }
            },
            "required": [
                "PolicyDocument",
                "PolicyName"
            ],
            "type": "object"
        },
        "AWS::IAM::GroupPolicy": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "GroupName": {
                            "type": "string"
                        },
                        "PolicyDocument": {
                            "type": "object"
                        },
                        "PolicyName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "GroupName",
                        "PolicyName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::IAM::GroupPolicy"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::IAM::InstanceProfile": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "InstanceProfileName": {
                            "type": "string"
                        },
                        "Path": {
                            "type": "string"
                        },
                        "Roles": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "Roles"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::IAM::InstanceProfile"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::IAM::ManagedPolicy": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "Groups": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "ManagedPolicyName": {
                            "type": "string"
                        },
                        "Path": {
                            "type": "string"
                        },
                        "PolicyDocument": {
                            "type": "object"
                        },
                        "Roles": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Users": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "PolicyDocument"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::IAM::ManagedPolicy"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::IAM::OIDCProvider": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ClientIdList": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "ThumbprintList": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Url": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::IAM::OIDCProvider"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::IAM::Policy": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Groups": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "PolicyDocument": {
                            "type": "object"
                        },
                        "PolicyName": {
                            "type": "string"
                        },
                        "Roles": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Users": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "PolicyDocument",
                        "PolicyName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::IAM::Policy"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::IAM::Role": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AssumeRolePolicyDocument": {
                            "type": "object"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "ManagedPolicyArns": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "MaxSessionDuration": {
                            "type": "number"
                        },
                        "Path": {
                            "type": "string"
                        },
                        "PermissionsBoundary": {
                            "type": "string"
                        },
                        "Policies": {
                            "items": {
                                "$ref": "#/definitions/AWS::IAM::Role.Policy"
                            },
                            "type": "array"
                        },
                        "RoleName": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "AssumeRolePolicyDocument"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::IAM::Role"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::IAM::Role.Policy": {
            "additionalProperties": false,
            "properties": {
                "PolicyDocument": {
                    "type": "object"
                },
                "PolicyName": {
                    "type": "string"
                }
            },
            "required": [
                "PolicyDocument",
                "PolicyName"
            ],
            "type": "object"
        },
        "AWS::IAM::RolePolicy": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "PolicyDocument": {
                            "type": "object"
                        },
                        "PolicyName": {
                            "type": "string"
                        },
                        "RoleName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "PolicyName",
                        "RoleName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::IAM::RolePolicy"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::IAM::SAMLProvider": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Name": {
                            "type": "string"
                        },
                        "SamlMetadataDocument": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "SamlMetadataDocument"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::IAM::SAMLProvider"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::IAM::ServerCertificate": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CertificateBody": {
                            "type": "string"
                        },
                        "CertificateChain": {
                            "type": "string"
                        },
                        "Path": {
                            "type": "string"
                        },
                        "PrivateKey": {
                            "type": "string"
                        },
                        "ServerCertificateName": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::IAM::ServerCertificate"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::IAM::ServiceLinkedRole": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AWSServiceName": {
                            "type": "string"
                        },
                        "CustomSuffix": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::IAM::ServiceLinkedRole"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::IAM::User": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Groups": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "LoginProfile": {
                            "$ref": "#/definitions/AWS::IAM::User.LoginProfile"
                        },
                        "ManagedPolicyArns": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Path": {
                            "type": "string"
                        },
                        "PermissionsBoundary": {
                            "type": "string"
                        },
                        "Policies": {
                            "items": {
                                "$ref": "#/definitions/AWS::IAM::User.Policy"
                            },
                            "type": "array"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "UserName": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::IAM::User"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::IAM::User.LoginProfile": {
            "additionalProperties": false,
            "properties": {
                "Password": {
                    "type": "string"
                },
                "PasswordResetRequired": {
                    "type": "boolean"
                }
            },
            "required": [
                "Password"
            ],
            "type": "object"
        },
        "AWS::IAM::User.Policy": {
            "additionalProperties": false,
            "properties": {
                "PolicyDocument": {
                    "type": "object"
                },
                "PolicyName": {
                    "type": "string"
                }
            },
            "required": [
                "PolicyDocument",
                "PolicyName"
            ],
            "type": "object"
        },
        "AWS::IAM::UserPolicy": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "PolicyDocument": {
                            "type": "object"
                        },
                        "PolicyName": {
                            "type": "string"
                        },
                        "UserName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "PolicyName",
                        "UserName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::IAM::UserPolicy"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::IAM::UserToGroupAddition": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "GroupName": {
                            "type": "string"
                        },
                        "Users": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "GroupName",
                        "Users"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::IAM::UserToGroupAddition"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::IAM::VirtualMFADevice": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Path": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "Users": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "VirtualMfaDeviceName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Users"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::IAM::VirtualMFADevice"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::KMS::Alias": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AliasName": {
                            "type": "string"
                        },
                        "TargetKeyId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "AliasName",
                        "TargetKeyId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::KMS::Alias"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::KMS::Key": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "BypassPolicyLockoutSafetyCheck": {
                            "type": "boolean"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "EnableKeyRotation": {
                            "type": "boolean"
                        },
                        "Enabled": {
                            "type": "boolean"
                        },
                        "KeyPolicy": {
                            "type": "object"
                        },
                        "KeySpec": {
                            "type": "string"
                        },
                        "KeyUsage": {
                            "type": "string"
                        },
                        "MultiRegion": {
                            "type": "boolean"
                        },
                        "Origin": {
                            "type": "string"
                        },
                        "PendingWindowInDays": {
                            "type": "number"
                        },
                        "RotationPeriodInDays": {
                            "type": "number"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::KMS::Key"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::KMS::ReplicaKey": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "Enabled": {
                            "type": "boolean"
                        },
                        "KeyPolicy": {
                            "type": "object"
                        },
                        "PendingWindowInDays": {
                            "type": "number"
                        },
                        "PrimaryKeyArn": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "KeyPolicy",
                        "PrimaryKeyArn"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::KMS::ReplicaKey"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Kinesis::ResourcePolicy": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ResourceArn": {
                            "type": "string"
                        },
                        "ResourcePolicy": {
                            "type": "object"
                        }
                    },
                    "required": [
                        "ResourceArn",
                        "ResourcePolicy"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Kinesis::ResourcePolicy"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Kinesis::Stream": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Name": {
                            "type": "string"
                        },
                        "RetentionPeriodHours": {
                            "type": "number"
                        },
                        "ShardCount": {
                            "type": "number"
                        },
                        "StreamEncryption": {
                            "$ref": "#/definitions/AWS::Kinesis::Stream.StreamEncryption"
                        },
                        "StreamModeDetails": {
                            "$ref": "#/definitions/AWS::Kinesis::Stream.StreamModeDetails"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Kinesis::Stream"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::Kinesis::Stream.StreamEncryption": {
            "additionalProperties": false,
            "properties": {
                "EncryptionType": {
                    "type": "string"
                },
                "KeyId": {
                    "type": "string"
                }
            },
            "required": [
                "EncryptionType",
                "KeyId"
            ],
            "type": "object"
        },
        "AWS::Kinesis::Stream.StreamModeDetails": {
            "additionalProperties": false,
            "properties": {
                "StreamMode": {
                    "type": "string"
                }
            },
            "required": [
                "StreamMode"
            ],
            "type": "object"
        },
        "AWS::Kinesis::StreamConsumer": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ConsumerName": {
                            "type": "string"
                        },
                        "StreamARN": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ConsumerName",
                        "StreamARN"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Kinesis::StreamConsumer"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Lambda::Alias": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "FunctionName": {
                            "type": "string"
                        },
                        "FunctionVersion": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "ProvisionedConcurrencyConfig": {
                            "$ref": "#/definitions/AWS::Lambda::Alias.ProvisionedConcurrencyConfiguration"
                        },
                        "RoutingConfig": {
                            "$ref": "#/definitions/AWS::Lambda::Alias.AliasRoutingConfiguration"
                        }
                    },
                    "required": [
                        "FunctionName",
                        "FunctionVersion",
                        "Name"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Lambda::Alias"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Lambda::Alias.AliasRoutingConfiguration": {
            "additionalProperties": false,
            "properties": {
                "AdditionalVersionWeights": {
                    "items": {
                        "$ref": "#/definitions/AWS::Lambda::Alias.VersionWeight"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::Lambda::Alias.ProvisionedConcurrencyConfiguration": {
            "additionalProperties": false,
            "properties": {
                "ProvisionedConcurrentExecutions": {
                    "type": "number"
                }
            },
            "required": [
                "ProvisionedConcurrentExecutions"
            ],
            "type": "object"
        },
        "AWS::Lambda::Alias.VersionWeight": {
            "additionalProperties": false,
            "properties": {
                "FunctionVersion": {
                    "type": "string"
                },
                "FunctionWeight": {
                    "type": "number"
                }
            },
            "required": [
                "FunctionVersion",
                "FunctionWeight"
            ],
            "type": "object"
        },
        "AWS::Lambda::CodeSigningConfig": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AllowedPublishers": {
                            "$ref": "#/definitions/AWS::Lambda::CodeSigningConfig.AllowedPublishers"
                        },
                        "CodeSigningPolicies": {
                            "$ref": "#/definitions/AWS::Lambda::CodeSigningConfig.CodeSigningPolicies"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "AllowedPublishers"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Lambda::CodeSigningConfig"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Lambda::CodeSigningConfig.AllowedPublishers": {
            "additionalProperties": false,
            "properties": {
                "SigningProfileVersionArns": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "SigningProfileVersionArns"
            ],
            "type": "object"
        },
        "AWS::Lambda::CodeSigningConfig.CodeSigningPolicies": {
            "additionalProperties": false,
            "properties": {
                "UntrustedArtifactOnDeployment": {
                    "type": "string"
                }
            },
            "required": [
                "UntrustedArtifactOnDeployment"
            ],
            "type": "object"
        },
        "AWS::Lambda::EventInvokeConfig": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DestinationConfig": {
                            "$ref": "#/definitions/AWS::Lambda::EventInvokeConfig.DestinationConfig"
                        },
                        "FunctionName": {
                            "type": "string"
                        },
                        "MaximumEventAgeInSeconds": {
                            "type": "number"
                        },
                        "MaximumRetryAttempts": {
                            "type": "number"
                        },
                        "Qualifier": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "FunctionName",
                        "Qualifier"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Lambda::EventInvokeConfig"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Lambda::EventInvokeConfig.DestinationConfig": {
            "additionalProperties": false,
            "properties": {
                "OnFailure": {
                    "$ref": "#/definitions/AWS::Lambda::EventInvokeConfig.OnFailure"
                },
                "OnSuccess": {
                    "$ref": "#/definitions/AWS::Lambda::EventInvokeConfig.OnSuccess"
                }
            },
            "type": "object"
        },
        "AWS::Lambda::EventInvokeConfig.OnFailure": {
            "additionalProperties": false,
            "properties": {
                "Destination": {
                    "type": "string"
                }
            },
            "required": [
                "Destination"
            ],
            "type": "object"
        },
        "AWS::Lambda::EventInvokeConfig.OnSuccess": {
            "additionalProperties": false,
            "properties": {
                "Destination": {
                    "type": "string"
                }
            },
            "required": [
                "Destination"
            ],
            "type": "object"
        },
        "AWS::Lambda::EventSourceMapping": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AmazonManagedKafkaEventSourceConfig": {
                            "$ref": "#/definitions/AWS::Lambda::EventSourceMapping.AmazonManagedKafkaEventSourceConfig"
                        },
                        "BatchSize": {
                            "type": "number"
                        },
                        "BisectBatchOnFunctionError": {
                            "type": "boolean"
                        },
                        "DestinationConfig": {
                            "$ref": "#/definitions/AWS::Lambda::EventSourceMapping.DestinationConfig"
                        },
                        "DocumentDBEventSourceConfig": {
                            "$ref": "#/definitions/AWS::Lambda::EventSourceMapping.DocumentDBEventSourceConfig"
                        },
                        "Enabled": {
                            "type": "boolean"
                        },
                        "EventSourceArn": {
                            "type": "string"
                        },
                        "FilterCriteria": {
                            "$ref": "#/definitions/AWS::Lambda::EventSourceMapping.FilterCriteria"
                        },
                        "FunctionName": {
                            "type": "string"
                        },
                        "FunctionResponseTypes": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "KmsKeyArn": {
                            "type": "string"
                        },
                        "MaximumBatchingWindowInSeconds": {
                            "type": "number"
                        },
                        "MaximumRecordAgeInSeconds": {
                            "type": "number"
                        },
                        "MaximumRetryAttempts": {
                            "type": "number"
                        },
                        "MetricsConfig": {
                            "$ref": "#/definitions/AWS::Lambda::EventSourceMapping.MetricsConfig"
                        },
                        "ParallelizationFactor": {
                            "type": "number"
                        },
                        "ProvisionedPollerConfig": {
                            "$ref": "#/definitions/AWS::Lambda::EventSourceMapping.ProvisionedPollerConfig"
                        },
                        "Queues": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "ScalingConfig": {
                            "$ref": "#/definitions/AWS::Lambda::EventSourceMapping.ScalingConfig"
                        },
                        "SelfManagedEventSource": {
                            "$ref": "#/definitions/AWS::Lambda::EventSourceMapping.SelfManagedEventSource"
                        },
                        "SelfManagedKafkaEventSourceConfig": {
                            "$ref": "#/definitions/AWS::Lambda::EventSourceMapping.SelfManagedKafkaEventSourceConfig"
                        },
                        "SourceAccessConfigurations": {
                            "items": {
                                "$ref": "#/definitions/AWS::Lambda::EventSourceMapping.SourceAccessConfiguration"
                            },
                            "type": "array"
                        },
                        "StartingPosition": {
                            "type": "string"
                        },
                        "StartingPositionTimestamp": {
                            "type": "number"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "Topics": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "TumblingWindowInSeconds": {
                            "type": "number"
                        }
                    },
                    "required": [
                        "FunctionName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Lambda::EventSourceMapping"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Lambda::EventSourceMapping.AmazonManagedKafkaEventSourceConfig": {
            "additionalProperties": false,
            "properties": {
                "ConsumerGroupId": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Lambda::EventSourceMapping.DestinationConfig": {
            "additionalProperties": false,
            "properties": {
                "OnFailure": {
                    "$ref": "#/definitions/AWS::Lambda::EventSourceMapping.OnFailure"
                }
            },
            "type": "object"
        },
        "AWS::Lambda::EventSourceMapping.DocumentDBEventSourceConfig": {
            "additionalProperties": false,
            "properties": {
                "CollectionName": {
                    "type": "string"
                },
                "DatabaseName": {
                    "type": "string"
                },
                "FullDocument": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Lambda::EventSourceMapping.Endpoints": {
            "additionalProperties": false,
            "properties": {
                "KafkaBootstrapServers": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::Lambda::EventSourceMapping.Filter": {
            "additionalProperties": false,
            "properties": {
                "Pattern": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Lambda::EventSourceMapping.FilterCriteria": {
            "additionalProperties": false,
            "properties": {
                "Filters": {
                    "items": {
                        "$ref": "#/definitions/AWS::Lambda::EventSourceMapping.Filter"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::Lambda::EventSourceMapping.MetricsConfig": {
            "additionalProperties": false,
            "properties": {
                "Metrics": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::Lambda::EventSourceMapping.OnFailure": {
            "additionalProperties": false,
            "properties": {
                "Destination": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Lambda::EventSourceMapping.ProvisionedPollerConfig": {
            "additionalProperties": false,
            "properties": {
                "MaximumPollers": {
                    "type": "number"
                },
                "MinimumPollers": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::Lambda::EventSourceMapping.ScalingConfig": {
            "additionalProperties": false,
            "properties": {
                "MaximumConcurrency": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::Lambda::EventSourceMapping.SelfManagedEventSource": {
            "additionalProperties": false,
            "properties": {
                "Endpoints": {
                    "$ref": "#/definitions/AWS::Lambda::EventSourceMapping.Endpoints"
                }
            },
            "type": "object"
        },
        "AWS::Lambda::EventSourceMapping.SelfManagedKafkaEventSourceConfig": {
            "additionalProperties": false,
            "properties": {
                "ConsumerGroupId": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Lambda::EventSourceMapping.SourceAccessConfiguration": {
            "additionalProperties": false,
            "properties": {
                "Type": {
                    "type": "string"
                },
                "URI": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Lambda::Function": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Architectures": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Code": {
                            "$ref": "#/definitions/AWS::Lambda::Function.Code"
                        },
                        "CodeSigningConfigArn": {
                            "type": "string"
                        },
                        "DeadLetterConfig": {
                            "$ref": "#/definitions/AWS::Lambda::Function.DeadLetterConfig"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "Environment": {
                            "$ref": "#/definitions/AWS::Lambda::Function.Environment"
                        },
                        "EphemeralStorage": {
                            "$ref": "#/definitions/AWS::Lambda::Function.EphemeralStorage"
                        },
                        "FileSystemConfigs": {
                            "items": {
                                "$ref": "#/definitions/AWS::Lambda::Function.FileSystemConfig"
                            },
                            "type": "array"
                        },
                        "FunctionName": {
                            "type": "string"
                        },
                        "Handler": {
                            "type": "string"
                        },
                        "ImageConfig": {
                            "$ref": "#/definitions/AWS::Lambda::Function.ImageConfig"
                        },
                        "KmsKeyArn": {
                            "type": "string"
                        },
                        "Layers": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "LoggingConfig": {
                            "$ref": "#/definitions/AWS::Lambda::Function.LoggingConfig"
                        },
                        "MemorySize": {
                            "type": "number"
                        },
                        "PackageType": {
                            "type": "string"
                        },
                        "RecursiveLoop": {
                            "type": "string"
                        },
                        "ReservedConcurrentExecutions": {
                            "type": "number"
                        },
                        "Role": {
                            "type": "string"
                        },
                        "Runtime": {
                            "type": "string"
                        },
                        "RuntimeManagementConfig": {
                            "$ref": "#/definitions/AWS::Lambda::Function.RuntimeManagementConfig"
                        },
                        "SnapStart": {
                            "$ref": "#/definitions/AWS::Lambda::Function.SnapStart"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "Timeout": {
                            "type": "number"
                        },
                        "TracingConfig": {
                            "$ref": "#/definitions/AWS::Lambda::Function.TracingConfig"
                        },
                        "VpcConfig": {
                            "$ref": "#/definitions/AWS::Lambda::Function.VpcConfig"
                        }
                    },
                    "required": [
                        "Code",
                        "Role"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Lambda::Function"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Lambda::Function.Code": {
            "additionalProperties": false,
            "properties": {
                "ImageUri": {
                    "type": "string"
                },
                "S3Bucket": {
                    "type": "string"
                },
                "S3Key": {
                    "type": "string"
                },
                "S3ObjectVersion": {
                    "type": "string"
                },
                "SourceKMSKeyArn": {
                    "type": "string"
                },
                "ZipFile": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Lambda::Function.DeadLetterConfig": {
            "additionalProperties": false,
            "properties": {
                "TargetArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Lambda::Function.Environment": {
            "additionalProperties": false,
            "properties": {
                "Variables": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                }
            },
            "type": "object"
        },
        "AWS::Lambda::Function.EphemeralStorage": {
            "additionalProperties": false,
            "properties": {
                "Size": {
                    "type": "number"
                }
            },
            "required": [
                "Size"
            ],
            "type": "object"
        },
        "AWS::Lambda::Function.FileSystemConfig": {
            "additionalProperties": false,
            "properties": {
                "Arn": {
                    "type": "string"
                },
                "LocalMountPath": {
                    "type": "string"
                }
            },
            "required": [
                "Arn",
                "LocalMountPath"
            ],
            "type": "object"
        },
        "AWS::Lambda::Function.ImageConfig": {
            "additionalProperties": false,
            "properties": {
                "Command": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "EntryPoint": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "WorkingDirectory": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Lambda::Function.LoggingConfig": {
            "additionalProperties": false,
            "properties": {
                "ApplicationLogLevel": {
                    "type": "string"
                },
                "LogFormat": {
                    "type": "string"
                },
                "LogGroup": {
                    "type": "string"
                },
                "SystemLogLevel": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Lambda::Function.RuntimeManagementConfig": {
            "additionalProperties": false,
            "properties": {
                "RuntimeVersionArn": {
                    "type": "string"
                },
                "UpdateRuntimeOn": {
                    "type": "string"
                }
            },
            "required": [
                "UpdateRuntimeOn"
            ],
            "type": "object"
        },
        "AWS::Lambda::Function.SnapStart": {
            "additionalProperties": false,
            "properties": {
                "ApplyOn": {
                    "type": "string"
                }
            },
            "required": [
                "ApplyOn"
            ],
            "type": "object"
        },
        "AWS::Lambda::Function.SnapStartResponse": {
            "additionalProperties": false,
            "properties": {
                "ApplyOn": {
                    "type": "string"
                },
                "OptimizationStatus": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Lambda::Function.TracingConfig": {
            "additionalProperties": false,
            "properties": {
                "Mode": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Lambda::Function.VpcConfig": {
            "additionalProperties": false,
            "properties": {
                "Ipv6AllowedForDualStack": {
                    "type": "boolean"
                },
                "SecurityGroupIds": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "SubnetIds": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::Lambda::LayerVersion": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CompatibleArchitectures": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "CompatibleRuntimes": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Content": {
                            "$ref": "#/definitions/AWS::Lambda::LayerVersion.Content"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "LayerName": {
                            "type": "string"
                        },
                        "LicenseInfo": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Content"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Lambda::LayerVersion"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Lambda::LayerVersion.Content": {
            "additionalProperties": false,
            "properties": {
                "S3Bucket": {
                    "type": "string"
                },
                "S3Key": {
                    "type": "string"
                },
                "S3ObjectVersion": {
                    "type": "string"
                }
            },
            "required": [
                "S3Bucket",
                "S3Key"
            ],
            "type": "object"
        },
        "AWS::Lambda::LayerVersionPermission": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Action": {
                            "type": "string"
                        },
                        "LayerVersionArn": {
                            "type": "string"
                        },
                        "OrganizationId": {
                            "type": "string"
                        },
                        "Principal": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Action",
                        "LayerVersionArn",
                        "Principal"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Lambda::LayerVersionPermission"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Lambda::Permission": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Action": {
                            "type": "string"
                        },
                        "EventSourceToken": {
                            "type": "string"
                        },
                        "FunctionName": {
                            "type": "string"
                        },
                        "FunctionUrlAuthType": {
                            "type": "string"
                        },
                        "Principal": {
                            "type": "string"
                        },
                        "PrincipalOrgID": {
                            "type": "string"
                        },
                        "SourceAccount": {
                            "type": "string"
                        },
                        "SourceArn": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Action",
                        "FunctionName",
                        "Principal"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Lambda::Permission"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Lambda::Url": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AuthType": {
                            "type": "string"
                        },
                        "Cors": {
                            "$ref": "#/definitions/AWS::Lambda::Url.Cors"
                        },
                        "InvokeMode": {
                            "type": "string"
                        },
                        "Qualifier": {
                            "type": "string"
                        },
                        "TargetFunctionArn": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "AuthType",
                        "TargetFunctionArn"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Lambda::Url"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Lambda::Url.Cors": {
            "additionalProperties": false,
            "properties": {
                "AllowCredentials": {
                    "type": "boolean"
                },
                "AllowHeaders": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "AllowMethods": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "AllowOrigins": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "ExposeHeaders": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "MaxAge": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::Lambda::Version": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CodeSha256": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "FunctionName": {
                            "type": "string"
                        },
                        "ProvisionedConcurrencyConfig": {
                            "$ref": "#/definitions/AWS::Lambda::Version.ProvisionedConcurrencyConfiguration"
                        },
                        "RuntimePolicy": {
                            "$ref": "#/definitions/AWS::Lambda::Version.RuntimePolicy"
                        }
                    },
                    "required": [
                        "FunctionName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Lambda::Version"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Lambda::Version.ProvisionedConcurrencyConfiguration": {
            "additionalProperties": false,
            "properties": {
                "ProvisionedConcurrentExecutions": {
                    "type": "number"
                }
            },
            "required": [
                "ProvisionedConcurrentExecutions"
            ],
            "type": "object"
        },
        "AWS::Lambda::Version.RuntimePolicy": {
            "additionalProperties": false,
            "properties": {
                "RuntimeVersionArn": {
                    "type": "string"
                },
                "UpdateRuntimeOn": {
                    "type": "string"
                }
            },
            "required": [
                "UpdateRuntimeOn"
            ],
            "type": "object"
        },
        "AWS::RDS::CustomDBEngineVersion": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DatabaseInstallationFilesS3BucketName": {
                            "type": "string"
                        },
                        "DatabaseInstallationFilesS3Prefix": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "Engine": {
                            "type": "string"
                        },
                        "EngineVersion": {
                            "type": "string"
                        },
                        "ImageId": {
                            "type": "string"
                        },
                        "KMSKeyId": {
                            "type": "string"
                        },
                        "Manifest": {
                            "type": "string"
                        },
                        "SourceCustomDbEngineVersionIdentifier": {
                            "type": "string"
                        },
                        "Status": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "UseAwsProvidedLatestImage": {
                            "type": "boolean"
                        }
                    },
                    "required": [
                        "Engine",
                        "EngineVersion"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::RDS::CustomDBEngineVersion"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::RDS::DBCluster": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AllocatedStorage": {
                            "type": "number"
                        },
                        "AssociatedRoles": {
                            "items": {
                                "$ref": "#/definitions/AWS::RDS::DBCluster.DBClusterRole"
                            },
                            "type": "array"
                        },
                        "AutoMinorVersionUpgrade": {
                            "type": "boolean"
                        },
                        "AvailabilityZones": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "BacktrackWindow": {
                            "type": "number"
                        },
                        "BackupRetentionPeriod": {
                            "type": "number"
                        },
                        "ClusterScalabilityType": {
                            "type": "string"
                        },
                        "CopyTagsToSnapshot": {
                            "type": "boolean"
                        },
                        "DBClusterIdentifier": {
                            "type": "string"
                        },
                        "DBClusterInstanceClass": {
                            "type": "string"
                        },
                        "DBClusterParameterGroupName": {
                            "type": "string"
                        },
                        "DBInstanceParameterGroupName": {
                            "type": "string"
                        },
                        "DBSubnetGroupName": {
                            "type": "string"
                        },
                        "DBSystemId": {
                            "type": "string"
                        },
                        "DatabaseInsightsMode": {
                            "type": "string"
                        },
                        "DatabaseName": {
                            "type": "string"
                        },
                        "DeletionProtection": {
                            "type": "boolean"
                        },
                        "Domain": {
                            "type": "string"
                        },
                        "DomainIAMRoleName": {
                            "type": "string"
                        },
                        "EnableCloudwatchLogsExports": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "EnableGlobalWriteForwarding": {
                            "type": "boolean"
                        },
                        "EnableHttpEndpoint": {
                            "type": "boolean"
                        },
                        "EnableIAMDatabaseAuthentication": {
                            "type": "boolean"
                        },
                        "EnableLocalWriteForwarding": {
                            "type": "boolean"
                        },
                        "Engine": {
                            "type": "string"
                        },
                        "EngineLifecycleSupport": {
                            "type": "string"
                        },
                        "EngineMode": {
                            "type": "string"
                        },
                        "EngineVersion": {
                            "type": "string"
                        },
                        "GlobalClusterIdentifier": {
                            "type": "string"
                        },
                        "Iops": {
                            "type": "number"
                        },
                        "KmsKeyId": {
                            "type": "string"
                        },
                        "ManageMasterUserPassword": {
                            "type": "boolean"
                        },
                        "MasterUserPassword": {
                            "type": "string"
                        },
                        "MasterUserSecret": {
                            "$ref": "#/definitions/AWS::RDS::DBCluster.MasterUserSecret"
                        },
                        "MasterUsername": {
                            "type": "string"
                        },
                        "MonitoringInterval": {
                            "type": "number"
                        },
                        "MonitoringRoleArn": {
                            "type": "string"
                        },
                        "NetworkType": {
                            "type": "string"
                        },
                        "PerformanceInsightsEnabled": {
                            "type": "boolean"
                        },
                        "PerformanceInsightsKmsKeyId": {
                            "type": "string"
                        },
                        "PerformanceInsightsRetentionPeriod": {
                            "type": "number"
                        },
                        "Port": {
                            "type": "number"
                        },
                        "PreferredBackupWindow": {
                            "type": "string"
                        },
                        "PreferredMaintenanceWindow": {
                            "type": "string"
                        },
                        "PubliclyAccessible": {
                            "type": "boolean"
                        },
                        "ReplicationSourceIdentifier": {
                            "type": "string"
                        },
                        "RestoreToTime": {
                            "type": "string"
                        },
                        "RestoreType": {
                            "type": "string"
                        },
                        "ScalingConfiguration": {
                            "$ref": "#/definitions/AWS::RDS::DBCluster.ScalingConfiguration"
                        },
                        "ServerlessV2ScalingConfiguration": {
                            "$ref": "#/definitions/AWS::RDS::DBCluster.ServerlessV2ScalingConfiguration"
                        },
                        "SnapshotIdentifier": {
                            "type": "string"
                        },
                        "SourceDBClusterIdentifier": {
                            "type": "string"
                        },
                        "SourceRegion": {
                            "type": "string"
                        },
                        "StorageEncrypted": {
                            "type": "boolean"
                        },
                        "StorageType": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "UseLatestRestorableTime": {
                            "type": "boolean"
                        },
                        "VpcSecurityGroupIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::RDS::DBCluster"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::RDS::DBCluster.DBClusterRole": {
            "additionalProperties": false,
            "properties": {
                "FeatureName": {
                    "type": "string"
                },
                "RoleArn": {
                    "type": "string"
                }
            },
            "required": [
                "RoleArn"
            ],
            "type": "object"
        },
        "AWS::RDS::DBCluster.Endpoint": {
            "additionalProperties": false,
            "properties": {
                "Address": {
                    "type": "string"
                },
                "Port": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::RDS::DBCluster.MasterUserSecret": {
            "additionalProperties": false,
            "properties": {
                "KmsKeyId": {
                    "type": "string"
                },
                "SecretArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::RDS::DBCluster.ReadEndpoint": {
            "additionalProperties": false,
            "properties": {
                "Address": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::RDS::DBCluster.ScalingConfiguration": {
            "additionalProperties": false,
            "properties": {
                "AutoPause": {
                    "type": "boolean"
                },
                "MaxCapacity": {
                    "type": "number"
                },
                "MinCapacity": {
                    "type": "number"
                },
                "SecondsBeforeTimeout": {
                    "type": "number"
                },
                "SecondsUntilAutoPause": {
                    "type": "number"
                },
                "TimeoutAction": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::RDS::DBCluster.ServerlessV2ScalingConfiguration": {
            "additionalProperties": false,
            "properties": {
                "MaxCapacity": {
                    "type": "number"
                },
                "MinCapacity": {
                    "type": "number"
                },
                "SecondsUntilAutoPause": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::RDS::DBClusterParameterGroup": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DBClusterParameterGroupName": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "Family": {
                            "type": "string"
                        },
                        "Parameters": {
                            "type": "object"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "Description",
                        "Family",
                        "Parameters"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::RDS::DBClusterParameterGroup"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::RDS::DBInstance": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AllocatedStorage": {
                            "type": "string"
                        },
                        "AllowMajorVersionUpgrade": {
                            "type": "boolean"
                        },
                        "ApplyImmediately": {
                            "type": "boolean"
                        },
                        "AssociatedRoles": {
                            "items": {
                                "$ref": "#/definitions/AWS::RDS::DBInstance.DBInstanceRole"
                            },
                            "type": "array"
                        },
                        "AutoMinorVersionUpgrade": {
                            "type": "boolean"
                        },
                        "AutomaticBackupReplicationKmsKeyId": {
                            "type": "string"
                        },
                        "AutomaticBackupReplicationRegion": {
                            "type": "string"
                        },
                        "AvailabilityZone": {
                            "type": "string"
                        },
                        "BackupRetentionPeriod": {
                            "type": "number"
                        },
                        "CACertificateIdentifier": {
                            "type": "string"
                        },
                        "CertificateDetails": {
                            "$ref": "#/definitions/AWS::RDS::DBInstance.CertificateDetails"
                        },
                        "CertificateRotationRestart": {
                            "type": "boolean"
                        },
                        "CharacterSetName": {
                            "type": "string"
                        },
                        "CopyTagsToSnapshot": {
                            "type": "boolean"
                        },
                        "CustomIAMInstanceProfile": {
                            "type": "string"
                        },
                        "DBClusterIdentifier": {
                            "type": "string"
                        },
                        "DBClusterSnapshotIdentifier": {
                            "type": "string"
                        },
                        "DBInstanceClass": {
                            "type": "string"
                        },
                        "DBInstanceIdentifier": {
                            "type": "string"
                        },
                        "DBName": {
                            "type": "string"
                        },
                        "DBParameterGroupName": {
                            "type": "string"
                        },
                        "DBSecurityGroups": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "DBSnapshotIdentifier": {
                            "type": "string"
                        },
                        "DBSubnetGroupName": {
                            "type": "string"
                        },
                        "DBSystemId": {
                            "type": "string"
                        },
                        "DedicatedLogVolume": {
                            "type": "boolean"
                        },
                        "DeleteAutomatedBackups": {
                            "type": "boolean"
                        },
                        "DeletionProtection": {
                            "type": "boolean"
                        },
                        "Domain": {
                            "type": "string"
                        },
                        "DomainAuthSecretArn": {
                            "type": "string"
                        },
                        "DomainDnsIps": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "DomainFqdn": {
                            "type": "string"
                        },
                        "DomainIAMRoleName": {
                            "type": "string"
                        },
                        "DomainOu": {
                            "type": "string"
                        },
                        "EnableCloudwatchLogsExports": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "EnableIAMDatabaseAuthentication": {
                            "type": "boolean"
                        },
                        "EnablePerformanceInsights": {
                            "type": "boolean"
                        },
                        "Endpoint": {
                            "$ref": "#/definitions/AWS::RDS::DBInstance.Endpoint"
                        },
                        "Engine": {
                            "type": "string"
                        },
                        "EngineLifecycleSupport": {
                            "type": "string"
                        },
                        "EngineVersion": {
                            "type": "string"
                        },
                        "Iops": {
                            "type": "number"
                        },
                        "KmsKeyId": {
                            "type": "string"
                        },
                        "LicenseModel": {
                            "type": "string"
                        },
                        "ManageMasterUserPassword": {
                            "type": "boolean"
                        },
                        "MasterUserPassword": {
                            "type": "string"
                        },
                        "MasterUserSecret": {
                            "$ref": "#/definitions/AWS::RDS::DBInstance.MasterUserSecret"
                        },
                        "MasterUsername": {
                            "type": "string"
                        },
                        "MaxAllocatedStorage": {
                            "type": "number"
                        },
                        "MonitoringInterval": {
                            "type": "number"
                        },
                        "MonitoringRoleArn": {
                            "type": "string"
                        },
                        "MultiAZ": {
                            "type": "boolean"
                        },
                        "NcharCharacterSetName": {
                            "type": "string"
                        },
                        "NetworkType": {
                            "type": "string"
                        },
                        "OptionGroupName": {
                            "type": "string"
                        },
                        "PerformanceInsightsKMSKeyId": {
                            "type": "string"
                        },
                        "PerformanceInsightsRetentionPeriod": {
                            "type": "number"
                        },
                        "Port": {
                            "type": "string"
                        },
                        "PreferredBackupWindow": {
                            "type": "string"
                        },
                        "PreferredMaintenanceWindow": {
                            "type": "string"
                        },
                        "ProcessorFeatures": {
                            "items": {
                                "$ref": "#/definitions/AWS::RDS::DBInstance.ProcessorFeature"
                            },
                            "type": "array"
                        },
                        "PromotionTier": {
                            "type": "number"
                        },
                        "PubliclyAccessible": {
                            "type": "boolean"
                        },
                        "ReplicaMode": {
                            "type": "string"
                        },
                        "RestoreTime": {
                            "type": "string"
                        },
                        "SourceDBClusterIdentifier": {
                            "type": "string"
                        },
                        "SourceDBInstanceAutomatedBackupsArn": {
                            "type": "string"
                        },
                        "SourceDBInstanceIdentifier": {
                            "type": "string"
                        },
                        "SourceDbiResourceId": {
                            "type": "string"
                        },
                        "SourceRegion": {
                            "type": "string"
                        },
                        "StorageEncrypted": {
                            "type": "boolean"
                        },
                        "StorageThroughput": {
                            "type": "number"
                        },
                        "StorageType": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "Timezone": {
                            "type": "string"
                        },
                        "UseDefaultProcessorFeatures": {
                            "type": "boolean"
                        },
                        "UseLatestRestorableTime": {
                            "type": "boolean"
                        },
                        "VPCSecurityGroups": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::RDS::DBInstance"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::RDS::DBInstance.CertificateDetails": {
            "additionalProperties": false,
            "properties": {
                "CAIdentifier": {
                    "type": "string"
                },
                "ValidTill": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::RDS::DBInstance.DBInstanceRole": {
            "additionalProperties": false,
            "properties": {
                "FeatureName": {
                    "type": "string"
                },
                "RoleArn": {
                    "type": "string"
                }
            },
            "required": [
                "FeatureName",
                "RoleArn"
            ],
            "type": "object"
        },
        "AWS::RDS::DBInstance.Endpoint": {
            "additionalProperties": false,
            "properties": {
                "Address": {
                    "type": "string"
                },
                "HostedZoneId": {
                    "type": "string"
                },
                "Port": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::RDS::DBInstance.MasterUserSecret": {
            "additionalProperties": false,
            "properties": {
                "KmsKeyId": {
                    "type": "string"
                },
                "SecretArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::RDS::DBInstance.ProcessorFeature": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::RDS::DBParameterGroup": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DBParameterGroupName": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "Family": {
                            "type": "string"
                        },
                        "Parameters": {
                            "type": "object"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "Description",
                        "Family"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::RDS::DBParameterGroup"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::RDS::DBProxy": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Auth": {
                            "items": {
                                "$ref": "#/definitions/AWS::RDS::DBProxy.AuthFormat"
                            },
                            "type": "array"
                        },
                        "DBProxyName": {
                            "type": "string"
                        },
                        "DebugLogging": {
                            "type": "boolean"
                        },
                        "EngineFamily": {
                            "type": "string"
                        },
                        "IdleClientTimeout": {
                            "type": "number"
                        },
                        "RequireTLS": {
                            "type": "boolean"
                        },
                        "RoleArn": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/AWS::RDS::DBProxy.TagFormat"
                            },
                            "type": "array"
                        },
                        "VpcSecurityGroupIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "VpcSubnetIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "Auth",
                        "DBProxyName",
                        "EngineFamily",
                        "RoleArn",
                        "VpcSubnetIds"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::RDS::DBProxy"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::RDS::DBProxy.AuthFormat": {
            "additionalProperties": false,
            "properties": {
                "AuthScheme": {
                    "type": "string"
                },
                "ClientPasswordAuthType": {
                    "type": "string"
                },
                "Description": {
                    "type": "string"
                },
                "IAMAuth": {
                    "type": "string"
                },
                "SecretArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::RDS::DBProxy.TagFormat": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::RDS::DBProxyEndpoint": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DBProxyEndpointName": {
                            "type": "string"
                        },
                        "DBProxyName": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/AWS::RDS::DBProxyEndpoint.TagFormat"
                            },
                            "type": "array"
                        },
                        "TargetRole": {
                            "type": "string"
                        },
                        "VpcSecurityGroupIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "VpcSubnetIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "DBProxyEndpointName",
                        "DBProxyName",
                        "VpcSubnetIds"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::RDS::DBProxyEndpoint"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::RDS::DBProxyEndpoint.TagFormat": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::RDS::DBProxyTargetGroup": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ConnectionPoolConfigurationInfo": {
                            "$ref": "#/definitions/AWS::RDS::DBProxyTargetGroup.ConnectionPoolConfigurationInfoFormat"
                        },
                        "DBClusterIdentifiers": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "DBInstanceIdentifiers": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "DBProxyName": {
                            "type": "string"
                        },
                        "TargetGroupName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "DBProxyName",
                        "TargetGroupName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::RDS::DBProxyTargetGroup"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::RDS::DBProxyTargetGroup.ConnectionPoolConfigurationInfoFormat": {
            "additionalProperties": false,
            "properties": {
                "ConnectionBorrowTimeout": {
                    "type": "number"
                },
                "InitQuery": {
                    "type": "string"
                },
                "MaxConnectionsPercent": {
                    "type": "number"
                },
                "MaxIdleConnectionsPercent": {
                    "type": "number"
                },
                "SessionPinningFilters": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::RDS::DBSecurityGroup": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DBSecurityGroupIngress": {
                            "items": {
                                "$ref": "#/definitions/AWS::RDS::DBSecurityGroup.Ingress"
                            },
                            "type": "array"
                        },
                        "EC2VpcId": {
                            "type": "string"
                        },
                        "GroupDescription": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "DBSecurityGroupIngress",
                        "GroupDescription"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::RDS::DBSecurityGroup"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::RDS::DBSecurityGroup.Ingress": {
            "additionalProperties": false,
            "properties": {
                "CIDRIP": {
                    "type": "string"
                },
                "EC2SecurityGroupId": {
                    "type": "string"
                },
                "EC2SecurityGroupName": {
                    "type": "string"
                },
                "EC2SecurityGroupOwnerId": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::RDS::DBSecurityGroupIngress": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CIDRIP": {
                            "type": "string"
                        },
                        "DBSecurityGroupName": {
                            "type": "string"
                        },
                        "EC2SecurityGroupId": {
                            "type": "string"
                        },
                        "EC2SecurityGroupName": {
                            "type": "string"
                        },
                        "EC2SecurityGroupOwnerId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "DBSecurityGroupName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::RDS::DBSecurityGroupIngress"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::RDS::DBShardGroup": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ComputeRedundancy": {
                            "type": "number"
                        },
                        "DBClusterIdentifier": {
                            "type": "string"
                        },
                        "DBShardGroupIdentifier": {
                            "type": "string"
                        },
                        "MaxACU": {
                            "type": "number"
                        },
                        "MinACU": {
                            "type": "number"
                        },
                        "PubliclyAccessible": {
                            "type": "boolean"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "DBClusterIdentifier",
                        "MaxACU"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::RDS::DBShardGroup"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::RDS::DBSubnetGroup": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DBSubnetGroupDescription": {
                            "type": "string"
                        },
                        "DBSubnetGroupName": {
                            "type": "string"
                        },
                        "SubnetIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "DBSubnetGroupDescription",
                        "SubnetIds"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::RDS::DBSubnetGroup"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::RDS::EventSubscription": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Enabled": {
                            "type": "boolean"
                        },
                        "EventCategories": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "SnsTopicArn": {
                            "type": "string"
                        },
                        "SourceIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "SourceType": {
                            "type": "string"
                        },
                        "SubscriptionName": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "SnsTopicArn"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::RDS::EventSubscription"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::RDS::GlobalCluster": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DeletionProtection": {
                            "type": "boolean"
                        },
                        "Engine": {
                            "type": "string"
                        },
                        "EngineLifecycleSupport": {
                            "type": "string"
                        },
                        "EngineVersion": {
                            "type": "string"
                        },
                        "GlobalClusterIdentifier": {
                            "type": "string"
                        },
                        "GlobalEndpoint": {
                            "$ref": "#/definitions/AWS::RDS::GlobalCluster.GlobalEndpoint"
                        },
                        "SourceDBClusterIdentifier": {
                            "type": "string"
                        },
                        "StorageEncrypted": {
                            "type": "boolean"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::RDS::GlobalCluster"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::RDS::GlobalCluster.GlobalEndpoint": {
            "additionalProperties": false,
            "properties": {
                "Address": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::RDS::Integration": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AdditionalEncryptionContext": {
                            "additionalProperties": true,
                            "patternProperties": {
                                "^[a-zA-Z0-9]+$": {
                                    "type": "string"
                                }
                            },
                            "type": "object"
                        },
                        "DataFilter": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "IntegrationName": {
                            "type": "string"
                        },
                        "KMSKeyId": {
                            "type": "string"
                        },
                        "SourceArn": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "TargetArn": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "SourceArn",
                        "TargetArn"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::RDS::Integration"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::RDS::OptionGroup": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "EngineName": {
                            "type": "string"
                        },
                        "MajorEngineVersion": {
                            "type": "string"
                        },
                        "OptionConfigurations": {
                            "items": {
                                "$ref": "#/definitions/AWS::RDS::OptionGroup.OptionConfiguration"
                            },
                            "type": "array"
                        },
                        "OptionGroupDescription": {
                            "type": "string"
                        },
                        "OptionGroupName": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "EngineName",
                        "MajorEngineVersion",
                        "OptionGroupDescription"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::RDS::OptionGroup"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::RDS::OptionGroup.OptionConfiguration": {
            "additionalProperties": false,
            "properties": {
                "DBSecurityGroupMemberships": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "OptionName": {
                    "type": "string"
                },
                "OptionSettings": {
                    "items": {
                        "$ref": "#/definitions/AWS::RDS::OptionGroup.OptionSetting"
                    },
                    "type": "array"
                },
                "OptionVersion": {
                    "type": "string"
                },
                "Port": {
                    "type": "number"
                },
                "VpcSecurityGroupMemberships": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "OptionName"
            ],
            "type": "object"
        },
        "AWS::RDS::OptionGroup.OptionSetting": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::RolesAnywhere::CRL": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CrlData": {
                            "type": "string"
                        },
                        "Enabled": {
                            "type": "boolean"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "TrustAnchorArn": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "CrlData",
                        "Name"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::RolesAnywhere::CRL"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::RolesAnywhere::Profile": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AcceptRoleSessionName": {
                            "type": "boolean"
                        },
                        "AttributeMappings": {
                            "items": {
                                "$ref": "#/definitions/AWS::RolesAnywhere::Profile.AttributeMapping"
                            },
                            "type": "array"
                        },
                        "DurationSeconds": {
                            "type": "number"
                        },
                        "Enabled": {
                            "type": "boolean"
                        },
                        "ManagedPolicyArns": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "RequireInstanceProperties": {
                            "type": "boolean"
                        },
                        "RoleArns": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "SessionPolicy": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "Name",
                        "RoleArns"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::RolesAnywhere::Profile"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::RolesAnywhere::Profile.AttributeMapping": {
            "additionalProperties": false,
            "properties": {
                "CertificateField": {
                    "type": "string"
                },
                "MappingRules": {
                    "items": {
                        "$ref": "#/definitions/AWS::RolesAnywhere::Profile.MappingRule"
                    },
                    "type": "array"
                }
            },
            "required": [
                "CertificateField",
                "MappingRules"
            ],
            "type": "object"
        },
        "AWS::RolesAnywhere::Profile.MappingRule": {
            "additionalProperties": false,
            "properties": {
                "Specifier": {
                    "type": "string"
                }
            },
            "required": [
                "Specifier"
            ],
            "type": "object"
        },
        "AWS::RolesAnywhere::TrustAnchor": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Enabled": {
                            "type": "boolean"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "NotificationSettings": {
                            "items": {
                                "$ref": "#/definitions/AWS::RolesAnywhere::TrustAnchor.NotificationSetting"
                            },
                            "type": "array"
                        },
                        "Source": {
                            "$ref": "#/definitions/AWS::RolesAnywhere::TrustAnchor.Source"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "Name",
                        "Source"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::RolesAnywhere::TrustAnchor"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::RolesAnywhere::TrustAnchor.NotificationSetting": {
            "additionalProperties": false,
            "properties": {
                "Channel": {
                    "type": "string"
                },
                "Enabled": {
                    "type": "boolean"
                },
                "Event": {
                    "type": "string"
                },
                "Threshold": {
                    "type": "number"
                }
            },
            "required": [
                "Enabled",
                "Event"
            ],
            "type": "object"
        },
        "AWS::RolesAnywhere::TrustAnchor.Source": {
            "additionalProperties": false,
            "properties": {
                "SourceData": {
                    "$ref": "#/definitions/AWS::RolesAnywhere::TrustAnchor.SourceData"
                },
                "SourceType": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::RolesAnywhere::TrustAnchor.SourceData": {
            "additionalProperties": false,
            "properties": {
                "AcmPcaArn": {
                    "type": "string"
                },
                "X509CertificateData": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Route53::CidrCollection": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Locations": {
                            "items": {
                                "$ref": "#/definitions/AWS::Route53::CidrCollection.Location"
                            },
                            "type": "array"
                        },
                        "Name": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Name"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Route53::CidrCollection"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Route53::CidrCollection.Location": {
            "additionalProperties": false,
            "properties": {
                "CidrList": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "LocationName": {
                    "type": "string"
                }
            },
            "required": [
                "CidrList",
                "LocationName"
            ],
            "type": "object"
        },
        "AWS::Route53::DNSSEC": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "HostedZoneId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "HostedZoneId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Route53::DNSSEC"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Route53::HealthCheck": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "HealthCheckConfig": {
                            "$ref": "#/definitions/AWS::Route53::HealthCheck.HealthCheckConfig"
                        },
                        "HealthCheckTags": {
                            "items": {
                                "$ref": "#/definitions/AWS::Route53::HealthCheck.HealthCheckTag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "HealthCheckConfig"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Route53::HealthCheck"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Route53::HealthCheck.AlarmIdentifier": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                },
                "Region": {
                    "type": "string"
                }
            },
            "required": [
                "Name",
                "Region"
            ],
            "type": "object"
        },
        "AWS::Route53::HealthCheck.HealthCheckConfig": {
            "additionalProperties": false,
            "properties": {
                "AlarmIdentifier": {
                    "$ref": "#/definitions/AWS::Route53::HealthCheck.AlarmIdentifier"
                },
                "ChildHealthChecks": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "EnableSNI": {
                    "type": "boolean"
                },
                "FailureThreshold": {
                    "type": "number"
                },
                "FullyQualifiedDomainName": {
                    "type": "string"
                },
                "HealthThreshold": {
                    "type": "number"
                },
                "IPAddress": {
                    "type": "string"
                },
                "InsufficientDataHealthStatus": {
                    "type": "string"
                },
                "Inverted": {
                    "type": "boolean"
                },
                "MeasureLatency": {
                    "type": "boolean"
                },
                "Port": {
                    "type": "number"
                },
                "Regions": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "RequestInterval": {
                    "type": "number"
                },
                "ResourcePath": {
                    "type": "string"
                },
                "RoutingControlArn": {
                    "type": "string"
                },
                "SearchString": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::Route53::HealthCheck.HealthCheckTag": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Key",
                "Value"
            ],
            "type": "object"
        },
        "AWS::Route53::HostedZone": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "HostedZoneConfig": {
                            "$ref": "#/definitions/AWS::Route53::HostedZone.HostedZoneConfig"
                        },
                        "HostedZoneTags": {
                            "items": {
                                "$ref": "#/definitions/AWS::Route53::HostedZone.HostedZoneTag"
                            },
                            "type": "array"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "QueryLoggingConfig": {
                            "$ref": "#/definitions/AWS::Route53::HostedZone.QueryLoggingConfig"
                        },
                        "VPCs": {
                            "items": {
                                "$ref": "#/definitions/AWS::Route53::HostedZone.VPC"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Route53::HostedZone"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::Route53::HostedZone.HostedZoneConfig": {
            "additionalProperties": false,
            "properties": {
                "Comment": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Route53::HostedZone.HostedZoneTag": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Key",
                "Value"
            ],
            "type": "object"
        },
        "AWS::Route53::HostedZone.QueryLoggingConfig": {
            "additionalProperties": false,
            "properties": {
                "CloudWatchLogsLogGroupArn": {
                    "type": "string"
                }
            },
            "required": [
                "CloudWatchLogsLogGroupArn"
            ],
            "type": "object"
        },
        "AWS::Route53::HostedZone.VPC": {
            "additionalProperties": false,
            "properties": {
                "VPCId": {
                    "type": "string"
                },
                "VPCRegion": {
                    "type": "string"
                }
            },
            "required": [
                "VPCId",
                "VPCRegion"
            ],
            "type": "object"
        },
        "AWS::Route53::KeySigningKey": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "HostedZoneId": {
                            "type": "string"
                        },
                        "KeyManagementServiceArn": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "Status": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "HostedZoneId",
                        "KeyManagementServiceArn",
                        "Name",
                        "Status"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Route53::KeySigningKey"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Route53::RecordSet": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AliasTarget": {
                            "$ref": "#/definitions/AWS::Route53::RecordSet.AliasTarget"
                        },
                        "CidrRoutingConfig": {
                            "$ref": "#/definitions/AWS::Route53::RecordSet.CidrRoutingConfig"
                        },
                        "Comment": {
                            "type": "string"
                        },
                        "Failover": {
                            "type": "string"
                        },
                        "GeoLocation": {
                            "$ref": "#/definitions/AWS::Route53::RecordSet.GeoLocation"
                        },
                        "GeoProximityLocation": {
                            "$ref": "#/definitions/AWS::Route53::RecordSet.GeoProximityLocation"
                        },
                        "HealthCheckId": {
                            "type": "string"
                        },
                        "HostedZoneId": {
                            "type": "string"
                        },
                        "HostedZoneName": {
                            "type": "string"
                        },
                        "MultiValueAnswer": {
                            "type": "boolean"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "Region": {
                            "type": "string"
                        },
                        "ResourceRecords": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "SetIdentifier": {
                            "type": "string"
                        },
                        "TTL": {
                            "type": "string"
                        },
                        "Type": {
                            "type": "string"
                        },
                        "Weight": {
                            "type": "number"
                        }
                    },
                    "required": [
                        "Name",
                        "Type"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Route53::RecordSet"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Route53::RecordSet.AliasTarget": {
            "additionalProperties": false,
            "properties": {
                "DNSName": {
                    "type": "string"
                },
                "EvaluateTargetHealth": {
                    "type": "boolean"
                },
                "HostedZoneId": {
                    "type": "string"
                }
            },
            "required": [
                "DNSName",
                "HostedZoneId"
            ],
            "type": "object"
        },
        "AWS::Route53::RecordSet.CidrRoutingConfig": {
            "additionalProperties": false,
            "properties": {
                "CollectionId": {
                    "type": "string"
                },
                "LocationName": {
                    "type": "string"
                }
            },
            "required": [
                "CollectionId",
                "LocationName"
            ],
            "type": "object"
        },
        "AWS::Route53::RecordSet.Coordinates": {
            "additionalProperties": false,
            "properties": {
                "Latitude": {
                    "type": "string"
                },
                "Longitude": {
                    "type": "string"
                }
            },
            "required": [
                "Latitude",
                "Longitude"
            ],
            "type": "object"
        },
        "AWS::Route53::RecordSet.GeoLocation": {
            "additionalProperties": false,
            "properties": {
                "ContinentCode": {
                    "type": "string"
                },
                "CountryCode": {
                    "type": "string"
                },
                "SubdivisionCode": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Route53::RecordSet.GeoProximityLocation": {
            "additionalProperties": false,
            "properties": {
                "AWSRegion": {
                    "type": "string"
                },
                "Bias": {
                    "type": "number"
                },
                "Coordinates": {
                    "$ref": "#/definitions/AWS::Route53::RecordSet.Coordinates"
                },
                "LocalZoneGroup": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Route53::RecordSetGroup": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Comment": {
                            "type": "string"
                        },
                        "HostedZoneId": {
                            "type": "string"
                        },
                        "HostedZoneName": {
                            "type": "string"
                        },
                        "RecordSets": {
                            "items": {
                                "$ref": "#/definitions/AWS::Route53::RecordSetGroup.RecordSet"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Route53::RecordSetGroup"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::Route53::RecordSetGroup.AliasTarget": {
            "additionalProperties": false,
            "properties": {
                "DNSName": {
                    "type": "string"
                },
                "EvaluateTargetHealth": {
                    "type": "boolean"
                },
                "HostedZoneId": {
                    "type": "string"
                }
            },
            "required": [
                "DNSName",
                "HostedZoneId"
            ],
            "type": "object"
        },
        "AWS::Route53::RecordSetGroup.CidrRoutingConfig": {
            "additionalProperties": false,
            "properties": {
                "CollectionId": {
                    "type": "string"
                },
                "LocationName": {
                    "type": "string"
                }
            },
            "required": [
                "CollectionId",
                "LocationName"
            ],
            "type": "object"
        },
        "AWS::Route53::RecordSetGroup.Coordinates": {
            "additionalProperties": false,
            "properties": {
                "Latitude": {
                    "type": "string"
                },
                "Longitude": {
                    "type": "string"
                }
            },
            "required": [
                "Latitude",
                "Longitude"
            ],
            "type": "object"
        },
        "AWS::Route53::RecordSetGroup.GeoLocation": {
            "additionalProperties": false,
            "properties": {
                "ContinentCode": {
                    "type": "string"
                },
                "CountryCode": {
                    "type": "string"
                },
                "SubdivisionCode": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Route53::RecordSetGroup.GeoProximityLocation": {
            "additionalProperties": false,
            "properties": {
                "AWSRegion": {
                    "type": "string"
                },
                "Bias": {
                    "type": "number"
                },
                "Coordinates": {
                    "$ref": "#/definitions/AWS::Route53::RecordSetGroup.Coordinates"
                },
                "LocalZoneGroup": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Route53::RecordSetGroup.RecordSet": {
            "additionalProperties": false,
            "properties": {
                "AliasTarget": {
                    "$ref": "#/definitions/AWS::Route53::RecordSetGroup.AliasTarget"
                },
                "CidrRoutingConfig": {
                    "$ref": "#/definitions/AWS::Route53::RecordSetGroup.CidrRoutingConfig"
                },
                "Failover": {
                    "type": "string"
                },
                "GeoLocation": {
                    "$ref": "#/definitions/AWS::Route53::RecordSetGroup.GeoLocation"
                },
                "GeoProximityLocation": {
                    "$ref": "#/definitions/AWS::Route53::RecordSetGroup.GeoProximityLocation"
                },
                "HealthCheckId": {
                    "type": "string"
                },
                "HostedZoneId": {
                    "type": "string"
                },
                "HostedZoneName": {
                    "type": "string"
                },
                "MultiValueAnswer": {
                    "type": "boolean"
                },
                "Name": {
                    "type": "string"
                },
                "Region": {
                    "type": "string"
                },
                "ResourceRecords": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "SetIdentifier": {
                    "type": "string"
                },
                "TTL": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                },
                "Weight": {
                    "type": "number"
                }
            },
            "required": [
                "Name",
                "Type"
            ],
            "type": "object"
        },
        "AWS::S3::AccessGrant": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AccessGrantsLocationConfiguration": {
                            "$ref": "#/definitions/AWS::S3::AccessGrant.AccessGrantsLocationConfiguration"
                        },
                        "AccessGrantsLocationId": {
                            "type": "string"
                        },
                        "ApplicationArn": {
                            "type": "string"
                        },
                        "Grantee": {
                            "$ref": "#/definitions/AWS::S3::AccessGrant.Grantee"
                        },
                        "Permission": {
                            "type": "string"
                        },
                        "S3PrefixType": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "AccessGrantsLocationId",
                        "Grantee",
                        "Permission"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::S3::AccessGrant"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::S3::AccessGrant.AccessGrantsLocationConfiguration": {
            "additionalProperties": false,
            "properties": {
                "S3SubPrefix": {
                    "type": "string"
                }
            },
            "required": [
                "S3SubPrefix"
            ],
            "type": "object"
        },
        "AWS::S3::AccessGrant.Grantee": {
            "additionalProperties": false,
            "properties": {
                "GranteeIdentifier": {
                    "type": "string"
                },
                "GranteeType": {
                    "type": "string"
                }
            },
            "required": [
                "GranteeIdentifier",
                "GranteeType"
            ],
            "type": "object"
        },
        "AWS::S3::AccessGrantsInstance": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "IdentityCenterArn": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::S3::AccessGrantsInstance"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::S3::AccessGrantsLocation": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "IamRoleArn": {
                            "type": "string"
                        },
                        "LocationScope": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::S3::AccessGrantsLocation"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::S3::AccessPoint": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Bucket": {
                            "type": "string"
                        },
                        "BucketAccountId": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "Policy": {
                            "type": "object"
                        },
                        "PublicAccessBlockConfiguration": {
                            "$ref": "#/definitions/AWS::S3::AccessPoint.PublicAccessBlockConfiguration"
                        },
                        "VpcConfiguration": {
                            "$ref": "#/definitions/AWS::S3::AccessPoint.VpcConfiguration"
                        }
                    },
                    "required": [
                        "Bucket"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::S3::AccessPoint"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::S3::AccessPoint.PublicAccessBlockConfiguration": {
            "additionalProperties": false,
            "properties": {
                "BlockPublicAcls": {
                    "type": "boolean"
                },
                "BlockPublicPolicy": {
                    "type": "boolean"
                },
                "IgnorePublicAcls": {
                    "type": "boolean"
                },
                "RestrictPublicBuckets": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::S3::AccessPoint.VpcConfiguration": {
            "additionalProperties": false,
            "properties": {
                "VpcId": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::S3::Bucket": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AccelerateConfiguration": {
                            "$ref": "#/definitions/AWS::S3::Bucket.AccelerateConfiguration"
                        },
                        "AccessControl": {
                            "type": "string"
                        },
                        "AnalyticsConfigurations": {
                            "items": {
                                "$ref": "#/definitions/AWS::S3::Bucket.AnalyticsConfiguration"
                            },
                            "type": "array"
                        },
                        "BucketEncryption": {
                            "$ref": "#/definitions/AWS::S3::Bucket.BucketEncryption"
                        },
                        "BucketName": {
                            "type": "string"
                        },
                        "CorsConfiguration": {
                            "$ref": "#/definitions/AWS::S3::Bucket.CorsConfiguration"
                        },
                        "IntelligentTieringConfigurations": {
                            "items": {
                                "$ref": "#/definitions/AWS::S3::Bucket.IntelligentTieringConfiguration"
                            },
                            "type": "array"
                        },
                        "InventoryConfigurations": {
                            "items": {
                                "$ref": "#/definitions/AWS::S3::Bucket.InventoryConfiguration"
                            },
                            "type": "array"
                        },
                        "LifecycleConfiguration": {
                            "$ref": "#/definitions/AWS::S3::Bucket.LifecycleConfiguration"
                        },
                        "LoggingConfiguration": {
                            "$ref": "#/definitions/AWS::S3::Bucket.LoggingConfiguration"
                        },
                        "MetadataTableConfiguration": {
                            "$ref": "#/definitions/AWS::S3::Bucket.MetadataTableConfiguration"
                        },
                        "MetricsConfigurations": {
                            "items": {
                                "$ref": "#/definitions/AWS::S3::Bucket.MetricsConfiguration"
                            },
                            "type": "array"
                        },
                        "NotificationConfiguration": {
                            "$ref": "#/definitions/AWS::S3::Bucket.NotificationConfiguration"
                        },
                        "ObjectLockConfiguration": {
                            "$ref": "#/definitions/AWS::S3::Bucket.ObjectLockConfiguration"
                        },
                        "ObjectLockEnabled": {
                            "type": "boolean"
                        },
                        "OwnershipControls": {
                            "$ref": "#/definitions/AWS::S3::Bucket.OwnershipControls"
                        },
                        "PublicAccessBlockConfiguration": {
                            "$ref": "#/definitions/AWS::S3::Bucket.PublicAccessBlockConfiguration"
                        },
                        "ReplicationConfiguration": {
                            "$ref": "#/definitions/AWS::S3::Bucket.ReplicationConfiguration"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "VersioningConfiguration": {
                            "$ref": "#/definitions/AWS::S3::Bucket.VersioningConfiguration"
                        },
                        "WebsiteConfiguration": {
                            "$ref": "#/definitions/AWS::S3::Bucket.WebsiteConfiguration"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::S3::Bucket"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.AbortIncompleteMultipartUpload": {
            "additionalProperties": false,
            "properties": {
                "DaysAfterInitiation": {
                    "type": "number"
                }
            },
            "required": [
                "DaysAfterInitiation"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.AccelerateConfiguration": {
            "additionalProperties": false,
            "properties": {
                "AccelerationStatus": {
                    "type": "string"
                }
            },
            "required": [
                "AccelerationStatus"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.AccessControlTranslation": {
            "additionalProperties": false,
            "properties": {
                "Owner": {
                    "type": "string"
                }
            },
            "required": [
                "Owner"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.AnalyticsConfiguration": {
            "additionalProperties": false,
            "properties": {
                "Id": {
                    "type": "string"
                },
                "Prefix": {
                    "type": "string"
                },
                "StorageClassAnalysis": {
                    "$ref": "#/definitions/AWS::S3::Bucket.StorageClassAnalysis"
                },
                "TagFilters": {
                    "items": {
                        "$ref": "#/definitions/AWS::S3::Bucket.TagFilter"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Id",
                "StorageClassAnalysis"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.BucketEncryption": {
            "additionalProperties": false,
            "properties": {
                "ServerSideEncryptionConfiguration": {
                    "items": {
                        "$ref": "#/definitions/AWS::S3::Bucket.ServerSideEncryptionRule"
                    },
                    "type": "array"
                }
            },
            "required": [
                "ServerSideEncryptionConfiguration"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.CorsConfiguration": {
            "additionalProperties": false,
            "properties": {
                "CorsRules": {
                    "items": {
                        "$ref": "#/definitions/AWS::S3::Bucket.CorsRule"
                    },
                    "type": "array"
                }
            },
            "required": [
                "CorsRules"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.CorsRule": {
            "additionalProperties": false,
            "properties": {
                "AllowedHeaders": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "AllowedMethods": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "AllowedOrigins": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "ExposedHeaders": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Id": {
                    "type": "string"
                },
                "MaxAge": {
                    "type": "number"
                }
            },
            "required": [
                "AllowedMethods",
                "AllowedOrigins"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.DataExport": {
            "additionalProperties": false,
            "properties": {
                "Destination": {
                    "$ref": "#/definitions/AWS::S3::Bucket.Destination"
                },
                "OutputSchemaVersion": {
                    "type": "string"
                }
            },
            "required": [
                "Destination",
                "OutputSchemaVersion"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.DefaultRetention": {
            "additionalProperties": false,
            "properties": {
                "Days": {
                    "type": "number"
                },
                "Mode": {
                    "type": "string"
                },
                "Years": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::S3::Bucket.DeleteMarkerReplication": {
            "additionalProperties": false,
            "properties": {
                "Status": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::S3::Bucket.Destination": {
            "additionalProperties": false,
            "properties": {
                "BucketAccountId": {
                    "type": "string"
                },
                "BucketArn": {
                    "type": "string"
                },
                "Format": {
                    "type": "string"
                },
                "Prefix": {
                    "type": "string"
                }
            },
            "required": [
                "BucketArn",
                "Format"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.EncryptionConfiguration": {
            "additionalProperties": false,
            "properties": {
                "ReplicaKmsKeyID": {
                    "type": "string"
                }
            },
            "required": [
                "ReplicaKmsKeyID"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.EventBridgeConfiguration": {
            "additionalProperties": false,
            "properties": {
                "EventBridgeEnabled": {
                    "type": "boolean"
                }
            },
            "required": [
                "EventBridgeEnabled"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.FilterRule": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Name",
                "Value"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.IntelligentTieringConfiguration": {
            "additionalProperties": false,
            "properties": {
                "Id": {
                    "type": "string"
                },
                "Prefix": {
                    "type": "string"
                },
                "Status": {
                    "type": "string"
                },
                "TagFilters": {
                    "items": {
                        "$ref": "#/definitions/AWS::S3::Bucket.TagFilter"
                    },
                    "type": "array"
                },
                "Tierings": {
                    "items": {
                        "$ref": "#/definitions/AWS::S3::Bucket.Tiering"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Id",
                "Status",
                "Tierings"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.InventoryConfiguration": {
            "additionalProperties": false,
            "properties": {
                "Destination": {
                    "$ref": "#/definitions/AWS::S3::Bucket.Destination"
                },
                "Enabled": {
                    "type": "boolean"
                },
                "Id": {
                    "type": "string"
                },
                "IncludedObjectVersions": {
                    "type": "string"
                },
                "OptionalFields": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Prefix": {
                    "type": "string"
                },
                "ScheduleFrequency": {
                    "type": "string"
                }
            },
            "required": [
                "Destination",
                "Enabled",
                "Id",
                "IncludedObjectVersions",
                "ScheduleFrequency"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.LambdaConfiguration": {
            "additionalProperties": false,
            "properties": {
                "Event": {
                    "type": "string"
                },
                "Filter": {
                    "$ref": "#/definitions/AWS::S3::Bucket.NotificationFilter"
                },
                "Function": {
                    "type": "string"
                }
            },
            "required": [
                "Event",
                "Function"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.LifecycleConfiguration": {
            "additionalProperties": false,
            "properties": {
                "Rules": {
                    "items": {
                        "$ref": "#/definitions/AWS::S3::Bucket.Rule"
                    },
                    "type": "array"
                },
                "TransitionDefaultMinimumObjectSize": {
                    "type": "string"
                }
            },
            "required": [
                "Rules"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.LoggingConfiguration": {
            "additionalProperties": false,
            "properties": {
                "DestinationBucketName": {
                    "type": "string"
                },
                "LogFilePrefix": {
                    "type": "string"
                },
                "TargetObjectKeyFormat": {
                    "$ref": "#/definitions/AWS::S3::Bucket.TargetObjectKeyFormat"
                }
            },
            "type": "object"
        },
        "AWS::S3::Bucket.MetadataTableConfiguration": {
            "additionalProperties": false,
            "properties": {
                "S3TablesDestination": {
                    "$ref": "#/definitions/AWS::S3::Bucket.S3TablesDestination"
                }
            },
            "required": [
                "S3TablesDestination"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.Metrics": {
            "additionalProperties": false,
            "properties": {
                "EventThreshold": {
                    "$ref": "#/definitions/AWS::S3::Bucket.ReplicationTimeValue"
                },
                "Status": {
                    "type": "string"
                }
            },
            "required": [
                "Status"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.MetricsConfiguration": {
            "additionalProperties": false,
            "properties": {
                "AccessPointArn": {
                    "type": "string"
                },
                "Id": {
                    "type": "string"
                },
                "Prefix": {
                    "type": "string"
                },
                "TagFilters": {
                    "items": {
                        "$ref": "#/definitions/AWS::S3::Bucket.TagFilter"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Id"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.NoncurrentVersionExpiration": {
            "additionalProperties": false,
            "properties": {
                "NewerNoncurrentVersions": {
                    "type": "number"
                },
                "NoncurrentDays": {
                    "type": "number"
                }
            },
            "required": [
                "NoncurrentDays"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.NoncurrentVersionTransition": {
            "additionalProperties": false,
            "properties": {
                "NewerNoncurrentVersions": {
                    "type": "number"
                },
                "StorageClass": {
                    "type": "string"
                },
                "TransitionInDays": {
                    "type": "number"
                }
            },
            "required": [
                "StorageClass",
                "TransitionInDays"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.NotificationConfiguration": {
            "additionalProperties": false,
            "properties": {
                "EventBridgeConfiguration": {
                    "$ref": "#/definitions/AWS::S3::Bucket.EventBridgeConfiguration"
                },
                "LambdaConfigurations": {
                    "items": {
                        "$ref": "#/definitions/AWS::S3::Bucket.LambdaConfiguration"
                    },
                    "type": "array"
                },
                "QueueConfigurations": {
                    "items": {
                        "$ref": "#/definitions/AWS::S3::Bucket.QueueConfiguration"
                    },
                    "type": "array"
                },
                "TopicConfigurations": {
                    "items": {
                        "$ref": "#/definitions/AWS::S3::Bucket.TopicConfiguration"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::S3::Bucket.NotificationFilter": {
            "additionalProperties": false,
            "properties": {
                "S3Key": {
                    "$ref": "#/definitions/AWS::S3::Bucket.S3KeyFilter"
                }
            },
            "required": [
                "S3Key"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.ObjectLockConfiguration": {
            "additionalProperties": false,
            "properties": {
                "ObjectLockEnabled": {
                    "type": "string"
                },
                "Rule": {
                    "$ref": "#/definitions/AWS::S3::Bucket.ObjectLockRule"
                }
            },
            "type": "object"
        },
        "AWS::S3::Bucket.ObjectLockRule": {
            "additionalProperties": false,
            "properties": {
                "DefaultRetention": {
                    "$ref": "#/definitions/AWS::S3::Bucket.DefaultRetention"
                }
            },
            "type": "object"
        },
        "AWS::S3::Bucket.OwnershipControls": {
            "additionalProperties": false,
            "properties": {
                "Rules": {
                    "items": {
                        "$ref": "#/definitions/AWS::S3::Bucket.OwnershipControlsRule"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Rules"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.OwnershipControlsRule": {
            "additionalProperties": false,
            "properties": {
                "ObjectOwnership": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::S3::Bucket.PartitionedPrefix": {
            "additionalProperties": false,
            "properties": {
                "PartitionDateSource": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::S3::Bucket.PublicAccessBlockConfiguration": {
            "additionalProperties": false,
            "properties": {
                "BlockPublicAcls": {
                    "type": "boolean"
                },
                "BlockPublicPolicy": {
                    "type": "boolean"
                },
                "IgnorePublicAcls": {
                    "type": "boolean"
                },
                "RestrictPublicBuckets": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::S3::Bucket.QueueConfiguration": {
            "additionalProperties": false,
            "properties": {
                "Event": {
                    "type": "string"
                },
                "Filter": {
                    "$ref": "#/definitions/AWS::S3::Bucket.NotificationFilter"
                },
                "Queue": {
                    "type": "string"
                }
            },
            "required": [
                "Event",
                "Queue"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.RedirectAllRequestsTo": {
            "additionalProperties": false,
            "properties": {
                "HostName": {
                    "type": "string"
                },
                "Protocol": {
                    "type": "string"
                }
            },
            "required": [
                "HostName"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.RedirectRule": {
            "additionalProperties": false,
            "properties": {
                "HostName": {
                    "type": "string"
                },
                "HttpRedirectCode": {
                    "type": "string"
                },
                "Protocol": {
                    "type": "string"
                },
                "ReplaceKeyPrefixWith": {
                    "type": "string"
                },
                "ReplaceKeyWith": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::S3::Bucket.ReplicaModifications": {
            "additionalProperties": false,
            "properties": {
                "Status": {
                    "type": "string"
                }
            },
            "required": [
                "Status"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.ReplicationConfiguration": {
            "additionalProperties": false,
            "properties": {
                "Role": {
                    "type": "string"
                },
                "Rules": {
                    "items": {
                        "$ref": "#/definitions/AWS::S3::Bucket.ReplicationRule"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Role",
                "Rules"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.ReplicationDestination": {
            "additionalProperties": false,
            "properties": {
                "AccessControlTranslation": {
                    "$ref": "#/definitions/AWS::S3::Bucket.AccessControlTranslation"
                },
                "Account": {
                    "type": "string"
                },
                "Bucket": {
                    "type": "string"
                },
                "EncryptionConfiguration": {
                    "$ref": "#/definitions/AWS::S3::Bucket.EncryptionConfiguration"
                },
                "Metrics": {
                    "$ref": "#/definitions/AWS::S3::Bucket.Metrics"
                },
                "ReplicationTime": {
                    "$ref": "#/definitions/AWS::S3::Bucket.ReplicationTime"
                },
                "StorageClass": {
                    "type": "string"
                }
            },
            "required": [
                "Bucket"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.ReplicationRule": {
            "additionalProperties": false,
            "properties": {
                "DeleteMarkerReplication": {
                    "$ref": "#/definitions/AWS::S3::Bucket.DeleteMarkerReplication"
                },
                "Destination": {
                    "$ref": "#/definitions/AWS::S3::Bucket.ReplicationDestination"
                },
                "Filter": {
                    "$ref": "#/definitions/AWS::S3::Bucket.ReplicationRuleFilter"
                },
                "Id": {
                    "type": "string"
                },
                "Prefix": {
                    "type": "string"
                },
                "Priority": {
                    "type": "number"
                },
                "SourceSelectionCriteria": {
                    "$ref": "#/definitions/AWS::S3::Bucket.SourceSelectionCriteria"
                },
                "Status": {
                    "type": "string"
                }
            },
            "required": [
                "Destination",
                "Status"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.ReplicationRuleAndOperator": {
            "additionalProperties": false,
            "properties": {
                "Prefix": {
                    "type": "string"
                },
                "TagFilters": {
                    "items": {
                        "$ref": "#/definitions/AWS::S3::Bucket.TagFilter"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::S3::Bucket.ReplicationRuleFilter": {
            "additionalProperties": false,
            "properties": {
                "And": {
                    "$ref": "#/definitions/AWS::S3::Bucket.ReplicationRuleAndOperator"
                },
                "Prefix": {
                    "type": "string"
                },
                "TagFilter": {
                    "$ref": "#/definitions/AWS::S3::Bucket.TagFilter"
                }
            },
            "type": "object"
        },
        "AWS::S3::Bucket.ReplicationTime": {
            "additionalProperties": false,
            "properties": {
                "Status": {
                    "type": "string"
                },
                "Time": {
                    "$ref": "#/definitions/AWS::S3::Bucket.ReplicationTimeValue"
                }
            },
            "required": [
                "Status",
                "Time"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.ReplicationTimeValue": {
            "additionalProperties": false,
            "properties": {
                "Minutes": {
                    "type": "number"
                }
            },
            "required": [
                "Minutes"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.RoutingRule": {
            "additionalProperties": false,
            "properties": {
                "RedirectRule": {
                    "$ref": "#/definitions/AWS::S3::Bucket.RedirectRule"
                },
                "RoutingRuleCondition": {
                    "$ref": "#/definitions/AWS::S3::Bucket.RoutingRuleCondition"
                }
            },
            "required": [
                "RedirectRule"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.RoutingRuleCondition": {
            "additionalProperties": false,
            "properties": {
                "HttpErrorCodeReturnedEquals": {
                    "type": "string"
                },
                "KeyPrefixEquals": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::S3::Bucket.Rule": {
            "additionalProperties": false,
            "properties": {
                "AbortIncompleteMultipartUpload": {
                    "$ref": "#/definitions/AWS::S3::Bucket.AbortIncompleteMultipartUpload"
                },
                "ExpirationDate": {
                    "type": "string"
                },
                "ExpirationInDays": {
                    "type": "number"
                },
                "ExpiredObjectDeleteMarker": {
                    "type": "boolean"
                },
                "Id": {
                    "type": "string"
                },
                "NoncurrentVersionExpiration": {
                    "$ref": "#/definitions/AWS::S3::Bucket.NoncurrentVersionExpiration"
                },
                "NoncurrentVersionExpirationInDays": {
                    "type": "number"
                },
                "NoncurrentVersionTransition": {
                    "$ref": "#/definitions/AWS::S3::Bucket.NoncurrentVersionTransition"
                },
                "NoncurrentVersionTransitions": {
                    "items": {
                        "$ref": "#/definitions/AWS::S3::Bucket.NoncurrentVersionTransition"
                    },
                    "type": "array"
                },
                "ObjectSizeGreaterThan": {
                    "type": "string"
                },
                "ObjectSizeLessThan": {
                    "type": "string"
                },
                "Prefix": {
                    "type": "string"
                },
                "Status": {
                    "type": "string"
                },
                "TagFilters": {
                    "items": {
                        "$ref": "#/definitions/AWS::S3::Bucket.TagFilter"
                    },
                    "type": "array"
                },
                "Transition": {
                    "$ref": "#/definitions/AWS::S3::Bucket.Transition"
                },
                "Transitions": {
                    "items": {
                        "$ref": "#/definitions/AWS::S3::Bucket.Transition"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Status"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.S3KeyFilter": {
            "additionalProperties": false,
            "properties": {
                "Rules": {
                    "items": {
                        "$ref": "#/definitions/AWS::S3::Bucket.FilterRule"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Rules"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.S3TablesDestination": {
            "additionalProperties": false,
            "properties": {
                "TableArn": {
                    "type": "string"
                },
                "TableBucketArn": {
                    "type": "string"
                },
                "TableName": {
                    "type": "string"
                },
                "TableNamespace": {
                    "type": "string"
                }
            },
            "required": [
                "TableBucketArn",
                "TableName"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.ServerSideEncryptionByDefault": {
            "additionalProperties": false,
            "properties": {
                "KMSMasterKeyID": {
                    "type": "string"
                },
                "SSEAlgorithm": {
                    "type": "string"
                }
            },
            "required": [
                "SSEAlgorithm"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.ServerSideEncryptionRule": {
            "additionalProperties": false,
            "properties": {
                "BucketKeyEnabled": {
                    "type": "boolean"
                },
                "ServerSideEncryptionByDefault": {
                    "$ref": "#/definitions/AWS::S3::Bucket.ServerSideEncryptionByDefault"
                }
            },
            "type": "object"
        },
        "AWS::S3::Bucket.SourceSelectionCriteria": {
            "additionalProperties": false,
            "properties": {
                "ReplicaModifications": {
                    "$ref": "#/definitions/AWS::S3::Bucket.ReplicaModifications"
                },
                "SseKmsEncryptedObjects": {
                    "$ref": "#/definitions/AWS::S3::Bucket.SseKmsEncryptedObjects"
                }
            },
            "type": "object"
        },
        "AWS::S3::Bucket.SseKmsEncryptedObjects": {
            "additionalProperties": false,
            "properties": {
                "Status": {
                    "type": "string"
                }
            },
            "required": [
                "Status"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.StorageClassAnalysis": {
            "additionalProperties": false,
            "properties": {
                "DataExport": {
                    "$ref": "#/definitions/AWS::S3::Bucket.DataExport"
                }
            },
            "type": "object"
        },
        "AWS::S3::Bucket.TagFilter": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Key",
                "Value"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.TargetObjectKeyFormat": {
            "additionalProperties": false,
            "properties": {
                "PartitionedPrefix": {
                    "$ref": "#/definitions/AWS::S3::Bucket.PartitionedPrefix"
                },
                "SimplePrefix": {
                    "type": "object"
                }
            },
            "type": "object"
        },
        "AWS::S3::Bucket.Tiering": {
            "additionalProperties": false,
            "properties": {
                "AccessTier": {
                    "type": "string"
                },
                "Days": {
                    "type": "number"
                }
            },
            "required": [
                "AccessTier",
                "Days"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.TopicConfiguration": {
            "additionalProperties": false,
            "properties": {
                "Event": {
                    "type": "string"
                },
                "Filter": {
                    "$ref": "#/definitions/AWS::S3::Bucket.NotificationFilter"
                },
                "Topic": {
                    "type": "string"
                }
            },
            "required": [
                "Event",
                "Topic"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.Transition": {
            "additionalProperties": false,
            "properties": {
                "StorageClass": {
                    "type": "string"
                },
                "TransitionDate": {
                    "type": "string"
                },
                "TransitionInDays": {
                    "type": "number"
                }
            },
            "required": [
                "StorageClass"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.VersioningConfiguration": {
            "additionalProperties": false,
            "properties": {
                "Status": {
                    "type": "string"
                }
            },
            "required": [
                "Status"
            ],
            "type": "object"
        },
        "AWS::S3::Bucket.WebsiteConfiguration": {
            "additionalProperties": false,
            "properties": {
                "ErrorDocument": {
                    "type": "string"
                },
                "IndexDocument": {
                    "type": "string"
                },
                "RedirectAllRequestsTo": {
                    "$ref": "#/definitions/AWS::S3::Bucket.RedirectAllRequestsTo"
                },
                "RoutingRules": {
                    "items": {
                        "$ref": "#/definitions/AWS::S3::Bucket.RoutingRule"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::S3::BucketPolicy": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Bucket": {
                            "type": "string"
                        },
                        "PolicyDocument": {
                            "type": "object"
                        }
                    },
                    "required": [
                        "Bucket",
                        "PolicyDocument"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::S3::BucketPolicy"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::S3::MultiRegionAccessPoint": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Name": {
                            "type": "string"
                        },
                        "PublicAccessBlockConfiguration": {
                            "$ref": "#/definitions/AWS::S3::MultiRegionAccessPoint.PublicAccessBlockConfiguration"
                        },
                        "Regions": {
                            "items": {
                                "$ref": "#/definitions/AWS::S3::MultiRegionAccessPoint.Region"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "Regions"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::S3::MultiRegionAccessPoint"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::S3::MultiRegionAccessPoint.PublicAccessBlockConfiguration": {
            "additionalProperties": false,
            "properties": {
                "BlockPublicAcls": {
                    "type": "boolean"
                },
                "BlockPublicPolicy": {
                    "type": "boolean"
                },
                "IgnorePublicAcls": {
                    "type": "boolean"
                },
                "RestrictPublicBuckets": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::S3::MultiRegionAccessPoint.Region": {
            "additionalProperties": false,
            "properties": {
                "Bucket": {
                    "type": "string"
                },
                "BucketAccountId": {
                    "type": "string"
                }
            },
            "required": [
                "Bucket"
            ],
            "type": "object"
        },
        "AWS::S3::MultiRegionAccessPointPolicy": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "MrapName": {
                            "type": "string"
                        },
                        "Policy": {
                            "type": "object"
                        }
                    },
                    "required": [
                        "MrapName",
                        "Policy"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::S3::MultiRegionAccessPointPolicy"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::S3::MultiRegionAccessPointPolicy.PolicyStatus": {
            "additionalProperties": false,
            "properties": {
                "IsPublic": {
                    "type": "string"
                }
            },
            "required": [
                "IsPublic"
            ],
            "type": "object"
        },
        "AWS::S3::StorageLens": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "StorageLensConfiguration": {
                            "$ref": "#/definitions/AWS::S3::StorageLens.StorageLensConfiguration"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "StorageLensConfiguration"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::S3::StorageLens"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::S3::StorageLens.AccountLevel": {
            "additionalProperties": false,
            "properties": {
                "ActivityMetrics": {
                    "$ref": "#/definitions/AWS::S3::StorageLens.ActivityMetrics"
                },
                "AdvancedCostOptimizationMetrics": {
                    "$ref": "#/definitions/AWS::S3::StorageLens.AdvancedCostOptimizationMetrics"
                },
                "AdvancedDataProtectionMetrics": {
                    "$ref": "#/definitions/AWS::S3::StorageLens.AdvancedDataProtectionMetrics"
                },
                "BucketLevel": {
                    "$ref": "#/definitions/AWS::S3::StorageLens.BucketLevel"
                },
                "DetailedStatusCodesMetrics": {
                    "$ref": "#/definitions/AWS::S3::StorageLens.DetailedStatusCodesMetrics"
                },
                "StorageLensGroupLevel": {
                    "$ref": "#/definitions/AWS::S3::StorageLens.StorageLensGroupLevel"
                }
            },
            "required": [
                "BucketLevel"
            ],
            "type": "object"
        },
        "AWS::S3::StorageLens.ActivityMetrics": {
            "additionalProperties": false,
            "properties": {
                "IsEnabled": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::S3::StorageLens.AdvancedCostOptimizationMetrics": {
            "additionalProperties": false,
            "properties": {
                "IsEnabled": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::S3::StorageLens.AdvancedDataProtectionMetrics": {
            "additionalProperties": false,
            "properties": {
                "IsEnabled": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::S3::StorageLens.AwsOrg": {
            "additionalProperties": false,
            "properties": {
                "Arn": {
                    "type": "string"
                }
            },
            "required": [
                "Arn"
            ],
            "type": "object"
        },
        "AWS::S3::StorageLens.BucketLevel": {
            "additionalProperties": false,
            "properties": {
                "ActivityMetrics": {
                    "$ref": "#/definitions/AWS::S3::StorageLens.ActivityMetrics"
                },
                "AdvancedCostOptimizationMetrics": {
                    "$ref": "#/definitions/AWS::S3::StorageLens.AdvancedCostOptimizationMetrics"
                },
                "AdvancedDataProtectionMetrics": {
                    "$ref": "#/definitions/AWS::S3::StorageLens.AdvancedDataProtectionMetrics"
                },
                "DetailedStatusCodesMetrics": {
                    "$ref": "#/definitions/AWS::S3::StorageLens.DetailedStatusCodesMetrics"
                },
                "PrefixLevel": {
                    "$ref": "#/definitions/AWS::S3::StorageLens.PrefixLevel"
                }
            },
            "type": "object"
        },
        "AWS::S3::StorageLens.BucketsAndRegions": {
            "additionalProperties": false,
            "properties": {
                "Buckets": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Regions": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::S3::StorageLens.CloudWatchMetrics": {
            "additionalProperties": false,
            "properties": {
                "IsEnabled": {
                    "type": "boolean"
                }
            },
            "required": [
                "IsEnabled"
            ],
            "type": "object"
        },
        "AWS::S3::StorageLens.DataExport": {
            "additionalProperties": false,
            "properties": {
                "CloudWatchMetrics": {
                    "$ref": "#/definitions/AWS::S3::StorageLens.CloudWatchMetrics"
                },
                "S3BucketDestination": {
                    "$ref": "#/definitions/AWS::S3::StorageLens.S3BucketDestination"
                }
            },
            "type": "object"
        },
        "AWS::S3::StorageLens.DetailedStatusCodesMetrics": {
            "additionalProperties": false,
            "properties": {
                "IsEnabled": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::S3::StorageLens.Encryption": {
            "additionalProperties": false,
            "properties": {
                "SSEKMS": {
                    "$ref": "#/definitions/AWS::S3::StorageLens.SSEKMS"
                },
                "SSES3": {
                    "type": "object"
                }
            },
            "type": "object"
        },
        "AWS::S3::StorageLens.PrefixLevel": {
            "additionalProperties": false,
            "properties": {
                "StorageMetrics": {
                    "$ref": "#/definitions/AWS::S3::StorageLens.PrefixLevelStorageMetrics"
                }
            },
            "required": [
                "StorageMetrics"
            ],
            "type": "object"
        },
        "AWS::S3::StorageLens.PrefixLevelStorageMetrics": {
            "additionalProperties": false,
            "properties": {
                "IsEnabled": {
                    "type": "boolean"
                },
                "SelectionCriteria": {
                    "$ref": "#/definitions/AWS::S3::StorageLens.SelectionCriteria"
                }
            },
            "type": "object"
        },
        "AWS::S3::StorageLens.S3BucketDestination": {
            "additionalProperties": false,
            "properties": {
                "AccountId": {
                    "type": "string"
                },
                "Arn": {
                    "type": "string"
                },
                "Encryption": {
                    "$ref": "#/definitions/AWS::S3::StorageLens.Encryption"
                },
                "Format": {
                    "type": "string"
                },
                "OutputSchemaVersion": {
                    "type": "string"
                },
                "Prefix": {
                    "type": "string"
                }
            },
            "required": [
                "AccountId",
                "Arn",
                "Format",
                "OutputSchemaVersion"
            ],
            "type": "object"
        },
        "AWS::S3::StorageLens.SSEKMS": {
            "additionalProperties": false,
            "properties": {
                "KeyId": {
                    "type": "string"
                }
            },
            "required": [
                "KeyId"
            ],
            "type": "object"
        },
        "AWS::S3::StorageLens.SelectionCriteria": {
            "additionalProperties": false,
            "properties": {
                "Delimiter": {
                    "type": "string"
                },
                "MaxDepth": {
                    "type": "number"
                },
                "MinStorageBytesPercentage": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::S3::StorageLens.StorageLensConfiguration": {
            "additionalProperties": false,
            "properties": {
                "AccountLevel": {
                    "$ref": "#/definitions/AWS::S3::StorageLens.AccountLevel"
                },
                "AwsOrg": {
                    "$ref": "#/definitions/AWS::S3::StorageLens.AwsOrg"
                },
                "DataExport": {
                    "$ref": "#/definitions/AWS::S3::StorageLens.DataExport"
                },
                "Exclude": {
                    "$ref": "#/definitions/AWS::S3::StorageLens.BucketsAndRegions"
                },
                "Id": {
                    "type": "string"
                },
                "Include": {
                    "$ref": "#/definitions/AWS::S3::StorageLens.BucketsAndRegions"
                },
                "IsEnabled": {
                    "type": "boolean"
                },
                "StorageLensArn": {
                    "type": "string"
                }
            },
            "required": [
                "AccountLevel",
                "Id",
                "IsEnabled"
            ],
            "type": "object"
        },
        "AWS::S3::StorageLens.StorageLensGroupLevel": {
            "additionalProperties": false,
            "properties": {
                "StorageLensGroupSelectionCriteria": {
                    "$ref": "#/definitions/AWS::S3::StorageLens.StorageLensGroupSelectionCriteria"
                }
            },
            "type": "object"
        },
        "AWS::S3::StorageLens.StorageLensGroupSelectionCriteria": {
            "additionalProperties": false,
            "properties": {
                "Exclude": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Include": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::S3::StorageLensGroup": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Filter": {
                            "$ref": "#/definitions/AWS::S3::StorageLensGroup.Filter"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "Filter",
                        "Name"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::S3::StorageLensGroup"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::S3::StorageLensGroup.And": {
            "additionalProperties": false,
            "properties": {
                "MatchAnyPrefix": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "MatchAnySuffix": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "MatchAnyTag": {
                    "items": {
                        "$ref": "#/definitions/Tag"
                    },
                    "type": "array"
                },
                "MatchObjectAge": {
                    "$ref": "#/definitions/AWS::S3::StorageLensGroup.MatchObjectAge"
                },
                "MatchObjectSize": {
                    "$ref": "#/definitions/AWS::S3::StorageLensGroup.MatchObjectSize"
                }
            },
            "type": "object"
        },
        "AWS::S3::StorageLensGroup.Filter": {
            "additionalProperties": false,
            "properties": {
                "And": {
                    "$ref": "#/definitions/AWS::S3::StorageLensGroup.And"
                },
                "MatchAnyPrefix": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "MatchAnySuffix": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "MatchAnyTag": {
                    "items": {
                        "$ref": "#/definitions/Tag"
                    },
                    "type": "array"
                },
                "MatchObjectAge": {
                    "$ref": "#/definitions/AWS::S3::StorageLensGroup.MatchObjectAge"
                },
                "MatchObjectSize": {
                    "$ref": "#/definitions/AWS::S3::StorageLensGroup.MatchObjectSize"
                },
                "Or": {
                    "$ref": "#/definitions/AWS::S3::StorageLensGroup.Or"
                }
            },
            "type": "object"
        },
        "AWS::S3::StorageLensGroup.MatchObjectAge": {
            "additionalProperties": false,
            "properties": {
                "DaysGreaterThan": {
                    "type": "number"
                },
                "DaysLessThan": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::S3::StorageLensGroup.MatchObjectSize": {
            "additionalProperties": false,
            "properties": {
                "BytesGreaterThan": {
                    "type": "number"
                },
                "BytesLessThan": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::S3::StorageLensGroup.Or": {
            "additionalProperties": false,
            "properties": {
                "MatchAnyPrefix": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "MatchAnySuffix": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "MatchAnyTag": {
                    "items": {
                        "$ref": "#/definitions/Tag"
                    },
                    "type": "array"
                },
                "MatchObjectAge": {
                    "$ref": "#/definitions/AWS::S3::StorageLensGroup.MatchObjectAge"
                },
                "MatchObjectSize": {
                    "$ref": "#/definitions/AWS::S3::StorageLensGroup.MatchObjectSize"
                }
            },
            "type": "object"
        },
        "AWS::SNS::Subscription": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DeliveryPolicy": {
                            "type": "object"
                        },
                        "Endpoint": {
                            "type": "string"
                        },
                        "FilterPolicy": {
                            "type": "object"
                        },
                        "FilterPolicyScope": {
                            "type": "string"
                        },
                        "Protocol": {
                            "type": "string"
                        },
                        "RawMessageDelivery": {
                            "type": "boolean"
                        },
                        "RedrivePolicy": {
                            "type": "object"
                        },
                        "Region": {
                            "type": "string"
                        },
                        "ReplayPolicy": {
                            "type": "object"
                        },
                        "SubscriptionRoleArn": {
                            "type": "string"
                        },
                        "TopicArn": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Protocol",
                        "TopicArn"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::SNS::Subscription"
                    ],
                    "type": "string"
                },
                "UpdateReplacePolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::SNS::Topic": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ArchivePolicy": {
                            "type": "object"
                        },
                        "ContentBasedDeduplication": {
                            "type": "boolean"
                        },
                        "DataProtectionPolicy": {
                            "type": "object"
                        },
                        "DeliveryStatusLogging": {
                            "items": {
                                "$ref": "#/definitions/AWS::SNS::Topic.LoggingConfig"
                            },
                            "type": "array"
                        },
                        "DisplayName": {
  